/* Generated Fix Gateway message codec */
package uk.co.real_logic.artio.other.decoder_flyweight;

import org.agrona.AsciiNumberFormatException;
import org.agrona.MutableDirectBuffer;
import org.agrona.AsciiSequenceView;
import static uk.co.real_logic.artio.dictionary.generation.CodecUtil.*;
import static uk.co.real_logic.artio.dictionary.SessionConstants.*;
import uk.co.real_logic.artio.builder.Decoder;
import uk.co.real_logic.artio.other.decoder_flyweight.HeaderDecoder;
import uk.co.real_logic.artio.other.decoder_flyweight.TrailerDecoder;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.fields.LocalMktDateEncoder;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import uk.co.real_logic.artio.dictionary.CharArraySet;
import org.agrona.collections.IntHashSet;
import org.agrona.collections.IntHashSet.IntIterator;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.CommonDecoderImpl;
import static java.nio.charset.StandardCharsets.US_ASCII;
import static uk.co.real_logic.artio.builder.Validation.CODEC_VALIDATION_ENABLED;
import static uk.co.real_logic.artio.builder.RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED;
import static uk.co.real_logic.artio.builder.RejectUnknownEnumValue.CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED;
import uk.co.real_logic.artio.other.*;
import uk.co.real_logic.artio.other.builder.ExecutionReportEncoder;
import uk.co.real_logic.artio.other.builder.InstrumentEncoder;


public class ExecutionReportDecoder extends CommonDecoderImpl implements InstrumentDecoder, MessageDecoder
{
    public final IntHashSet REQUIRED_FIELDS = new IntHashSet(12);

    {
        if (CODEC_VALIDATION_ENABLED)
        {
            REQUIRED_FIELDS.add(Constants.ORDER_ID);
            REQUIRED_FIELDS.add(Constants.EXEC_ID);
            REQUIRED_FIELDS.add(Constants.EXEC_TYPE);
            REQUIRED_FIELDS.add(Constants.ORD_STATUS);
            REQUIRED_FIELDS.add(Constants.SYMBOL);
            REQUIRED_FIELDS.add(Constants.SIDE);
        }
    }

    private final IntHashSet alreadyVisitedFields = new IntHashSet(12);

    private final IntHashSet unknownFields = new IntHashSet(10);

    private final IntHashSet missingRequiredFields = new IntHashSet(12);

    public boolean validate()
    {
        if (rejectReason != Decoder.NO_ERROR)
        {
            return false;
        }
        final IntIterator missingFieldsIterator = missingRequiredFields.iterator();
        final IntIterator unknownFieldsIterator = unknownFields.iterator();
        if (CODEC_REJECT_UNKNOWN_FIELD_ENABLED && unknownFieldsIterator.hasNext())
        {
            invalidTagId = unknownFieldsIterator.nextValue();
            rejectReason = Constants.ALL_FIELDS.contains(invalidTagId) ? 2 : 0;
            return false;
        }
        if (!header.validate())
        {
            invalidTagId = header.invalidTagId();
            rejectReason = header.rejectReason();
            return false;
        }
        else if (!trailer.validate())
        {
            invalidTagId = trailer.invalidTagId();
            rejectReason = trailer.rejectReason();
            return false;
        }
        if (missingFieldsIterator.hasNext())
        {
            invalidTagId = missingFieldsIterator.nextValue();
            rejectReason = 1;
            return false;
        }
        if (CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED && !ExecType.isValid(execType()))
        {
            invalidTagId = 150;
            rejectReason = 5;
            return false;
        }

        if (CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED && !OrdStatus.isValid(ordStatus()))
        {
            invalidTagId = 39;
            rejectReason = 5;
            return false;
        }

        if (CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED && !Side.isValid(side()))
        {
            invalidTagId = 54;
            rejectReason = 5;
            return false;
        }
        return true;
    }

    public static final long MESSAGE_TYPE = 56L;

    public static final String MESSAGE_TYPE_AS_STRING = "8";

    public static final char[] MESSAGE_TYPE_CHARS = MESSAGE_TYPE_AS_STRING.toCharArray();

    public static final byte[] MESSAGE_TYPE_BYTES = MESSAGE_TYPE_AS_STRING.getBytes(US_ASCII);

    public final IntHashSet messageFields = new IntHashSet(46);

    {
        messageFields.add(Constants.BEGIN_STRING);
        messageFields.add(Constants.BODY_LENGTH);
        messageFields.add(Constants.MSG_TYPE);
        messageFields.add(Constants.SENDER_COMP_ID);
        messageFields.add(Constants.TARGET_COMP_ID);
        messageFields.add(Constants.MSG_SEQ_NUM);
        messageFields.add(Constants.SENDER_SUB_ID);
        messageFields.add(Constants.SENDER_LOCATION_ID);
        messageFields.add(Constants.TARGET_SUB_ID);
        messageFields.add(Constants.TARGET_LOCATION_ID);
        messageFields.add(Constants.POSS_DUP_FLAG);
        messageFields.add(Constants.POSS_RESEND);
        messageFields.add(Constants.SENDING_TIME);
        messageFields.add(Constants.ORIG_SENDING_TIME);
        messageFields.add(Constants.LAST_MSG_SEQ_NUM_PROCESSED);
        messageFields.add(Constants.TEST_FIELD);
        messageFields.add(Constants.ORDER_ID);
        messageFields.add(Constants.EXEC_ID);
        messageFields.add(Constants.EXEC_TYPE);
        messageFields.add(Constants.ORD_STATUS);
        messageFields.add(Constants.SYMBOL);
        messageFields.add(Constants.SIDE);
        messageFields.add(Constants.CHECK_SUM);
    }

    private final TrailerDecoder trailer = new TrailerDecoder();

    public TrailerDecoder trailer()
    {
        return trailer;
    }

    private final HeaderDecoder header = new HeaderDecoder(trailer);

    public HeaderDecoder header()
    {
        return header;
    }

    private char[] orderID = new char[1];

    public char[] orderID()
    {
        if (buffer != null && orderIDLength > 0)
        {
            orderID = buffer.getChars(orderID, orderIDOffset, orderIDLength);
        }
        return orderID;
    }


    private int orderIDOffset;

    private int orderIDLength;

    public int orderIDLength()
    {
        return orderIDLength;
    }

    public String orderIDAsString()
    {
        return buffer != null ? buffer.getStringWithoutLengthAscii(orderIDOffset, orderIDLength) : "";
    }

    public void orderID(final AsciiSequenceView view)
    {
        view.wrap(buffer, orderIDOffset, orderIDLength);
    }


    private final CharArrayWrapper orderIDWrapper = new CharArrayWrapper();
    private char[] execID = new char[1];

    public char[] execID()
    {
        if (buffer != null && execIDLength > 0)
        {
            execID = buffer.getChars(execID, execIDOffset, execIDLength);
        }
        return execID;
    }


    private int execIDOffset;

    private int execIDLength;

    public int execIDLength()
    {
        return execIDLength;
    }

    public String execIDAsString()
    {
        return buffer != null ? buffer.getStringWithoutLengthAscii(execIDOffset, execIDLength) : "";
    }

    public void execID(final AsciiSequenceView view)
    {
        view.wrap(buffer, execIDOffset, execIDLength);
    }


    private final CharArrayWrapper execIDWrapper = new CharArrayWrapper();
    private char execType = MISSING_CHAR;

    public char execType()
    {
        return execType;
    }



    private final CharArrayWrapper execTypeWrapper = new CharArrayWrapper();
    public ExecType execTypeAsEnum()
    {
        return ExecType.decode(execType);
    }

    private char ordStatus = MISSING_CHAR;

    public char ordStatus()
    {
        return ordStatus;
    }



    private final CharArrayWrapper ordStatusWrapper = new CharArrayWrapper();
    public OrdStatus ordStatusAsEnum()
    {
        return OrdStatus.decode(ordStatus);
    }


    private char[] symbol = new char[1];

    public char[] symbol()
    {
        if (buffer != null && symbolLength > 0)
        {
            symbol = buffer.getChars(symbol, symbolOffset, symbolLength);
        }
        return symbol;
    }


    private int symbolOffset;

    private int symbolLength;

    public int symbolLength()
    {
        return symbolLength;
    }

    public String symbolAsString()
    {
        return buffer != null ? buffer.getStringWithoutLengthAscii(symbolOffset, symbolLength) : "";
    }

    public void symbol(final AsciiSequenceView view)
    {
        view.wrap(buffer, symbolOffset, symbolLength);
    }


    private final CharArrayWrapper symbolWrapper = new CharArrayWrapper();

    private char side = MISSING_CHAR;

    public char side()
    {
        return side;
    }



    private final CharArrayWrapper sideWrapper = new CharArrayWrapper();
    public Side sideAsEnum()
    {
        return Side.decode(side);
    }

    public int decode(final AsciiBuffer buffer, final int offset, final int length)
    {
        // Decode ExecutionReport
        int seenFieldCount = 0;
        if (CODEC_VALIDATION_ENABLED)
        {
            missingRequiredFields.copy(REQUIRED_FIELDS);
            alreadyVisitedFields.clear();
        }
        this.buffer = buffer;
        final int end = offset + length;
        int position = offset;
        position += header.decode(buffer, position, length);
        int tag;

        while (position < end)
        {
            final int equalsPosition = buffer.scan(position, end, '=');
            if (equalsPosition == AsciiBuffer.UNKNOWN_INDEX)
            {
               return position;
            }
            tag = buffer.getInt(position, equalsPosition);
            final int valueOffset = equalsPosition + 1;
            int endOfField = buffer.scan(valueOffset, end, START_OF_HEADER);
            if (endOfField == AsciiBuffer.UNKNOWN_INDEX || equalsPosition == AsciiBuffer.UNKNOWN_INDEX)
            {
                rejectReason = 5;
                break;
            }
            final int valueLength = endOfField - valueOffset;
            if (CODEC_VALIDATION_ENABLED)
            {
                if (tag <= 0)
                {
                    invalidTagId = tag;
                    rejectReason = 0;
                }
                else if (valueLength == 0)
                {
                    invalidTagId = tag;
                    rejectReason = 4;
                }
                if (!alreadyVisitedFields.add(tag))
                {
                    invalidTagId = tag;
                    rejectReason = 13;
                }
                missingRequiredFields.remove(tag);
                seenFieldCount++;
            }

            switch (tag)
            {
            case Constants.ORDER_ID:
                orderIDOffset = valueOffset;
                orderIDLength = valueLength;
                break;

            case Constants.EXEC_ID:
                execIDOffset = valueOffset;
                execIDLength = valueLength;
                break;

            case Constants.EXEC_TYPE:
                execType = buffer.getChar(valueOffset);
                break;

            case Constants.ORD_STATUS:
                ordStatus = buffer.getChar(valueOffset);
                break;

            case Constants.SYMBOL:
                symbolOffset = valueOffset;
                symbolLength = valueLength;
                break;


            case Constants.SIDE:
                side = buffer.getChar(valueOffset);
                break;

            default:
                if (!CODEC_REJECT_UNKNOWN_FIELD_ENABLED)
                {
                    alreadyVisitedFields.remove(tag);
                }
                else
                {
                    if (!(trailer.REQUIRED_FIELDS.contains(tag)))
                    {
                        unknownFields.add(tag);
                    }
                }
                if (CODEC_REJECT_UNKNOWN_FIELD_ENABLED || (trailer.REQUIRED_FIELDS.contains(tag)))
                {
                    position += trailer.decode(buffer, position, end - position);
                    return position - offset;
                }

            }

            if (position < (endOfField + 1))
            {
                position = endOfField + 1;
            }
        }
        position += trailer.decode(buffer, position, end - position);
        return position - offset;
    }

    public void reset()
    {
        header.reset();
        trailer.reset();
        resetMessage();
        buffer = null;
        if (CODEC_VALIDATION_ENABLED)
        {
            invalidTagId = Decoder.NO_ERROR;
            rejectReason = Decoder.NO_ERROR;
            missingRequiredFields.clear();
            unknownFields.clear();
            alreadyVisitedFields.clear();
        }
    }

    public void resetMessage()
    {
        this.resetOrderID();
        this.resetExecID();
        this.resetExecType();
        this.resetOrdStatus();
        this.resetSide();
        this.resetSymbol();
    }

    public void resetOrderID()
    {
        orderIDOffset = 0;
        orderIDLength = 0;
    }

    public void resetExecID()
    {
        execIDOffset = 0;
        execIDLength = 0;
    }

    public void resetExecType()
    {
        execType = MISSING_CHAR;
    }

    public void resetOrdStatus()
    {
        ordStatus = MISSING_CHAR;
    }

    public void resetSide()
    {
        side = MISSING_CHAR;
    }

    public void resetSymbol()
    {
        symbolOffset = 0;
        symbolLength = 0;
    }

    public String toString()
    {
        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        return appendTo(builder, 1);
    }

    public StringBuilder appendTo(final StringBuilder builder, final int level)
    {
        builder.append("{\n");        indent(builder, level);
        builder.append("\"MessageName\": \"ExecutionReport\",\n");
        builder.append("  \"header\": ");
        header.appendTo(builder, level + 1);
        builder.append("\n");
        indent(builder, level);
        builder.append("\"OrderID\": \"");
        builder.append(this.orderID(), 0, orderIDLength());
        builder.append("\",\n");

        indent(builder, level);
        builder.append("\"ExecID\": \"");
        builder.append(this.execID(), 0, execIDLength());
        builder.append("\",\n");

        indent(builder, level);
        builder.append("\"ExecType\": \"");
        builder.append(this.execType());
        builder.append("\",\n");

        indent(builder, level);
        builder.append("\"OrdStatus\": \"");
        builder.append(this.ordStatus());
        builder.append("\",\n");

        indent(builder, level);
        builder.append("\"Symbol\": \"");
        builder.append(this.symbol(), 0, symbolLength());
        builder.append("\",\n");

        indent(builder, level);
        builder.append("\"Side\": \"");
        builder.append(this.side());
        builder.append("\",\n");
        indent(builder, level - 1);
        builder.append("}");
        return builder;
    }

    /**
     * {@inheritDoc}
     */
    public ExecutionReportEncoder toEncoder(final Encoder encoder)
    {
        return toEncoder((ExecutionReportEncoder)encoder);
    }

    public ExecutionReportEncoder toEncoder(final ExecutionReportEncoder encoder)
    {
        encoder.reset();
        encoder.orderID(this.orderID(), 0, orderIDLength());
        encoder.execID(this.execID(), 0, execIDLength());
        encoder.execType(this.execType());
        encoder.ordStatus(this.ordStatus());

        final InstrumentEncoder instrument = encoder.instrument();        instrument.symbol(this.symbol(), 0, symbolLength());

        encoder.side(this.side());        return encoder;
    }

}
