/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import java.io.PrintStream;
import uk.co.real_logic.sbe.xml.ParserOptions;

public class ErrorHandler {
    private final PrintStream out;
    private final boolean stopOnError;
    private final boolean warningsFatal;
    private final boolean suppressOutput;
    private int errors = 0;
    private int warnings = 0;

    public ErrorHandler(PrintStream stream, ParserOptions options) {
        this.out = stream;
        this.stopOnError = options.stopOnError();
        this.warningsFatal = options.warningsFatal();
        this.suppressOutput = options.suppressOutput();
    }

    public ErrorHandler(ParserOptions options) {
        this(options.errorPrintStream() != null ? options.errorPrintStream() : System.err, options);
    }

    public void error(String msg) {
        ++this.errors;
        if (!this.suppressOutput) {
            this.out.println("ERROR: " + msg);
        }
        if (this.stopOnError) {
            throw new IllegalArgumentException(msg);
        }
    }

    public void warning(String msg) {
        ++this.warnings;
        if (!this.suppressOutput) {
            this.out.println("WARNING: " + msg);
        }
        if (this.warningsFatal && this.stopOnError) {
            throw new IllegalArgumentException(msg);
        }
    }

    public void checkIfShouldExit() {
        if (this.errors > 0) {
            throw new IllegalStateException("had " + this.errors + " errors");
        }
        if (this.warnings > 0 && this.warningsFatal) {
            throw new IllegalStateException("had " + this.warnings + " warnings");
        }
    }

    public int errorCount() {
        return this.errors;
    }

    public int warningCount() {
        return this.warnings;
    }

    public String toString() {
        return "ErrorHandler{out=" + this.out + ", stopOnError=" + this.stopOnError + ", warningsFatal=" + this.warningsFatal + ", suppressOutput=" + this.suppressOutput + ", errors=" + this.errors + ", warnings=" + this.warnings + '}';
    }
}

