/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.validation;

import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.fields.RejectReason;
import uk.co.real_logic.artio.validation.MessageValidationStrategy;

final class TargetCompIdValidationStrategy
implements MessageValidationStrategy {
    private final char[] gatewayCompId;

    TargetCompIdValidationStrategy(String gatewayCompId) {
        this.gatewayCompId = gatewayCompId.toCharArray();
    }

    @Override
    public boolean validate(SessionHeaderDecoder header) {
        return CodecUtil.equals(header.targetCompID(), this.gatewayCompId, header.targetCompIDLength());
    }

    @Override
    public int invalidTagId() {
        return 56;
    }

    @Override
    public int rejectReason() {
        return RejectReason.COMPID_PROBLEM.representation();
    }
}

