/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.validation;

import java.util.Collection;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.validation.NoMessageValidationStrategy;
import uk.co.real_logic.artio.validation.SenderCompIdValidationStrategy;
import uk.co.real_logic.artio.validation.TargetCompIdValidationStrategy;

public interface MessageValidationStrategy {
    public static MessageValidationStrategy none() {
        return new NoMessageValidationStrategy();
    }

    public static MessageValidationStrategy senderCompId(Collection<String> validSenderIds) {
        return new SenderCompIdValidationStrategy(validSenderIds);
    }

    public static MessageValidationStrategy targetCompId(String gatewayCompId) {
        return new TargetCompIdValidationStrategy(gatewayCompId);
    }

    public boolean validate(SessionHeaderDecoder var1);

    public int invalidTagId();

    public int rejectReason();

    default public MessageValidationStrategy and(final MessageValidationStrategy right) {
        final MessageValidationStrategy left = this;
        return new MessageValidationStrategy(){
            private int invalidTagId;
            private int rejectReason;

            @Override
            public boolean validate(SessionHeaderDecoder header) {
                boolean leftValid = left.validate(header);
                if (leftValid) {
                    boolean rightValid = right.validate(header);
                    if (rightValid) {
                        return true;
                    }
                    this.invalidTagId = right.invalidTagId();
                    this.rejectReason = right.rejectReason();
                } else {
                    this.invalidTagId = left.invalidTagId();
                    this.rejectReason = left.rejectReason();
                }
                return false;
            }

            @Override
            public int invalidTagId() {
                return this.invalidTagId;
            }

            @Override
            public int rejectReason() {
                return this.rejectReason;
            }
        };
    }
}

