/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.util;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.agrona.AsciiEncoding;
import org.agrona.AsciiNumberFormatException;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.fields.LocalMktDateDecoder;
import uk.co.real_logic.artio.fields.ReadOnlyDecimalFloat;
import uk.co.real_logic.artio.fields.UtcDateOnlyDecoder;
import uk.co.real_logic.artio.fields.UtcTimeOnlyDecoder;
import uk.co.real_logic.artio.fields.UtcTimestampDecoder;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MessageTypeEncoding;
import uk.co.real_logic.artio.util.float_parsing.AsciiBufferCharReader;
import uk.co.real_logic.artio.util.float_parsing.DecimalFloatParser;

public final class MutableAsciiBuffer
extends UnsafeBuffer
implements AsciiBuffer {
    private static final byte ZERO = 48;
    private static final byte DOT = 46;
    private static final byte Y = 89;
    private static final byte N = 78;

    public MutableAsciiBuffer() {
        super(0L, 0);
    }

    public MutableAsciiBuffer(byte[] buffer) {
        super(buffer);
    }

    public MutableAsciiBuffer(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public MutableAsciiBuffer(ByteBuffer buffer) {
        super(buffer);
    }

    public MutableAsciiBuffer(ByteBuffer buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public MutableAsciiBuffer(DirectBuffer buffer) {
        super(buffer);
    }

    public MutableAsciiBuffer(DirectBuffer buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public MutableAsciiBuffer(long address, int length) {
        super(address, length);
    }

    @Override
    public int getNatural(int startInclusive, int endExclusive) {
        return super.parseNaturalIntAscii(startInclusive, endExclusive - startInclusive);
    }

    @Override
    public long getNaturalLong(int startInclusive, int endExclusive) {
        return super.parseNaturalLongAscii(startInclusive, endExclusive - startInclusive);
    }

    @Override
    public int getInt(int startInclusive, int endExclusive) {
        int length = endExclusive - startInclusive;
        if (length == 0) {
            return Integer.MIN_VALUE;
        }
        return super.parseIntAscii(startInclusive, length);
    }

    @Override
    public int getDigit(int index) {
        byte value = this.getByte(index);
        return this.getDigit(index, value);
    }

    @Override
    public boolean isDigit(int index) {
        byte value = this.getByte(index);
        return value >= 48 && value <= 57;
    }

    private int getDigit(int index, byte value) {
        if (value < 48 || value > 57) {
            throw new AsciiNumberFormatException("'" + (char)value + "' isn't a valid digit @ " + index);
        }
        return value - 48;
    }

    @Override
    public char getChar(int index) {
        return (char)this.getByte(index);
    }

    @Override
    public boolean getBoolean(int index) {
        return 89 == this.getByte(index);
    }

    @Override
    public byte[] getBytes(byte[] oldBuffer, int offset, int length) {
        byte[] resultBuffer = oldBuffer.length < length ? new byte[length] : oldBuffer;
        this.getBytes(offset, resultBuffer, 0, length);
        return resultBuffer;
    }

    @Override
    public char[] getChars(char[] oldBuffer, int offset, int length) {
        char[] resultBuffer = oldBuffer.length < length ? new char[length] : oldBuffer;
        for (int i = 0; i < length; ++i) {
            resultBuffer[i] = this.getChar(i + offset);
        }
        return resultBuffer;
    }

    @Override
    public String getAscii(int offset, int length) {
        byte[] buff = new byte[length];
        this.getBytes(offset, buff);
        return new String(buff, 0, length, StandardCharsets.US_ASCII);
    }

    @Override
    public long getMessageType(int offset, int length) {
        return MessageTypeEncoding.packMessageType(this.byteArray(), this.addressOffset(), offset, length);
    }

    @Override
    public DecimalFloat getFloat(DecimalFloat number, int offset, int length) {
        return DecimalFloatParser.extract(number, AsciiBufferCharReader.INSTANCE, this, offset, length);
    }

    @Override
    public int getLocalMktDate(int offset, int length) {
        return LocalMktDateDecoder.decode(this, offset, length);
    }

    @Override
    public long getUtcTimestamp(int offset, int length) {
        return UtcTimestampDecoder.decode(this, offset, length, true);
    }

    @Override
    public long getUtcTimeOnly(int offset, int length) {
        return UtcTimeOnlyDecoder.decode(this, offset, length, true);
    }

    @Override
    public int getUtcDateOnly(int offset) {
        return UtcDateOnlyDecoder.decode(this, offset);
    }

    @Override
    public int scanBack(int startInclusive, int endExclusive, char terminatingCharacter) {
        return this.scanBack(startInclusive, endExclusive, (byte)terminatingCharacter);
    }

    @Override
    public int scanBack(int startInclusive, int endExclusive, byte terminator) {
        for (int index = startInclusive; index > endExclusive; --index) {
            byte value = this.getByte(index);
            if (value != terminator) continue;
            return index;
        }
        return -1;
    }

    @Override
    public int scan(int startInclusive, int endExclusive, char terminatingCharacter) {
        return this.scan(startInclusive, endExclusive, (byte)terminatingCharacter);
    }

    @Override
    public int scan(int startInclusive, int endExclusive, byte terminator) {
        int indexValue = -1;
        for (int i = startInclusive; i < endExclusive; ++i) {
            byte value = this.getByte(i);
            if (value != terminator) continue;
            indexValue = i;
            break;
        }
        return indexValue;
    }

    @Override
    public int computeChecksum(int startInclusive, int endExclusive) {
        int total = 0;
        for (int index = startInclusive; index < endExclusive; ++index) {
            total += this.getByte(index);
        }
        return total % 256;
    }

    public int putAscii(int index, String string) {
        byte[] bytes = string.getBytes(StandardCharsets.US_ASCII);
        this.putBytes(index, bytes);
        return bytes.length;
    }

    public void putSeparator(int index) {
        this.putByte(index, (byte)1);
    }

    public int putBooleanAscii(int offset, boolean value) {
        this.putByte(offset, value ? (byte)89 : 78);
        return 1;
    }

    public static int lengthInAscii(int value) {
        int characterCount = 0;
        for (int remainder = value; remainder > 0; remainder /= 10) {
            ++characterCount;
        }
        return characterCount;
    }

    public int putCharAscii(int index, char value) {
        this.putByte(index, (byte)value);
        return 1;
    }

    public int putFloatAscii(int offset, ReadOnlyDecimalFloat price) {
        return this.putFloatAscii(offset, price.value(), price.scale());
    }

    public int putFloatAscii(int offset, long value, int scale) {
        int length;
        if (ReadOnlyDecimalFloat.isNaNValue(value, scale)) {
            throw new IllegalArgumentException("You cannot encode NaN into a buffer - it's not a number");
        }
        if (value == 0L) {
            return this.handleZero(offset, scale);
        }
        long remainder = this.calculateRemainderAndPutMinus(offset, value);
        int minusAdj = value < 0L ? 1 : 0;
        int start = offset + minusAdj;
        int n = length = remainder == Long.MIN_VALUE ? AsciiEncoding.MIN_LONG_VALUE.length - 1 : AsciiEncoding.digitCount(-remainder);
        if (length <= scale) {
            this.putByte(start, (byte)48);
            this.putByte(start + 1, (byte)46);
            this.putTrailingZero(start + 2, scale - length);
            this.putLong(remainder, start + scale + 1);
            return minusAdj + scale + 2;
        }
        if (scale > 0) {
            this.putLong(remainder, start + length + 1 - 1, scale);
            return minusAdj + length + 1;
        }
        this.putLong(remainder, start + length - 1);
        this.putTrailingZero(start + length, -scale);
        return minusAdj + length - scale;
    }

    private void putTrailingZero(int offset, int zerosCount) {
        for (int ix = 0; ix < zerosCount; ++ix) {
            this.putByte(offset + ix, (byte)48);
        }
    }

    private int handleZero(int offset, int scale) {
        this.putByte(offset, (byte)48);
        if (scale <= 0) {
            return 1;
        }
        this.putByte(offset + 1, (byte)46);
        this.putTrailingZero(offset + 2, scale);
        return 2 + scale;
    }

    private long calculateRemainderAndPutMinus(int offset, long value) {
        if (value < 0L) {
            this.putChar(offset, '-');
            return value;
        }
        return -1L * value;
    }

    private int putLong(long remainder, int end) {
        int index = end;
        while (remainder < 0L) {
            long digit = remainder % 10L;
            remainder /= 10L;
            this.putByte(index, (byte)(48L + -1L * digit));
            --index;
        }
        return index;
    }

    private int putLong(long remainder, int end, int scale) {
        int index = end;
        while (remainder < 0L) {
            if (scale == 0) {
                this.putByte(index, (byte)46);
            } else {
                long digit = remainder % 10L;
                remainder /= 10L;
                this.putByte(index, (byte)(48L + -1L * digit));
            }
            --index;
            --scale;
        }
        return index;
    }
}

