/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.session;

import io.aeron.logbuffer.ControlledFragmentHandler;
import java.lang.ref.WeakReference;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.library.OnMessageInfo;
import uk.co.real_logic.artio.messages.CancelOnDisconnectOption;
import uk.co.real_logic.artio.messages.ConnectionType;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.FixSessionOwner;
import uk.co.real_logic.artio.session.ParsedAddress;
import uk.co.real_logic.artio.session.ResendRequestController;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.session.SessionCustomisationStrategy;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.session.SessionProxy;
import uk.co.real_logic.artio.session.SessionWriter;
import uk.co.real_logic.artio.util.CharFormatter;
import uk.co.real_logic.artio.util.EpochFractionClock;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class InternalSession
extends Session
implements AutoCloseable {
    public static final boolean INITIAL_AWAITING_RESEND = false;
    public static final int INITIAL_LAST_RESENT_MSG_SEQ_NO = 0;
    public static final int INITIAL_LAST_RESEND_CHUNK_MSG_SEQ_NUM = 0;
    public static final int INITIAL_END_OF_RESEND_REQUEST_RANGE = 0;
    public static final boolean INITIAL_AWAITING_HEARTBEAT = false;

    public InternalSession(int heartbeatIntervalInS, long connectionId, EpochNanoClock clock, SessionState state, boolean initiatorResetSeqNum, SessionProxy proxy, GatewayPublication inboundPublication, GatewayPublication outboundPublication, SessionIdStrategy sessionIdStrategy, long sendingTimeWindowInMs, AtomicCounter receivedMsgSeqNo, AtomicCounter sentMsgSeqNo, int libraryId, int initialSentSequenceNumber, int sequenceIndex, long reasonableTransmissionTimeInMs, MutableAsciiBuffer asciiBuffer, boolean enableLastMsgSeqNumProcessed, SessionCustomisationStrategy customisationStrategy, OnMessageInfo messageInfo, EpochFractionClock epochFractionClock, ConnectionType connectionType, boolean backpressureMessagesDuringReplay, ResendRequestController resendRequestController, int forcedHeartbeatIntervalInS, Formatters formatters) {
        super(heartbeatIntervalInS, connectionId, clock, state, initiatorResetSeqNum, proxy, inboundPublication, outboundPublication, sessionIdStrategy, sendingTimeWindowInMs, receivedMsgSeqNo, sentMsgSeqNo, libraryId, initialSentSequenceNumber, sequenceIndex, reasonableTransmissionTimeInMs, asciiBuffer, enableLastMsgSeqNumProcessed, customisationStrategy, messageInfo, epochFractionClock, connectionType, backpressureMessagesDuringReplay, resendRequestController, forcedHeartbeatIntervalInS, formatters);
    }

    @Override
    public int poll(long timeInNs) {
        return super.poll(timeInNs);
    }

    @Override
    public void disable() {
        super.disable();
    }

    @Override
    public void libraryConnected(boolean libraryConnected) {
        super.libraryConnected(libraryConnected);
    }

    @Override
    public void sessionProcessHandler(FixSessionOwner fixSessionOwner) {
        super.sessionProcessHandler(fixSessionOwner);
    }

    public void address(String address) {
        ParsedAddress parsed = ParsedAddress.parse(address);
        this.address(parsed.host(), parsed.port());
    }

    @Override
    public void address(String host, int port) {
        super.address(host, port);
    }

    @Override
    public void username(String username) {
        super.username(username);
    }

    @Override
    public void password(String password) {
        super.password(password);
    }

    @Override
    public void lastLogonTimeInNs(long logonTimeInNs) {
        super.lastLogonTimeInNs(logonTimeInNs);
    }

    @Override
    public void awaitingResend(boolean awaitingResend) {
        super.awaitingResend(awaitingResend);
    }

    @Override
    public void closedResendInterval(boolean closedResendInterval) {
        super.closedResendInterval(closedResendInterval);
    }

    @Override
    public void resendRequestChunkSize(int resendRequestChunkSize) {
        super.resendRequestChunkSize(resendRequestChunkSize);
    }

    @Override
    public void sendRedundantResendRequests(boolean sendRedundantResendRequests) {
        super.sendRedundantResendRequests(sendRedundantResendRequests);
    }

    @Override
    public void updateLastMessageProcessed() {
        super.updateLastMessageProcessed();
    }

    @Override
    public void initialLastReceivedMsgSeqNum(int lastReceivedMsgSeqNum) {
        super.initialLastReceivedMsgSeqNum(lastReceivedMsgSeqNum);
    }

    @Override
    public ControlledFragmentHandler.Action onInvalidMessage(int refSeqNum, int refTagId, char[] refMsgType, int refMsgTypeLength, int rejectReason, long position) {
        return super.onInvalidMessage(refSeqNum, refTagId, refMsgType, refMsgTypeLength, rejectReason, position);
    }

    @Override
    public void lastResentMsgSeqNo(int lastResentMsgSeqNo) {
        super.lastResentMsgSeqNo(lastResentMsgSeqNo);
    }

    @Override
    public void lastResendChunkMsgSeqNum(int lastResendChunkMsgSeqNum) {
        super.lastResendChunkMsgSeqNum(lastResendChunkMsgSeqNum);
    }

    @Override
    public void lastSequenceResetTimeInNs(long lastSequenceResetTimeInNs) {
        super.lastSequenceResetTimeInNs(lastSequenceResetTimeInNs);
    }

    @Override
    public void endOfResendRequestRange(int endOfResendRequestRange) {
        super.endOfResendRequestRange(endOfResendRequestRange);
    }

    @Override
    public void awaitingHeartbeat(boolean awaitingHeartbeat) {
        super.awaitingHeartbeat(awaitingHeartbeat);
    }

    @Override
    public int lastResendChunkMsgSeqNum() {
        return super.lastResendChunkMsgSeqNum();
    }

    @Override
    public int endOfResendRequestRange() {
        return super.endOfResendRequestRange();
    }

    @Override
    public int lastResentMsgSeqNo() {
        return super.lastResentMsgSeqNo();
    }

    @Override
    public void fixDictionary(FixDictionary fixDictionary) {
        super.fixDictionary(fixDictionary);
    }

    @Override
    public void setupSession(long sessionId, CompositeKey sessionKey, WeakReference<SessionWriter> sessionWriterRef) {
        super.setupSession(sessionId, sessionKey, sessionWriterRef);
    }

    public void linkTo(SessionWriter sessionWriter) {
        sessionWriter.linkTo(this);
    }

    public static void closeWriter(SessionWriter writer) {
        writer.close();
    }

    @Override
    public void close() {
        super.close();
    }

    public void onReconnect(long connectionId, SessionState sessionState, int heartbeatIntervalInS, int sequenceIndex, boolean enableLastMsgSeqNumProcessed, FixDictionary fixDictionary, String address, FixCounters counters, ConnectionType connectionType) {
        this.connectionId(connectionId);
        this.state(sessionState);
        this.heartbeatIntervalInS(heartbeatIntervalInS);
        this.sequenceIndex(sequenceIndex);
        this.enableLastMsgSeqNumProcessed(enableLastMsgSeqNumProcessed);
        this.fixDictionary(fixDictionary);
        this.address(address);
        this.refreshSequenceNumberCounters(counters);
        this.awaitingLogonReply(false);
        this.connectionType = connectionType;
    }

    @Override
    public void lastReceivedMsgSeqNumOnly(int value) {
        super.lastReceivedMsgSeqNumOnly(value);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public OnMessageInfo messageInfo() {
        return super.messageInfo();
    }

    @Override
    public boolean areCountersClosed() {
        return super.areCountersClosed();
    }

    @Override
    public void cancelOnDisconnectOption(CancelOnDisconnectOption cancelOnDisconnectOption) {
        super.cancelOnDisconnectOption(cancelOnDisconnectOption);
    }

    @Override
    public void cancelOnDisconnectTimeoutWindowInNs(long cancelOnDisconnectTimeoutWindowInNs) {
        super.cancelOnDisconnectTimeoutWindowInNs(cancelOnDisconnectTimeoutWindowInNs);
    }

    public boolean onThrottleNotification(long refMsgType, int refSeqNum, DirectBuffer businessRejectRefIDBuffer, int businessRejectRefIDOffset, int businessRejectRefIDLength) {
        this.incNextReceivedInboundMessageTime(this.timeInNs());
        this.lastReceivedMsgSeqNum(refSeqNum);
        int sequenceNumber = this.newSentSeqNum();
        long position = this.outboundPublication.saveThrottleReject(this.libraryId, this.connectionId, refMsgType, refSeqNum, sequenceNumber, this.id(), this.sequenceIndex(), businessRejectRefIDBuffer, businessRejectRefIDOffset, businessRejectRefIDLength);
        if (position > 0L) {
            this.lastSentMsgSeqNum(sequenceNumber);
            return true;
        }
        return false;
    }

    @Override
    public void isSlowConsumer(boolean hasBecomeSlow) {
        super.isSlowConsumer(hasBecomeSlow);
    }

    @Override
    public long logoutAndDisconnect(DisconnectReason reason) {
        return super.logoutAndDisconnect(reason);
    }

    @Override
    public long requestDisconnect(DisconnectReason reason) {
        return super.requestDisconnect(reason);
    }

    @Override
    public void onReplayComplete(long correlationId) {
        super.onReplayComplete(correlationId);
    }

    public void onSessionWriterLogout() {
        if (this.state() == SessionState.AWAITING_ASYNC_PROXY_LOGOUT) {
            this.requestDisconnect(DisconnectReason.LOGOUT);
        } else {
            this.onStartLogout();
        }
    }

    public ConnectionType connectionType() {
        return this.connectionType;
    }

    public static class Formatters {
        final CharFormatter replayComplete = new CharFormatter("Sess.replayComplete: replaysInFlight=%s,conn=%s,corr=%s");
    }
}

