/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.protocol;

import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.ReplayCompleteDecoder;
import uk.co.real_logic.artio.messages.StartReplayDecoder;
import uk.co.real_logic.artio.protocol.ReplayProtocolHandler;

public final class ReplayProtocolSubscription
implements ControlledFragmentHandler {
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final ReplayCompleteDecoder replayComplete = new ReplayCompleteDecoder();
    private final StartReplayDecoder startReplay = new StartReplayDecoder();
    private final ReplayProtocolHandler handler;

    public ReplayProtocolSubscription(ReplayProtocolHandler handler) {
        this.handler = handler;
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        return this.onFragment(buffer, offset, length, header.position());
    }

    private ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, long position) {
        this.messageHeader.wrap(buffer, offset);
        int blockLength = this.messageHeader.blockLength();
        int version = this.messageHeader.version();
        offset += 8;
        switch (this.messageHeader.templateId()) {
            case 45: {
                return this.onReplayComplete(buffer, offset, blockLength, version);
            }
            case 75: {
                return this.onStartReplay(buffer, offset, blockLength, version, position);
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onReplayComplete(DirectBuffer buffer, int offset, int blockLength, int version) {
        ReplayCompleteDecoder replayComplete = this.replayComplete;
        replayComplete.wrap(buffer, offset, blockLength, version);
        return this.handler.onReplayComplete(replayComplete.connection(), replayComplete.correlationId());
    }

    private ControlledFragmentHandler.Action onStartReplay(DirectBuffer buffer, int offset, int blockLength, int version, long position) {
        StartReplayDecoder startReplay = this.startReplay;
        startReplay.wrap(buffer, offset, blockLength, version);
        return this.handler.onStartReplay(startReplay.session(), startReplay.connection(), startReplay.correlationId(), position);
    }
}

