/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.protocol;

import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.messages.ApplicationHeartbeatDecoder;
import uk.co.real_logic.artio.messages.AwaitingResend;
import uk.co.real_logic.artio.messages.Bool;
import uk.co.real_logic.artio.messages.CancelOnDisconnectTriggerDecoder;
import uk.co.real_logic.artio.messages.FollowerSessionRequestDecoder;
import uk.co.real_logic.artio.messages.InitiateConnectionDecoder;
import uk.co.real_logic.artio.messages.InitiateILinkConnectionDecoder;
import uk.co.real_logic.artio.messages.LibraryConnectDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MidConnectionDisconnectDecoder;
import uk.co.real_logic.artio.messages.ReadMetaDataDecoder;
import uk.co.real_logic.artio.messages.ReleaseSessionDecoder;
import uk.co.real_logic.artio.messages.ReplayMessagesDecoder;
import uk.co.real_logic.artio.messages.RequestDisconnectDecoder;
import uk.co.real_logic.artio.messages.RequestSessionDecoder;
import uk.co.real_logic.artio.messages.ResetSequenceNumber;
import uk.co.real_logic.artio.messages.SeqIndexSyncDecoder;
import uk.co.real_logic.artio.messages.ThrottleConfigurationDecoder;
import uk.co.real_logic.artio.messages.ThrottleRejectDecoder;
import uk.co.real_logic.artio.messages.ValidResendRequestDecoder;
import uk.co.real_logic.artio.messages.WriteMetaDataDecoder;
import uk.co.real_logic.artio.protocol.EngineEndPointHandler;

public final class EngineProtocolSubscription
implements ControlledFragmentHandler {
    private static final int FOLLOWER_SESSION_REQUEST_LENGTH = 14 + FollowerSessionRequestDecoder.headerHeaderLength();
    private static final int WRITE_META_DATA_DATA_LENGTH = 24 + WriteMetaDataDecoder.metaDataHeaderLength();
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final InitiateConnectionDecoder initiateConnection = new InitiateConnectionDecoder();
    private final RequestDisconnectDecoder requestDisconnect = new RequestDisconnectDecoder();
    private final MidConnectionDisconnectDecoder midConnectionDisconnect = new MidConnectionDisconnectDecoder();
    private final ApplicationHeartbeatDecoder applicationHeartbeat = new ApplicationHeartbeatDecoder();
    private final LibraryConnectDecoder libraryConnect = new LibraryConnectDecoder();
    private final ReleaseSessionDecoder releaseSession = new ReleaseSessionDecoder();
    private final RequestSessionDecoder requestSession = new RequestSessionDecoder();
    private final FollowerSessionRequestDecoder followerSessionRequest = new FollowerSessionRequestDecoder();
    private final WriteMetaDataDecoder writeMetaData = new WriteMetaDataDecoder();
    private final ReadMetaDataDecoder readMetaData = new ReadMetaDataDecoder();
    private final ReplayMessagesDecoder replayMessages = new ReplayMessagesDecoder();
    private final InitiateILinkConnectionDecoder initiateILinkConnection = new InitiateILinkConnectionDecoder();
    private final CancelOnDisconnectTriggerDecoder cancelOnDisconnectTrigger = new CancelOnDisconnectTriggerDecoder();
    private final ThrottleRejectDecoder throttleReject = new ThrottleRejectDecoder();
    private final ThrottleConfigurationDecoder throttleConfiguration = new ThrottleConfigurationDecoder();
    private final SeqIndexSyncDecoder seqIndexSync = new SeqIndexSyncDecoder();
    private final ValidResendRequestDecoder validResendRequest = new ValidResendRequestDecoder();
    private final EngineEndPointHandler handler;

    public EngineProtocolSubscription(EngineEndPointHandler handler) {
        this.handler = handler;
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeader.wrap(buffer, offset);
        int blockLength = this.messageHeader.blockLength();
        int version = this.messageHeader.version();
        offset += this.messageHeader.encodedLength();
        switch (this.messageHeader.templateId()) {
            case 12: {
                return this.onRequestDisconnect(buffer, offset, blockLength, version, header);
            }
            case 11: {
                return this.onInitiateConnection(buffer, offset, blockLength, version, header);
            }
            case 16: {
                return this.onApplicationHeartbeat(buffer, offset, blockLength, version, header);
            }
            case 17: {
                return this.onLibraryConnect(buffer, offset, blockLength, version, header);
            }
            case 29: {
                return this.onReleaseSession(buffer, offset, blockLength, version, header);
            }
            case 31: {
                return this.onRequestSession(buffer, offset, blockLength, version, header);
            }
            case 46: {
                return this.onMidConnectionDisconnect(buffer, offset, blockLength, version, header);
            }
            case 47: {
                return this.onFollowerSessionRequest(buffer, offset, blockLength, version, header);
            }
            case 37: {
                return this.onWriteMetaData(buffer, offset, blockLength, version, header);
            }
            case 51: {
                return this.onReadMetaData(buffer, offset, blockLength, version, header);
            }
            case 53: {
                return this.onReplayMessages(buffer, offset, blockLength, version, header);
            }
            case 56: {
                return this.onInitiateILinkConnection(buffer, offset, blockLength, version, header);
            }
            case 69: {
                return this.onCancelOnDisconnectTrigger(buffer, offset, blockLength, version);
            }
            case 71: {
                return this.onThrottleReject(buffer, offset, blockLength, version, header);
            }
            case 72: {
                return this.onThrottleConfiguration(buffer, offset, blockLength, version, header);
            }
            case 74: {
                return this.onSeqIndexSync(buffer, offset, blockLength, version, header);
            }
            case 59: {
                return this.onValidResendRequest(buffer, offset, blockLength, version, header);
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onValidResendRequest(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        ValidResendRequestDecoder validResendRequest = this.validResendRequest;
        validResendRequest.wrap(buffer, offset, blockLength, version);
        return this.handler.onValidResendRequest(validResendRequest.session(), validResendRequest.connection(), validResendRequest.correlationId(), header);
    }

    private ControlledFragmentHandler.Action onSeqIndexSync(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        SeqIndexSyncDecoder seqIndexSync = this.seqIndexSync;
        seqIndexSync.wrap(buffer, offset, blockLength, version);
        return this.handler.onSeqIndexSync(seqIndexSync.libraryId(), seqIndexSync.sessionId(), seqIndexSync.sequenceIndex());
    }

    private ControlledFragmentHandler.Action onThrottleConfiguration(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        ThrottleConfigurationDecoder throttleConfiguration = this.throttleConfiguration;
        throttleConfiguration.wrap(buffer, offset, blockLength, version);
        return this.handler.onThrottleConfiguration(throttleConfiguration.libraryId(), throttleConfiguration.correlationId(), throttleConfiguration.session(), throttleConfiguration.throttleWindowInMs(), throttleConfiguration.throttleLimitOfMessages());
    }

    private ControlledFragmentHandler.Action onThrottleReject(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        ThrottleRejectDecoder throttleReject = this.throttleReject;
        throttleReject.wrap(buffer, offset, blockLength, version);
        int businessRejectRefIDOffset = throttleReject.limit() + ThrottleRejectDecoder.businessRejectRefIDHeaderLength();
        return this.handler.onThrottleReject(throttleReject.libraryId(), throttleReject.connection(), throttleReject.refMsgType(), throttleReject.refSeqNum(), throttleReject.sequenceNumber(), buffer, businessRejectRefIDOffset, throttleReject.businessRejectRefIDLength(), header);
    }

    private ControlledFragmentHandler.Action onCancelOnDisconnectTrigger(DirectBuffer buffer, int offset, int blockLength, int version) {
        CancelOnDisconnectTriggerDecoder cancelOnDisconnectTrigger = this.cancelOnDisconnectTrigger;
        cancelOnDisconnectTrigger.wrap(buffer, offset, blockLength, version);
        this.handler.onCancelOnDisconnectTrigger(cancelOnDisconnectTrigger.sessionId(), cancelOnDisconnectTrigger.timeInNs());
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onApplicationHeartbeat(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        ApplicationHeartbeatDecoder applicationHeartbeat = this.applicationHeartbeat;
        applicationHeartbeat.wrap(buffer, offset, blockLength, version);
        int libraryId = applicationHeartbeat.libraryId();
        long timestampInNs = applicationHeartbeat.timestampInNs();
        int sessionId = header.sessionId();
        this.handler.onApplicationHeartbeat(libraryId, sessionId, 16, timestampInNs);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onLibraryConnect(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.libraryConnect.wrap(buffer, offset, blockLength, version);
        int libraryId = this.libraryConnect.libraryId();
        String libraryName = this.libraryConnect.libraryName();
        return this.handler.onLibraryConnect(libraryId, libraryName, this.libraryConnect.correlationId(), header.sessionId());
    }

    private ControlledFragmentHandler.Action onReleaseSession(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        ReleaseSessionDecoder releaseSession = this.releaseSession;
        releaseSession.wrap(buffer, offset, blockLength, version);
        int libraryId = releaseSession.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId(), 29, 0L);
        if (action != null) {
            return action;
        }
        return this.handler.onReleaseSession(libraryId, releaseSession.connection(), releaseSession.sessionId(), releaseSession.correlationId(), releaseSession.state(), releaseSession.awaitingResend() == AwaitingResend.YES, releaseSession.heartbeatIntervalInMs(), releaseSession.lastSentSequenceNumber(), releaseSession.lastReceivedSequenceNumber(), releaseSession.username(), releaseSession.password(), header);
    }

    private ControlledFragmentHandler.Action onRequestSession(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        RequestSessionDecoder requestSession = this.requestSession;
        requestSession.wrap(buffer, offset, blockLength, version);
        int libraryId = requestSession.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId(), 31, 0L);
        if (action != null) {
            return action;
        }
        return this.handler.onRequestSession(libraryId, requestSession.sessionId(), requestSession.correlationId(), requestSession.lastReceivedSequenceNumber(), requestSession.sequenceIndex());
    }

    private ControlledFragmentHandler.Action onInitiateConnection(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        InitiateConnectionDecoder initiateConnection = this.initiateConnection;
        initiateConnection.wrap(buffer, offset, blockLength, version);
        int libraryId = initiateConnection.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId(), 11, 0L);
        if (action != null) {
            return action;
        }
        return this.handler.onInitiateConnection(libraryId, initiateConnection.port(), initiateConnection.host(), initiateConnection.senderCompId(), initiateConnection.senderSubId(), initiateConnection.senderLocationId(), initiateConnection.targetCompId(), initiateConnection.targetSubId(), initiateConnection.targetLocationId(), initiateConnection.sequenceNumberType(), initiateConnection.requestedInitialReceivedSequenceNumber(), initiateConnection.requestedInitialSentSequenceNumber(), initiateConnection.resetSequenceNumber() == ResetSequenceNumber.YES, initiateConnection.closedResendInterval() == Bool.TRUE, initiateConnection.resendRequestChunkSize(), initiateConnection.sendRedundantResendRequests() == Bool.TRUE, initiateConnection.enableLastMsgSeqNumProcessed() == Bool.TRUE, initiateConnection.username(), initiateConnection.password(), FixDictionary.find(initiateConnection.fixDictionary()), initiateConnection.heartbeatIntervalInS(), initiateConnection.correlationId(), header);
    }

    private ControlledFragmentHandler.Action onRequestDisconnect(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        RequestDisconnectDecoder requestDisconnect = this.requestDisconnect;
        requestDisconnect.wrap(buffer, offset, blockLength, version);
        int libraryId = requestDisconnect.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId(), 12, 0L);
        if (action != null) {
            return action;
        }
        return this.handler.onRequestDisconnect(libraryId, requestDisconnect.connection(), requestDisconnect.reason());
    }

    private ControlledFragmentHandler.Action onMidConnectionDisconnect(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        MidConnectionDisconnectDecoder midConnectionDisconnect = this.midConnectionDisconnect;
        midConnectionDisconnect.wrap(buffer, offset, blockLength, version);
        int libraryId = midConnectionDisconnect.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId(), 46, 0L);
        if (action != null) {
            return action;
        }
        return this.handler.onMidConnectionDisconnect(libraryId, midConnectionDisconnect.correlationId());
    }

    private ControlledFragmentHandler.Action onFollowerSessionRequest(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        FollowerSessionRequestDecoder followerSessionRequest = this.followerSessionRequest;
        followerSessionRequest.wrap(buffer, offset, blockLength, version);
        int libraryId = followerSessionRequest.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId(), 47, 0L);
        if (action != null) {
            return action;
        }
        int messageLength = followerSessionRequest.headerLength();
        return this.handler.onFollowerSessionRequest(libraryId, followerSessionRequest.correlationId(), followerSessionRequest.protocolType(), buffer, offset + FOLLOWER_SESSION_REQUEST_LENGTH, messageLength, header);
    }

    private ControlledFragmentHandler.Action onWriteMetaData(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        WriteMetaDataDecoder writeMetaData = this.writeMetaData;
        writeMetaData.wrap(buffer, offset, blockLength, version);
        int libraryId = writeMetaData.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId(), 37, 0L);
        if (action != null) {
            return action;
        }
        int metaDataLength = writeMetaData.metaDataLength();
        return this.handler.onWriteMetaData(libraryId, writeMetaData.session(), writeMetaData.correlationId(), writeMetaData.metaDataOffset(), buffer, offset + WRITE_META_DATA_DATA_LENGTH, metaDataLength);
    }

    private ControlledFragmentHandler.Action onReadMetaData(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        ReadMetaDataDecoder readMetaData = this.readMetaData;
        readMetaData.wrap(buffer, offset, blockLength, version);
        int libraryId = readMetaData.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId(), 51, 0L);
        if (action != null) {
            return action;
        }
        return this.handler.onReadMetaData(libraryId, readMetaData.session(), readMetaData.correlationId());
    }

    private ControlledFragmentHandler.Action onReplayMessages(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        ReplayMessagesDecoder replayMessages = this.replayMessages;
        replayMessages.wrap(buffer, offset, blockLength, version);
        int libraryId = replayMessages.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId(), 53, 0L);
        if (action != null) {
            return action;
        }
        return this.handler.onReplayMessages(libraryId, replayMessages.session(), replayMessages.correlationId(), replayMessages.replayFromSequenceNumber(), replayMessages.replayToSequenceIndex(), replayMessages.replayToSequenceNumber(), replayMessages.replayToSequenceIndex(), replayMessages.latestReplyArrivalTimeInMs());
    }

    private ControlledFragmentHandler.Action onInitiateILinkConnection(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        InitiateILinkConnectionDecoder initiateILinkConnection = this.initiateILinkConnection;
        initiateILinkConnection.wrap(buffer, offset, blockLength, version);
        int libraryId = initiateILinkConnection.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId(), 56, 0L);
        if (action != null) {
            return action;
        }
        return this.handler.onInitiateILinkConnection(libraryId, initiateILinkConnection.port(), initiateILinkConnection.correlationId(), initiateILinkConnection.reestablishConnection() == Bool.TRUE, initiateILinkConnection.useBackupHost() == Bool.TRUE, initiateILinkConnection.host(), initiateILinkConnection.accessKeyId(), initiateILinkConnection.backupHost());
    }
}

