/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MetaAttribute;
import uk.co.real_logic.artio.messages.StartReplayDecoder;

public final class StartReplayEncoder {
    public static final int BLOCK_LENGTH = 24;
    public static final int TEMPLATE_ID = 75;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 23;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final StartReplayEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 24;
    }

    public int sbeTemplateId() {
        return 75;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 23;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public StartReplayEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 24);
        return this;
    }

    public StartReplayEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(24).templateId(75).schemaId(666).version(23);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int sessionId() {
        return 1;
    }

    public static int sessionSinceVersion() {
        return 0;
    }

    public static int sessionEncodingOffset() {
        return 0;
    }

    public static int sessionEncodingLength() {
        return 8;
    }

    public static String sessionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long sessionMinValue() {
        return -9223372036854775807L;
    }

    public static long sessionMaxValue() {
        return Long.MAX_VALUE;
    }

    public StartReplayEncoder session(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int connectionId() {
        return 2;
    }

    public static int connectionSinceVersion() {
        return 0;
    }

    public static int connectionEncodingOffset() {
        return 8;
    }

    public static int connectionEncodingLength() {
        return 8;
    }

    public static String connectionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long connectionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long connectionMinValue() {
        return -9223372036854775807L;
    }

    public static long connectionMaxValue() {
        return Long.MAX_VALUE;
    }

    public StartReplayEncoder connection(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int correlationIdId() {
        return 3;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 16;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public StartReplayEncoder correlationId(long value) {
        this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        StartReplayDecoder decoder = new StartReplayDecoder();
        decoder.wrap(this.buffer, this.initialOffset, 24, 23);
        return decoder.appendTo(builder);
    }
}

