/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.messages.Bool;
import uk.co.real_logic.artio.messages.FixPProtocolType;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MetaAttribute;

public final class ManageFixPConnectionDecoder {
    public static final int BLOCK_LENGTH = 57;
    public static final int TEMPLATE_ID = 68;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 23;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ManageFixPConnectionDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 57;
    }

    public int sbeTemplateId() {
        return 68;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 23;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ManageFixPConnectionDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public ManageFixPConnectionDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (68 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public ManageFixPConnectionDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int libraryId() {
        return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 4;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int connectionId() {
        return 3;
    }

    public static int connectionSinceVersion() {
        return 0;
    }

    public static int connectionEncodingOffset() {
        return 12;
    }

    public static int connectionEncodingLength() {
        return 8;
    }

    public static String connectionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long connectionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long connectionMinValue() {
        return -9223372036854775807L;
    }

    public static long connectionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long connection() {
        return this.buffer.getLong(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sessionIdId() {
        return 4;
    }

    public static int sessionIdSinceVersion() {
        return 0;
    }

    public static int sessionIdEncodingOffset() {
        return 20;
    }

    public static int sessionIdEncodingLength() {
        return 8;
    }

    public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionIdNullValue() {
        return -1L;
    }

    public static long sessionIdMinValue() {
        return 0L;
    }

    public static long sessionIdMaxValue() {
        return -2L;
    }

    public long sessionId() {
        return this.buffer.getLong(this.offset + 20, ByteOrder.LITTLE_ENDIAN);
    }

    public static int protocolTypeId() {
        return 5;
    }

    public static int protocolTypeSinceVersion() {
        return 16;
    }

    public static int protocolTypeEncodingOffset() {
        return 28;
    }

    public static int protocolTypeEncodingLength() {
        return 2;
    }

    public static String protocolTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public int protocolTypeRaw() {
        if (this.parentMessage.actingVersion < 16) {
            return 65535;
        }
        return this.buffer.getShort(this.offset + 28, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public FixPProtocolType protocolType() {
        if (this.parentMessage.actingVersion < 16) {
            return FixPProtocolType.NULL_VAL;
        }
        return FixPProtocolType.get(this.buffer.getShort(this.offset + 28, ByteOrder.LITTLE_ENDIAN) & 0xFFFF);
    }

    public static int lastReceivedSequenceNumberId() {
        return 6;
    }

    public static int lastReceivedSequenceNumberSinceVersion() {
        return 0;
    }

    public static int lastReceivedSequenceNumberEncodingOffset() {
        return 30;
    }

    public static int lastReceivedSequenceNumberEncodingLength() {
        return 8;
    }

    public static String lastReceivedSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long lastReceivedSequenceNumberNullValue() {
        return -1L;
    }

    public static long lastReceivedSequenceNumberMinValue() {
        return 0L;
    }

    public static long lastReceivedSequenceNumberMaxValue() {
        return -2L;
    }

    public long lastReceivedSequenceNumber() {
        return this.buffer.getLong(this.offset + 30, ByteOrder.LITTLE_ENDIAN);
    }

    public static int lastSentSequenceNumberId() {
        return 7;
    }

    public static int lastSentSequenceNumberSinceVersion() {
        return 0;
    }

    public static int lastSentSequenceNumberEncodingOffset() {
        return 38;
    }

    public static int lastSentSequenceNumberEncodingLength() {
        return 8;
    }

    public static String lastSentSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long lastSentSequenceNumberNullValue() {
        return -1L;
    }

    public static long lastSentSequenceNumberMinValue() {
        return 0L;
    }

    public static long lastSentSequenceNumberMaxValue() {
        return -2L;
    }

    public long lastSentSequenceNumber() {
        return this.buffer.getLong(this.offset + 38, ByteOrder.LITTLE_ENDIAN);
    }

    public static int lastConnectPayloadId() {
        return 8;
    }

    public static int lastConnectPayloadSinceVersion() {
        return 0;
    }

    public static int lastConnectPayloadEncodingOffset() {
        return 46;
    }

    public static int lastConnectPayloadEncodingLength() {
        return 8;
    }

    public static String lastConnectPayloadMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long lastConnectPayloadNullValue() {
        return -1L;
    }

    public static long lastConnectPayloadMinValue() {
        return 0L;
    }

    public static long lastConnectPayloadMaxValue() {
        return -2L;
    }

    public long lastConnectPayload() {
        return this.buffer.getLong(this.offset + 46, ByteOrder.LITTLE_ENDIAN);
    }

    public static int messageLengthId() {
        return 9;
    }

    public static int messageLengthSinceVersion() {
        return 0;
    }

    public static int messageLengthEncodingOffset() {
        return 54;
    }

    public static int messageLengthEncodingLength() {
        return 2;
    }

    public static String messageLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int messageLengthNullValue() {
        return 65535;
    }

    public static int messageLengthMinValue() {
        return 0;
    }

    public static int messageLengthMaxValue() {
        return 65534;
    }

    public int messageLength() {
        return this.buffer.getShort(this.offset + 54, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int offlineId() {
        return 10;
    }

    public static int offlineSinceVersion() {
        return 0;
    }

    public static int offlineEncodingOffset() {
        return 56;
    }

    public static int offlineEncodingLength() {
        return 1;
    }

    public static String offlineMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short offlineRaw() {
        return (short)(this.buffer.getByte(this.offset + 56) & 0xFF);
    }

    public Bool offline() {
        return Bool.get((short)(this.buffer.getByte(this.offset + 56) & 0xFF));
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ManageFixPConnectionDecoder decoder = new ManageFixPConnectionDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[ManageFixPConnection](sbeTemplateId=");
        builder.append(68);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 23) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(23);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 57) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(57);
        builder.append("):");
        builder.append("libraryId=");
        builder.append(this.libraryId());
        builder.append('|');
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("connection=");
        builder.append(this.connection());
        builder.append('|');
        builder.append("sessionId=");
        builder.append(this.sessionId());
        builder.append('|');
        builder.append("protocolType=");
        builder.append((Object)this.protocolType());
        builder.append('|');
        builder.append("lastReceivedSequenceNumber=");
        builder.append(this.lastReceivedSequenceNumber());
        builder.append('|');
        builder.append("lastSentSequenceNumber=");
        builder.append(this.lastSentSequenceNumber());
        builder.append('|');
        builder.append("lastConnectPayload=");
        builder.append(this.lastConnectPayload());
        builder.append('|');
        builder.append("messageLength=");
        builder.append(this.messageLength());
        builder.append('|');
        builder.append("offline=");
        builder.append((Object)this.offline());
        this.limit(originalLimit);
        return builder;
    }

    public ManageFixPConnectionDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

