/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.messages.DisconnectDecoder;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MetaAttribute;

public final class DisconnectEncoder {
    public static final int BLOCK_LENGTH = 13;
    public static final int TEMPLATE_ID = 7;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 23;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final DisconnectEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 13;
    }

    public int sbeTemplateId() {
        return 7;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 23;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public DisconnectEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 13);
        return this;
    }

    public DisconnectEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(13).templateId(7).schemaId(666).version(23);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public DisconnectEncoder libraryId(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int connectionId() {
        return 2;
    }

    public static int connectionSinceVersion() {
        return 0;
    }

    public static int connectionEncodingOffset() {
        return 4;
    }

    public static int connectionEncodingLength() {
        return 8;
    }

    public static String connectionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long connectionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long connectionMinValue() {
        return -9223372036854775807L;
    }

    public static long connectionMaxValue() {
        return Long.MAX_VALUE;
    }

    public DisconnectEncoder connection(long value) {
        this.buffer.putLong(this.offset + 4, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int reasonId() {
        return 3;
    }

    public static int reasonSinceVersion() {
        return 0;
    }

    public static int reasonEncodingOffset() {
        return 12;
    }

    public static int reasonEncodingLength() {
        return 1;
    }

    public static String reasonMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public DisconnectEncoder reason(DisconnectReason value) {
        this.buffer.putByte(this.offset + 12, (byte)value.value());
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        DisconnectDecoder decoder = new DisconnectDecoder();
        decoder.wrap(this.buffer, this.initialOffset, 13, 23);
        return decoder.appendTo(builder);
    }
}

