/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import io.aeron.logbuffer.ControlledFragmentHandler;
import java.util.function.BooleanSupplier;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.library.InitiateSessionReply;
import uk.co.real_logic.artio.library.LibraryPoller;
import uk.co.real_logic.artio.library.OnMessageInfo;
import uk.co.real_logic.artio.library.ReplayMessagesReply;
import uk.co.real_logic.artio.library.SessionHandler;
import uk.co.real_logic.artio.library.ThrottleConfigurationReply;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.GatewayError;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.messages.ReplayMessagesStatus;
import uk.co.real_logic.artio.messages.ThrottleConfigurationStatus;
import uk.co.real_logic.artio.session.FixSessionOwner;
import uk.co.real_logic.artio.session.InternalSession;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.session.SessionParser;
import uk.co.real_logic.artio.timing.Timer;

class SessionSubscriber
implements AutoCloseable,
FixSessionOwner {
    private final OnMessageInfo info;
    private final SessionParser parser;
    private final InternalSession session;
    private final Timer receiveTimer;
    private final Timer sessionTimer;
    private final LibraryPoller libraryPoller;
    private final long replyTimeoutInMs;
    private final ErrorHandler errorHandler;
    private SessionHandler handler;
    private InitiateSessionReply initiateSessionReply;
    private boolean userAbortedLastMessage = false;
    private long lastReceivedPosition = -1000L;

    SessionSubscriber(OnMessageInfo info, SessionParser parser, InternalSession session, Timer receiveTimer, Timer sessionTimer, LibraryPoller libraryPoller, long replyTimeoutInMs, ErrorHandler errorHandler) {
        this.info = info;
        this.parser = parser;
        this.session = session;
        this.receiveTimer = receiveTimer;
        this.sessionTimer = sessionTimer;
        this.libraryPoller = libraryPoller;
        this.replyTimeoutInMs = replyTimeoutInMs;
        this.errorHandler = errorHandler;
        this.session.sessionProcessHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int length, int libraryId, int sequenceIndex, long messageType, long timestamp, MessageStatus status, long position) {
        long now = this.receiveTimer.recordSince(timestamp);
        OnMessageInfo info = this.info;
        info.status(status);
        info.isValid(true);
        try {
            switch (status) {
                case OK: {
                    boolean userAbortedLastMessage = this.userAbortedLastMessage;
                    if (userAbortedLastMessage) {
                        ControlledFragmentHandler.Action handlerAction = this.handler.onMessage(buffer, offset, length, libraryId, this.session, sequenceIndex, messageType, timestamp, position, info);
                        if (handlerAction != ControlledFragmentHandler.Action.ABORT) {
                            this.session.updateLastMessageProcessed();
                            this.userAbortedLastMessage = false;
                        }
                        ControlledFragmentHandler.Action action = handlerAction;
                        return action;
                    }
                    ControlledFragmentHandler.Action action = this.parser.onMessage(buffer, offset, length, messageType, position);
                    if (action == ControlledFragmentHandler.Action.ABORT) {
                        ControlledFragmentHandler.Action action2 = ControlledFragmentHandler.Action.ABORT;
                        return action2;
                    }
                    this.lastReceivedPosition = position;
                    ControlledFragmentHandler.Action handlerAction = this.handler.onMessage(buffer, offset, length, libraryId, this.session, sequenceIndex, messageType, timestamp, position, info);
                    if (handlerAction == ControlledFragmentHandler.Action.ABORT) {
                        this.userAbortedLastMessage = true;
                    } else {
                        this.session.updateLastMessageProcessed();
                    }
                    ControlledFragmentHandler.Action action3 = handlerAction;
                    return action3;
                }
                case CATCHUP_REPLAY: {
                    ControlledFragmentHandler.Action action = this.handler.onMessage(buffer, offset, length, libraryId, this.session, sequenceIndex, messageType, timestamp, position, info);
                    return action;
                }
            }
            ControlledFragmentHandler.Action action = ControlledFragmentHandler.Action.CONTINUE;
            return action;
        }
        finally {
            this.sessionTimer.recordSince(now);
        }
    }

    ControlledFragmentHandler.Action onDisconnect(int libraryId, DisconnectReason reason) {
        ControlledFragmentHandler.Action action = this.handler.onDisconnect(libraryId, this.session, reason);
        if (action != ControlledFragmentHandler.Action.ABORT) {
            this.session.onDisconnect();
            if (this.initiateSessionReply != null) {
                this.initiateSessionReply.onError(GatewayError.UNABLE_TO_LOGON, "Disconnected before session active");
                this.initiateSessionReply = null;
            }
        }
        return action;
    }

    @Override
    public void onLogon(Session session) {
        try {
            this.handler.onSessionStart(session);
            if (this.initiateSessionReply != null) {
                this.initiateSessionReply.onComplete(session);
                this.initiateSessionReply = null;
            }
        }
        catch (Throwable t) {
            if (this.initiateSessionReply != null) {
                this.initiateSessionReply.onError(t);
                this.initiateSessionReply = null;
            } else {
                this.errorHandler.onError(t);
            }
            ((InternalSession)session).logoutAndDisconnect(DisconnectReason.CALLBACK_EXCEPTION);
        }
    }

    @Override
    public Reply<ReplayMessagesStatus> replayReceivedMessages(long sessionId, int replayFromSequenceNumber, int replayFromSequenceIndex, int replayToSequenceNumber, int replayToSequenceIndex, long timeoutInMs) {
        return new ReplayMessagesReply(this.libraryPoller, this.libraryPoller.timeInMs() + timeoutInMs, sessionId, replayFromSequenceNumber, replayFromSequenceIndex, replayToSequenceNumber, replayToSequenceIndex);
    }

    @Override
    public Reply<ThrottleConfigurationStatus> messageThrottle(long sessionId, int throttleWindowInMs, int throttleLimitOfMessages) {
        return new ThrottleConfigurationReply(this.libraryPoller, this.libraryPoller.timeInMs() + this.replyTimeoutInMs, sessionId, throttleWindowInMs, throttleLimitOfMessages);
    }

    @Override
    public long inboundMessagePosition() {
        return this.lastReceivedPosition;
    }

    @Override
    public void enqueueTask(BooleanSupplier task) {
        this.libraryPoller.enqueueTask(task);
    }

    void onTimeout(int libraryId) {
        this.handler.onTimeout(libraryId, this.session);
    }

    void onSlowStatusNotification(int libraryId, boolean hasBecomeSlow) {
        this.session.isSlowConsumer(hasBecomeSlow);
        this.handler.onSlowStatus(libraryId, this.session, hasBecomeSlow);
    }

    @Override
    public void close() {
        this.session.requestDisconnect();
    }

    InternalSession session() {
        return this.session;
    }

    void handler(SessionHandler handler) {
        this.handler = handler;
    }

    void reply(InitiateSessionReply reply) {
        this.initiateSessionReply = reply;
    }

    public boolean onThrottleNotification(long refMsgType, int refSeqNum, DirectBuffer businessRejectRefIDBuffer, int businessRejectRefIDOffset, int businessRejectRefIDLength) {
        return this.session.onThrottleNotification(refMsgType, refSeqNum, businessRejectRefIDBuffer, businessRejectRefIDOffset, businessRejectRefIDLength);
    }

    void onReplayComplete(long correlationId) {
        this.session.onReplayComplete(correlationId);
    }
}

