/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.library.LibraryPoller;
import uk.co.real_logic.artio.library.LibraryReply;
import uk.co.real_logic.artio.messages.FixPProtocolType;
import uk.co.real_logic.artio.session.SessionWriter;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

class FollowerSessionReply
extends LibraryReply<SessionWriter> {
    private static final int INITIAL_BUFFER_SIZE = 4096;
    private final MutableAsciiBuffer buffer = new MutableAsciiBuffer(new byte[4096]);
    private final int offset;
    private final int length;

    FollowerSessionReply(LibraryPoller libraryPoller, long latestReplyArrivalTimeInMs, SessionHeaderEncoder headerEncoder) {
        super(libraryPoller, latestReplyArrivalTimeInMs);
        headerEncoder.msgType("A").sendingTime(new byte[1]);
        long result = headerEncoder.startMessage(this.buffer, 0);
        this.length = Encoder.length(result);
        this.offset = Encoder.offset(result);
        if (libraryPoller.isConnected()) {
            this.sendMessage();
        }
    }

    @Override
    protected void sendMessage() {
        long position = this.libraryPoller.saveFollowerSessionRequest(this.correlationId, FixPProtocolType.NULL_VAL, this.buffer, this.offset, this.length);
        this.requiresResend = position < 0L;
    }
}

