/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fixp;

import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2IntHashMap;
import org.agrona.collections.Long2LongHashMap;
import uk.co.real_logic.artio.fixp.AbstractFixPOffsets;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.HeaderStructure;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;

public class FixPRejectRefIdExtractor {
    public static final int MISSING_OFFSET = -1;
    public static final String MESSAGE_TYPE = "MessageType";
    public static final String CLORDID = "clordid";
    private final int templateIdOffset;
    private final int headerLength;
    private final Int2IntHashMap templateIdToLength = new Int2IntHashMap(-1);
    private final Int2IntHashMap templateIdToOffset = new Int2IntHashMap(-1);
    private final Long2LongHashMap templateIdToMessageType = new Long2LongHashMap(-1L);
    private int length;
    private int templateId;
    private int offset;
    private long messageType;

    public FixPRejectRefIdExtractor(Ir ir) {
        HashMap messageTypeToValue = new HashMap();
        List<Token> messageType = ir.getType(MESSAGE_TYPE);
        if (messageType != null) {
            messageType.stream().filter(token -> token.signal() == Signal.VALID_VALUE).forEach(token -> {
                Encoding encoding = token.encoding();
                long value = encoding.constValue().longValue();
                messageTypeToValue.put("MessageType." + token.name(), value);
            });
        }
        ir.messages().forEach(messageTokens -> {
            int templateId = AbstractFixPOffsets.templateId(messageTokens);
            messageTokens.stream().filter(token -> this.nameIgnoreCase((Token)token, CLORDID)).findFirst().ifPresent(token -> {
                this.templateIdToLength.put(templateId, token.encodedLength());
                this.templateIdToOffset.put(templateId, token.offset());
            });
            messageTokens.stream().filter(token -> this.nameIgnoreCase((Token)token, MESSAGE_TYPE) && token.signal() == Signal.BEGIN_FIELD).mapToLong(token -> (Long)messageTypeToValue.get(token.encoding().constValue().toString())).filter(id -> id != -1L).findFirst().ifPresent(messageTypeValue -> this.templateIdToMessageType.put(templateId, messageTypeValue));
        });
        HeaderStructure headerStructure = ir.headerStructure();
        this.templateIdOffset = headerStructure.tokens().stream().filter(token -> token.name().equals("templateId") && this.isEncoding((Token)token)).mapToInt(Token::offset).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find template id for FIXP protocol header"));
        this.headerLength = headerStructure.tokens().stream().filter(this::isEncoding).mapToInt(token -> {
            int encodedLength = token.encodedLength();
            if (encodedLength == -1) {
                throw new IllegalStateException("FIXP protocol message header with variable length tokens");
            }
            return encodedLength;
        }).sum();
    }

    private boolean nameIgnoreCase(Token token, String clordid) {
        return token.name().equalsIgnoreCase(clordid);
    }

    private boolean isEncoding(Token token) {
        return token.signal() == Signal.ENCODING;
    }

    public boolean search(DirectBuffer buffer, int offset) {
        int headerOffset = offset + 4;
        this.templateId = this.templateId(buffer, headerOffset);
        this.messageType = this.templateIdToMessageType.get(this.templateId);
        this.length = this.templateIdToLength.get(this.templateId);
        int fieldOffset = this.templateIdToOffset.get(this.templateId);
        if (fieldOffset == -1) {
            this.offset = -1;
            return false;
        }
        this.offset = headerOffset + this.headerLength + fieldOffset;
        return true;
    }

    public int templateId(DirectBuffer buffer, int headerOffset) {
        return buffer.getShort(headerOffset + this.templateIdOffset, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int templateId() {
        return this.templateId;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public long messageType() {
        return this.messageType;
    }
}

