/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import org.agrona.DirectBuffer;
import org.agrona.collections.Long2LongHashMap;
import uk.co.real_logic.artio.engine.logger.RedactHandler;
import uk.co.real_logic.artio.messages.ManageSessionDecoder;

class SessionOwnershipTracker {
    private static final long MISSING_SESSION = -1L;
    private final ManageSessionDecoder manageSession = new ManageSessionDecoder();
    private final Long2LongHashMap sessionIdToLibraryId = new Long2LongHashMap(-1L);
    private final RedactHandler redactHandler;
    private final boolean sent;

    SessionOwnershipTracker(boolean sent, RedactHandler redactHandler) {
        this.sent = sent;
        this.redactHandler = redactHandler;
    }

    void onManageSession(DirectBuffer buffer, int offset, int actingBlockLength, int version) {
        this.manageSession.wrap(buffer, offset, actingBlockLength, version);
        this.onManageSessionMessage();
    }

    private void onManageSessionMessage() {
        int libraryId = this.manageSession.libraryId();
        long sessionId = this.manageSession.session();
        this.sessionIdToLibraryId.put(sessionId, libraryId);
    }

    boolean messageFromWrongLibrary(long sessionId, int libraryId) {
        long expectedLibraryId = this.sessionIdToLibraryId.get(sessionId);
        return expectedLibraryId != -1L && (long)libraryId != expectedLibraryId && libraryId != 0;
    }
}

