/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.util.Objects;
import java.util.function.Predicate;
import uk.co.real_logic.artio.engine.SessionInfo;
import uk.co.real_logic.artio.engine.logger.HeaderField;
import uk.co.real_logic.artio.session.CompositeKey;

class SessionHeaderMatcher
implements Predicate<SessionInfo> {
    private final HeaderField headerField;
    private final String value;

    SessionHeaderMatcher(HeaderField headerField, String value) {
        Objects.requireNonNull(headerField);
        Objects.requireNonNull(value);
        this.headerField = headerField;
        this.value = value;
    }

    @Override
    public boolean test(SessionInfo sessionInfo) {
        CompositeKey compositeKey = sessionInfo.sessionKey();
        switch (this.headerField) {
            case SENDER_COMP_ID: {
                return compositeKey.localCompId().equals(this.value);
            }
            case TARGET_COMP_ID: {
                return compositeKey.remoteCompId().equals(this.value);
            }
        }
        throw new IllegalStateException("Unoptimisable header field");
    }

    public String toString() {
        return "SessionHeaderMatcher{headerField=" + (Object)((Object)this.headerField) + ", value='" + this.value + '\'' + '}';
    }
}

