/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ControlledFragmentHandler;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.engine.logger.MessageTracker;
import uk.co.real_logic.artio.engine.logger.ReplayOperation;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;
import uk.co.real_logic.artio.engine.logger.Replayer;
import uk.co.real_logic.artio.messages.ReplayCompleteEncoder;

abstract class ReplayerSession
implements ControlledFragmentHandler {
    private static final int REPLAY_COMPLETE_LEN = 28;
    private final int maxClaimAttempts;
    private final IdleStrategy idleStrategy;
    final long connectionId;
    final long correlationId;
    final BufferClaim bufferClaim;
    final ExclusivePublication publication;
    final ReplayQuery replayQuery;
    final int beginSeqNo;
    final int endSeqNo;
    final long sessionId;
    final int sequenceIndex;
    final Replayer replayer;
    final AtomicCounter bytesInBuffer;
    final int maxBytesInBuffer;
    ReplayOperation replayOperation;

    protected ReplayerSession(long connectionId, long correlationId, BufferClaim bufferClaim, IdleStrategy idleStrategy, int maxClaimAttempts, ExclusivePublication publication, ReplayQuery replayQuery, int beginSeqNo, int endSeqNo, long sessionId, int sequenceIndex, Replayer replayer, AtomicCounter bytesInBuffer, int maxBytesInBuffer) {
        this.connectionId = connectionId;
        this.correlationId = correlationId;
        this.bufferClaim = bufferClaim;
        this.idleStrategy = idleStrategy;
        this.maxClaimAttempts = maxClaimAttempts;
        this.publication = publication;
        this.replayQuery = replayQuery;
        this.beginSeqNo = beginSeqNo;
        this.endSeqNo = endSeqNo;
        this.sessionId = sessionId;
        this.sequenceIndex = sequenceIndex;
        this.replayer = replayer;
        this.maxBytesInBuffer = maxBytesInBuffer;
        this.bytesInBuffer = bytesInBuffer;
    }

    void query() {
        this.replayOperation = this.replayQuery.query(this.sessionId, this.beginSeqNo, this.sequenceIndex, this.endSeqNo, this.sequenceIndex, LogTag.REPLAY, this.messageTracker());
    }

    abstract MessageTracker messageTracker();

    boolean claimBuffer(int newLength, int messageLength) {
        if (this.isBackpressured(messageLength)) {
            return false;
        }
        for (int i = 0; i < this.maxClaimAttempts; ++i) {
            long position = this.publication.tryClaim(newLength, this.bufferClaim);
            if (position > 0L) {
                this.idleStrategy.reset();
                return true;
            }
            if (!Pressure.isBackPressured(position)) {
                return false;
            }
            this.idleStrategy.idle();
        }
        return false;
    }

    boolean isBackpressured(int messageLength) {
        return (long)this.maxBytesInBuffer < this.bytesInBuffer.get() + (long)messageLength;
    }

    boolean sendCompleteMessage() {
        if (this.claimBuffer(28, 0)) {
            ReplayCompleteEncoder replayComplete = this.replayer.replayCompleteEncoder;
            replayComplete.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.replayer.messageHeaderEncoder).libraryId(0).connection(this.connectionId).correlationId(this.correlationId);
            DebugLogger.logSbeMessage(LogTag.REPLAY, replayComplete);
            this.bufferClaim.commit();
            return true;
        }
        return false;
    }

    abstract boolean attemptReplay();

    void closeNow() {
        if (this.replayOperation != null) {
            this.replayOperation.closeNow();
        }
    }

    void startClose() {
        if (this.replayOperation != null) {
            this.replayOperation.startClose();
        }
    }
}

