/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.agrona.LangUtil;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.logger.LoggerUtil;
import uk.co.real_logic.artio.engine.logger.ReplayIndexDescriptor;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.storage.messages.ReplayIndexRecordDecoder;

public final class ReplayIndexExtractor {
    public static void extract(EngineConfiguration configuration, long fixSessionId, boolean inbound, ReplayIndexHandler handler) {
        int streamId = inbound ? configuration.inboundLibraryStream() : configuration.outboundLibraryStream();
        String logFileDir = configuration.logFileDir();
        File file = ReplayIndexDescriptor.replayIndexHeaderFile(logFileDir, fixSessionId, streamId);
        if (file.exists()) {
            ReplayIndexExtractor.extract(file, configuration.replayIndexFileRecordCapacity(), configuration.replayIndexSegmentRecordCapacity(), fixSessionId, streamId, logFileDir, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(File headerFile, int indexFileCapacity, int indexSegmentCapacity, long fixSessionId, int streamId, String logFileDir, ReplayIndexHandler handler) {
        long indexFileSize = ReplayIndexDescriptor.capacityToBytes(indexFileCapacity);
        int segmentSize = ReplayIndexDescriptor.capacityToBytesInt(indexSegmentCapacity);
        int segmentCount = ReplayIndexDescriptor.segmentCount(indexFileCapacity, indexSegmentCapacity);
        UnsafeBuffer[] segmentBuffers = new UnsafeBuffer[segmentCount];
        int segmentSizeBitShift = Long.numberOfTrailingZeros(segmentSize);
        UnsafeBuffer headerBuffer = new UnsafeBuffer(LoggerUtil.mapExistingFile(headerFile));
        try {
            long iteratorPosition;
            MessageHeaderDecoder messageFrameHeader = new MessageHeaderDecoder();
            ReplayIndexRecordDecoder indexRecord = new ReplayIndexRecordDecoder();
            messageFrameHeader.wrap(headerBuffer, 0);
            int actingBlockLength = messageFrameHeader.blockLength();
            int actingVersion = messageFrameHeader.version();
            long stopIteratingPosition = iteratorPosition + indexFileSize;
            for (iteratorPosition = ReplayIndexDescriptor.beginChangeVolatile(headerBuffer); iteratorPosition < stopIteratingPosition; iteratorPosition += 32L) {
                long changePosition = ReplayIndexDescriptor.endChangeVolatile(headerBuffer);
                if (changePosition > iteratorPosition && iteratorPosition + indexFileSize <= ReplayIndexDescriptor.beginChangeVolatile(headerBuffer)) {
                    handler.onLapped();
                    iteratorPosition = changePosition;
                    stopIteratingPosition = iteratorPosition + indexFileSize;
                }
                UnsafeBuffer segmentBuffer = ReplayIndexExtractor.segmentBuffer(iteratorPosition, segmentSizeBitShift, segmentBuffers, indexFileSize, fixSessionId, streamId, logFileDir);
                int offset = ReplayIndexDescriptor.offsetInSegment(iteratorPosition, segmentSize);
                indexRecord.wrap(segmentBuffer, offset, actingBlockLength, actingVersion);
                long beginPosition = indexRecord.position();
                if (beginPosition == 0L) {
                    break;
                }
                handler.onEntry(indexRecord);
            }
        }
        finally {
            ReplayIndexDescriptor.unmapBuffers(headerBuffer, segmentBuffers);
        }
    }

    private static UnsafeBuffer segmentBuffer(long position, int segmentSizeBitShift, UnsafeBuffer[] segmentBuffers, long indexFileSize, long fixSessionId, int streamId, String logFileDir) {
        int segmentIndex = ReplayIndexDescriptor.segmentIndex(position, segmentSizeBitShift, indexFileSize);
        UnsafeBuffer segmentBuffer = segmentBuffers[segmentIndex];
        if (segmentBuffer == null) {
            File file = ReplayIndexDescriptor.replayIndexSegmentFile(logFileDir, fixSessionId, streamId, segmentIndex);
            segmentBuffers[segmentIndex] = segmentBuffer = new UnsafeBuffer(LoggerUtil.mapExistingFile(file));
        }
        return segmentBuffer;
    }

    public static class ReplayIndexValidator
    implements ReplayIndexHandler {
        private static final long MISSING = Long.MIN_VALUE;
        private final Long2LongHashMap sequenceIdToEndPosition = new Long2LongHashMap(Long.MIN_VALUE);
        private final List<ValidationError> errors = new ArrayList<ValidationError>();

        @Override
        public void onEntry(ReplayIndexRecordDecoder indexRecord) {
            int length;
            long position;
            long endPosition;
            int sequenceNumber;
            int sequenceIndex = indexRecord.sequenceIndex();
            long sequenceId = (long)sequenceIndex | (long)(sequenceNumber = indexRecord.sequenceNumber()) << 32;
            long oldEndPosition = this.sequenceIdToEndPosition.put(sequenceId, endPosition = (position = indexRecord.position()) + (long)(length = indexRecord.length()));
            if (oldEndPosition != Long.MIN_VALUE && oldEndPosition != position) {
                this.errors.add(new ValidationError(sequenceIndex, sequenceNumber, position, length, endPosition));
            }
        }

        public List<ValidationError> errors() {
            return this.errors;
        }

        @Override
        public void onLapped() {
            this.sequenceIdToEndPosition.clear();
        }
    }

    public static class ValidationError {
        private final int sequenceIndex;
        private final int sequenceNumber;
        private final long position;
        private final int length;
        private final long endPosition;

        public ValidationError(int sequenceIndex, int sequenceNumber, long position, int length, long endPosition) {
            this.sequenceIndex = sequenceIndex;
            this.sequenceNumber = sequenceNumber;
            this.position = position;
            this.length = length;
            this.endPosition = endPosition;
        }

        public int sequenceIndex() {
            return this.sequenceIndex;
        }

        public int sequenceNumber() {
            return this.sequenceNumber;
        }

        public long position() {
            return this.position;
        }

        public long endPosition() {
            return this.endPosition;
        }

        public String toString() {
            return "ValidationError{sequenceIndex=" + this.sequenceIndex + ", sequenceNumber=" + this.sequenceNumber + ", position=" + this.position + ", length=" + this.length + ", endPosition=" + this.endPosition + '}';
        }
    }

    public static class PrintError
    implements ReplayIndexHandler {
        private final BufferedWriter out;

        public PrintError(BufferedWriter out) throws IOException {
            this.out = out;
            out.write("beginPosition,sequenceIndex,sequenceNumber,recordingId,readLength\n");
        }

        @Override
        public void onEntry(ReplayIndexRecordDecoder indexRecord) {
            long beginPosition = indexRecord.position();
            int sequenceIndex = indexRecord.sequenceIndex();
            int sequenceNumber = indexRecord.sequenceNumber();
            long recordingId = indexRecord.recordingId();
            int readLength = indexRecord.length();
            try {
                this.out.write(beginPosition + "," + sequenceIndex + "," + sequenceNumber + "," + recordingId + "," + readLength + "\n");
            }
            catch (IOException e) {
                LangUtil.rethrowUnchecked(e);
            }
        }

        @Override
        public void onLapped() {
            System.err.println("Error: lapped by writer currently updating the file");
        }
    }

    public static class BoundaryPositionExtractor
    implements ReplayIndexHandler {
        private final Long2LongHashMap recordingIdToPosition = new Long2LongHashMap(-1L);
        private final Long2ObjectHashMap<Long2LongHashMap> recordingIdToSequenceIndexToPosition = new Long2ObjectHashMap();
        private final boolean min;

        public BoundaryPositionExtractor(boolean min) {
            this.min = min;
        }

        @Override
        public void onEntry(ReplayIndexRecordDecoder indexRecord) {
            long beginPosition = ReplayQuery.trueBeginPosition(indexRecord.position());
            int sequenceIndex = indexRecord.sequenceIndex();
            long recordingId = indexRecord.recordingId();
            this.boundaryUpdate(this.recordingIdToPosition, beginPosition, recordingId, this.min);
            Long2LongHashMap sequenceIndexToPosition = this.recordingIdToSequenceIndexToPosition.computeIfAbsent(recordingId, k -> new Long2LongHashMap(-1L));
            this.boundaryUpdate(sequenceIndexToPosition, beginPosition, sequenceIndex, true);
        }

        private void boundaryUpdate(Long2LongHashMap keyToPosition, long beginPosition, long key, boolean min) {
            long oldPosition = keyToPosition.get(key);
            if (this.beyondBounary(oldPosition, beginPosition, min)) {
                keyToPosition.put(key, beginPosition);
            }
        }

        private boolean beyondBounary(long oldPosition, long beginPosition, boolean min) {
            if (oldPosition == -1L) {
                return true;
            }
            if (min) {
                return beginPosition < oldPosition;
            }
            return beginPosition > oldPosition;
        }

        @Override
        public void onLapped() {
            System.err.println("Error: lapped by writer currently updating the file");
        }

        public Long2LongHashMap recordingIdToPosition() {
            return this.recordingIdToPosition;
        }

        public Long2ObjectHashMap<Long2LongHashMap> recordingIdToSequenceIndexToPosition() {
            return this.recordingIdToSequenceIndexToPosition;
        }

        public void findInconsistentSequenceIndexPositions() {
            this.recordingIdToSequenceIndexToPosition.forEach((recordingId, sequenceIndexToPosition) -> {
                List sequencePositions = sequenceIndexToPosition.entrySet().stream().map(e -> new SequencePosition((Long)e.getKey(), (Long)e.getValue())).sorted(Comparator.comparingLong(SequencePosition::position)).collect(Collectors.toList());
                sequenceIndexToPosition.forEach((BiConsumer<? super Long, ? super Long>)((BiConsumer<Long, Long>)(sequenceIndex, position) -> sequencePositions.stream().filter(rp -> ((SequencePosition)rp).position < position && ((SequencePosition)rp).sequenceIndex > sequenceIndex).findFirst().ifPresent(sp -> System.out.println("Found suppressor for " + sequenceIndex + " @ " + position + ": " + ((SequencePosition)sp).sequenceIndex + " @ " + ((SequencePosition)sp).position))));
            });
        }
    }

    public static class SequencePosition {
        private final long sequenceIndex;
        private final long position;

        public SequencePosition(long sequenceIndex, long position) {
            this.sequenceIndex = sequenceIndex;
            this.position = position;
        }

        public long position() {
            return this.position;
        }

        public long sequenceIndex() {
            return this.sequenceIndex;
        }

        public String toString() {
            return "SequencePosition{sequenceIndex=" + this.sequenceIndex + ", position=" + this.position + '}';
        }
    }

    public static class StartPositionExtractor
    implements ReplayIndexHandler {
        private final Long2LongHashMap recordingIdToStartPosition = new Long2LongHashMap(-1L);
        private int highestSequenceIndex = 0;

        @Override
        public void onEntry(ReplayIndexRecordDecoder indexRecord) {
            long beginPosition = indexRecord.position();
            int sequenceIndex = indexRecord.sequenceIndex();
            long recordingId = indexRecord.recordingId();
            this.highestSequenceIndex = ReplayQuery.updateStartPosition(sequenceIndex, this.highestSequenceIndex, this.recordingIdToStartPosition, recordingId, beginPosition);
        }

        @Override
        public void onLapped() {
            System.err.println("Error: lapped by writer currently updating the file");
        }

        public Long2LongHashMap recordingIdToStartPosition() {
            return this.recordingIdToStartPosition;
        }

        public int highestSequenceIndex() {
            return this.highestSequenceIndex;
        }
    }

    public static interface ReplayIndexHandler {
        public void onEntry(ReplayIndexRecordDecoder var1);

        public void onLapped();
    }
}

