/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.io.File;
import java.util.Objects;
import org.agrona.BitUtil;
import org.agrona.IoUtil;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.engine.logger.LoggerUtil;

public final class ReplayIndexDescriptor {
    private static final int BEGIN_CHANGE_OFFSET = 8;
    private static final int END_CHANGE_OFFSET = 16;
    private static final int FOR_NEXT_SESSION_VERSION_OFFSET = 24;
    public static final int HEADER_FILE_SIZE = 25;
    public static final byte FOR_NEXT_SESSION_VERSION = 1;
    public static final byte NOT_FOR_NEXT_SESSION_VERSION = 0;
    public static final int RECORD_LENGTH = 32;
    public static final int MAX_FILE_SEGMENT_CAPACITY = 0x3FFFFFF;

    static File replayIndexHeaderFile(String logFileDir, long fixSessionId, int streamId) {
        return new File(logFileDir + File.separator + "replay-index-" + fixSessionId + "-" + streamId + "-header");
    }

    static File replayIndexSegmentFile(String logFileDir, long fixSessionId, int streamId, int segmentIndex) {
        return new File(logFileDir + File.separator + "replay-index-" + fixSessionId + "-" + streamId + "-" + segmentIndex);
    }

    static LongHashSet listReplayIndexSessionIds(File logFileDir, int streamId) {
        String prefix = "replay-index-";
        String suffix = "-" + streamId + "-header";
        LongHashSet sessionIds = new LongHashSet();
        for (File file : Objects.requireNonNull(logFileDir.listFiles())) {
            String fileName = file.getName();
            if (!fileName.startsWith("replay-index-") || !fileName.endsWith(suffix)) continue;
            int suffixIndex = fileName.length() - suffix.length();
            String sessionIdString = fileName.substring("replay-index-".length(), suffixIndex);
            long sessionId = Long.parseLong(sessionIdString);
            sessionIds.add(sessionId);
        }
        return sessionIds;
    }

    static void unmapBuffers(UnsafeBuffer headerBuffer, UnsafeBuffer[] segmentBuffers) {
        IoUtil.unmap(headerBuffer.byteBuffer());
        for (UnsafeBuffer segmentBuffer : segmentBuffers) {
            if (segmentBuffer == null) continue;
            IoUtil.unmap(segmentBuffer.byteBuffer());
        }
    }

    public static UnsafeBuffer replayPositionBuffer(String logFileDir, int streamId, int bufferSize) {
        String pathname = ReplayIndexDescriptor.replayPositionPath(logFileDir, streamId);
        return new UnsafeBuffer(LoggerUtil.map(new File(pathname), bufferSize));
    }

    static String replayPositionPath(String logFileDir, int streamId) {
        return logFileDir + File.separator + "replay-positions-" + streamId;
    }

    static void endChangeOrdered(AtomicBuffer buffer, long changePosition) {
        buffer.putLongOrdered(16, changePosition);
    }

    static long endChangeVolatile(AtomicBuffer buffer) {
        return buffer.getLongVolatile(16);
    }

    static void beginChangeOrdered(AtomicBuffer buffer, long changePosition) {
        buffer.putLongOrdered(8, changePosition);
    }

    static long beginChangeVolatile(AtomicBuffer buffer) {
        return buffer.getLongVolatile(8);
    }

    static long beginChange(AtomicBuffer buffer) {
        return buffer.getLong(8);
    }

    static boolean forNextSessionVersion(AtomicBuffer buffer) {
        return buffer.getByte(24) == 1;
    }

    static void forNextSessionVersion(AtomicBuffer buffer, boolean value) {
        byte byteValue = value ? (byte)1 : 0;
        buffer.putByte(24, byteValue);
    }

    static int offsetInSegment(long changePosition, long capacity) {
        return (int)(changePosition & capacity - 1L);
    }

    public static int segmentIndex(long position, int segmentSizeBitShift, long indexFileSize) {
        long offsetWithinRing = position & indexFileSize - 1L;
        return (int)(offsetWithinRing >> segmentSizeBitShift);
    }

    static void checkIndexRecordCapacity(int recordCapacity) {
        if (!BitUtil.isPowerOfTwo(recordCapacity)) {
            throw new IllegalStateException("IndexFileSize must be a positive power of 2: recordCapacity=" + recordCapacity);
        }
    }

    public static long capacityToBytes(int indexSegmentCapacity) {
        return (long)indexSegmentCapacity * 32L;
    }

    public static int capacityToBytesInt(int indexSegmentCapacity) {
        return indexSegmentCapacity * 32;
    }

    public static int segmentCount(int indexFileCapacity, int indexSegmentCapacity) {
        return indexFileCapacity / indexSegmentCapacity;
    }
}

