/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.logbuffer.Header;
import java.io.File;
import java.io.IOException;
import java.util.function.LongFunction;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.UnsafeAccess;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.SequenceNumberExtractor;
import uk.co.real_logic.artio.engine.logger.BufferFactory;
import uk.co.real_logic.artio.engine.logger.FixPSequenceIndexer;
import uk.co.real_logic.artio.engine.logger.Index;
import uk.co.real_logic.artio.engine.logger.IndexedPositionConsumer;
import uk.co.real_logic.artio.engine.logger.IndexedPositionReader;
import uk.co.real_logic.artio.engine.logger.IndexedPositionWriter;
import uk.co.real_logic.artio.engine.logger.RecordingIdLookup;
import uk.co.real_logic.artio.engine.logger.RedactHandler;
import uk.co.real_logic.artio.engine.logger.ReplayEvictionHandler;
import uk.co.real_logic.artio.engine.logger.ReplayIndexDescriptor;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.engine.logger.SessionOwnershipTracker;
import uk.co.real_logic.artio.engine.logger.TimeIndexWriter;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.FixPProtocolType;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.messages.RedactSequenceUpdateDecoder;
import uk.co.real_logic.artio.messages.ResetSequenceNumberDecoder;
import uk.co.real_logic.artio.messages.ThrottleNotificationDecoder;
import uk.co.real_logic.artio.messages.ThrottleRejectDecoder;
import uk.co.real_logic.artio.storage.messages.ReplayIndexRecordEncoder;

public class ReplayIndex
implements Index,
RedactHandler {
    private static final long NO_TIMESTAMP = -1L;
    private final LongFunction<SessionIndex> newSessionIndex = x$0 -> new SessionIndex(x$0);
    private final MessageHeaderDecoder frameHeaderDecoder = new MessageHeaderDecoder();
    private final FixMessageDecoder messageFrame = new FixMessageDecoder();
    private final ThrottleNotificationDecoder throttleNotification = new ThrottleNotificationDecoder();
    private final ThrottleRejectDecoder throttleReject = new ThrottleRejectDecoder();
    private final ResetSequenceNumberDecoder resetSequenceNumber = new ResetSequenceNumberDecoder();
    private final RedactSequenceUpdateDecoder redactSequenceUpdateDecoder = new RedactSequenceUpdateDecoder();
    private final ReplayIndexRecordEncoder replayIndexRecord = new ReplayIndexRecordEncoder();
    private final MessageHeaderEncoder indexHeaderEncoder = new MessageHeaderEncoder();
    private final IndexedPositionWriter positionWriter;
    private final IndexedPositionReader positionReader;
    private final SequenceNumberExtractor sequenceNumberExtractor;
    private final FixPSequenceIndexer fixPSequenceIndexer;
    private final Long2ObjectHashMap<SessionIndex> fixSessionIdToIndex;
    private final String logFileDir;
    private final int requiredStreamId;
    private final long indexFileSize;
    private final int segmentSize;
    private final ReplayEvictionHandler evictionHandler;
    private final int segmentSizeBitShift;
    private final int segmentCount;
    private final BufferFactory bufferFactory;
    private final AtomicBuffer positionBuffer;
    private final ErrorHandler errorHandler;
    private final RecordingIdLookup recordingIdLookup;
    private final TimeIndexWriter timeIndex;
    private final SessionOwnershipTracker sessTracker;
    private long continuedFixSessionId;
    private int continuedSequenceNumber;
    private int continuedSequenceIndex;
    private long continuedTimestamp;

    public ReplayIndex(SequenceNumberExtractor sequenceNumberExtractor, String logFileDir, int requiredStreamId, int indexFileCapacity, int indexSegmentCapacity, BufferFactory bufferFactory, AtomicBuffer positionBuffer, ErrorHandler errorHandler, RecordingIdLookup recordingIdLookup, Long2LongHashMap connectionIdToFixPSessionId, FixPProtocolType fixPProtocolType, SequenceNumberIndexReader reader, long timeIndexReplayFlushIntervalInNs, boolean sent, boolean indexChecksumEnabled, ReplayEvictionHandler evictionHandler) {
        this.sequenceNumberExtractor = sequenceNumberExtractor;
        this.logFileDir = logFileDir;
        this.requiredStreamId = requiredStreamId;
        this.indexFileSize = ReplayIndexDescriptor.capacityToBytes(indexFileCapacity);
        this.segmentSize = ReplayIndexDescriptor.capacityToBytesInt(indexSegmentCapacity);
        this.evictionHandler = evictionHandler;
        this.segmentSizeBitShift = Long.numberOfTrailingZeros(this.segmentSize);
        this.segmentCount = ReplayIndexDescriptor.segmentCount(indexFileCapacity, indexSegmentCapacity);
        this.bufferFactory = bufferFactory;
        this.positionBuffer = positionBuffer;
        this.errorHandler = errorHandler;
        this.recordingIdLookup = recordingIdLookup;
        this.checkPowerOfTwo("segmentCount", this.segmentCount);
        this.checkPowerOfTwo("segmentSize", this.segmentSize);
        this.checkPowerOfTwo("indexFileSize", this.indexFileSize);
        this.sessTracker = new SessionOwnershipTracker(sent, this);
        this.fixPSequenceIndexer = new FixPSequenceIndexer(connectionIdToFixPSessionId, errorHandler, fixPProtocolType, reader, (sequenceNumber, uuid, messageSize, endPosition, aeronSessionId, possRetrans, timestamp, forNextSession) -> this.onFixPSequenceUpdate(sequenceNumber, uuid, messageSize, endPosition, aeronSessionId, forNextSession));
        ReplayIndexDescriptor.checkIndexRecordCapacity(indexFileCapacity);
        this.fixSessionIdToIndex = new Long2ObjectHashMap();
        String replayPositionPath = ReplayIndexDescriptor.replayPositionPath(logFileDir, requiredStreamId);
        this.positionWriter = new IndexedPositionWriter(positionBuffer, errorHandler, 0, replayPositionPath, recordingIdLookup, indexChecksumEnabled);
        this.positionReader = new IndexedPositionReader(positionBuffer);
        this.timeIndex = new TimeIndexWriter(logFileDir, requiredStreamId, timeIndexReplayFlushIntervalInNs, errorHandler);
    }

    private void checkPowerOfTwo(String name, int value) {
        if (!BitUtil.isPowerOfTwo(value)) {
            throw new IllegalStateException("segmentCount must be a positive power of 2: " + name + "=" + value);
        }
    }

    private void checkPowerOfTwo(String name, long value) {
        if (!BitUtil.isPowerOfTwo(value)) {
            throw new IllegalStateException("segmentCount must be a positive power of 2: " + name + "=" + value);
        }
    }

    private void onFixPSequenceUpdate(int sequenceNumber, long sessionId, int messageSize, long endPosition, int aeronSessionId, boolean forNextSession) {
        if (sequenceNumber == 0) {
            this.onFixPResetSequenceNumber(sessionId, forNextSession);
        } else {
            SessionIndex sessionIndex = this.sessionIndex(sessionId);
            sessionIndex.checkForNextSession(forNextSession);
            sessionIndex.onRecord(endPosition, messageSize, sequenceNumber, 0, aeronSessionId, -1L, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFixPResetSequenceNumber(long sessionId, boolean forNextSession) {
        SessionIndex sessionIndex = this.fixSessionIdToIndex.get(sessionId);
        if (sessionIndex != null) {
            if (ReplayIndexDescriptor.forNextSessionVersion(sessionIndex.headerBuffer)) {
                this.flipNextSession(forNextSession, sessionIndex.headerBuffer);
                return;
            }
        } else {
            File headerFile = this.replayIndexHeaderFile(sessionId);
            if (headerFile.exists()) {
                UnsafeBuffer headerBuffer = this.mapUnsafeBuffer(25, headerFile);
                try {
                    if (ReplayIndexDescriptor.forNextSessionVersion(headerBuffer)) {
                        this.flipNextSession(forNextSession, headerBuffer);
                        return;
                    }
                }
                finally {
                    IoUtil.unmap(headerBuffer.byteBuffer());
                }
            }
        }
        this.onResetSequenceNumber(sessionId);
    }

    private void flipNextSession(boolean forNextSession, UnsafeBuffer headerBuffer) {
        if (!forNextSession) {
            ReplayIndex.notForNextSession(headerBuffer);
        }
    }

    @Override
    public void onCatchup(DirectBuffer buffer, int offset, int length, Header header, long recordingId) {
        this.onFragment(buffer, offset, length, header, recordingId);
    }

    @Override
    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        int streamId = header.streamId();
        if (streamId == this.requiredStreamId) {
            this.onFragment(buffer, offset, length, header, -1L);
        }
    }

    public void onFragment(DirectBuffer srcBuffer, int srcOffset, int srcLength, Header header, long recordingId) {
        long endPosition = header.position();
        byte flags = header.flags();
        int length = BitUtil.align(srcLength, 32);
        int offset = srcOffset;
        this.frameHeaderDecoder.wrap(srcBuffer, offset);
        int templateId = this.frameHeaderDecoder.templateId();
        int blockLength = this.frameHeaderDecoder.blockLength();
        int version = this.frameHeaderDecoder.version();
        offset += this.frameHeaderDecoder.encodedLength();
        boolean beginMessage = (flags & 0xFFFFFF80) == -128;
        int aeronSessionId = header.sessionId();
        if ((flags & 0xFFFFFFC0) == -64 || beginMessage) {
            switch (templateId) {
                case 1: {
                    this.messageFrame.wrap(srcBuffer, offset, blockLength, version);
                    if (this.sessTracker.messageFromWrongLibrary(this.messageFrame.session(), this.messageFrame.libraryId())) break;
                    this.onFixMessage(srcBuffer, header, recordingId, endPosition, length, offset, blockLength, version, beginMessage);
                    break;
                }
                case 70: {
                    this.throttleNotification.wrap(srcBuffer, offset, blockLength, version);
                    int sequenceNumber = this.throttleNotification.refSeqNum();
                    long fixSessionId = this.throttleNotification.session();
                    int sequenceIndex = this.throttleNotification.sequenceIndex();
                    if (this.sessTracker.messageFromWrongLibrary(fixSessionId, this.throttleNotification.libraryId())) break;
                    this.sessionIndex(fixSessionId).onRecord(endPosition, length, sequenceNumber, sequenceIndex, aeronSessionId, recordingId, -1L);
                    break;
                }
                case 71: {
                    this.throttleReject.wrap(srcBuffer, offset, blockLength, version);
                    int sequenceNumber = this.throttleReject.sequenceNumber();
                    long fixSessionId = this.throttleReject.session();
                    int sequenceIndex = this.throttleReject.sequenceIndex();
                    if (this.sessTracker.messageFromWrongLibrary(fixSessionId, this.throttleReject.libraryId())) break;
                    this.sessionIndex(fixSessionId).onRecord(endPosition, length, sequenceNumber, sequenceIndex, aeronSessionId, recordingId, -1L);
                    break;
                }
                case 47: 
                case 57: 
                case 58: {
                    this.fixPSequenceIndexer.onFragment(srcBuffer, srcOffset, srcLength, header);
                    break;
                }
                case 42: {
                    this.resetSequenceNumber.wrap(srcBuffer, offset, blockLength, version);
                    long fixSessionId = this.resetSequenceNumber.session();
                    this.onResetSequenceNumber(fixSessionId);
                    break;
                }
                case 55: {
                    this.redactSequenceUpdateDecoder.wrap(srcBuffer, offset, blockLength, version);
                    this.onRedactSequenceUpdateDecoder();
                    break;
                }
                case 8: {
                    this.sessTracker.onManageSession(srcBuffer, offset, blockLength, version);
                }
            }
        } else {
            this.sessionIndex(this.continuedFixSessionId).onRecord(endPosition, length, this.continuedSequenceNumber, this.continuedSequenceIndex, aeronSessionId, recordingId, this.continuedTimestamp);
        }
        this.positionWriter.update(aeronSessionId, templateId, endPosition, recordingId);
        this.positionWriter.updateChecksums();
    }

    private void onRedactSequenceUpdateDecoder() {
        long fixSessionId = this.redactSequenceUpdateDecoder.session();
        int sequenceNumber = this.redactSequenceUpdateDecoder.correctSequenceNumber();
        if (sequenceNumber <= 1) {
            this.onResetSequenceNumber(fixSessionId);
        }
        this.fixPSequenceIndexer.onRedactSequenceUpdate(fixSessionId, sequenceNumber);
    }

    private void onFixMessage(DirectBuffer srcBuffer, Header header, long recordingId, long endPosition, int length, int start, int blockLength, int version, boolean beginMessage) {
        if (this.messageFrame.status() == MessageStatus.OK) {
            int offset = start + blockLength;
            if (version >= FixMessageDecoder.metaDataSinceVersion()) {
                offset += FixMessageDecoder.metaDataHeaderLength() + this.messageFrame.metaDataLength();
                this.messageFrame.skipMetaData();
            }
            long fixSessionId = this.messageFrame.session();
            this.sequenceNumberExtractor.extractCached(srcBuffer, offset += FixMessageDecoder.bodyHeaderLength(), this.messageFrame.bodyLength(), header.sessionId(), endPosition);
            int sequenceNumber = this.sequenceNumberExtractor.sequenceNumber();
            int newSequenceNumber = this.sequenceNumberExtractor.newSequenceNumber();
            int sequenceIndex = this.messageFrame.sequenceIndex();
            long timestamp = this.messageFrame.timestamp();
            if (sequenceNumber != -1) {
                if (beginMessage) {
                    this.continuedFixSessionId = fixSessionId;
                    this.continuedSequenceNumber = sequenceNumber;
                    this.continuedSequenceIndex = sequenceIndex;
                    this.continuedTimestamp = timestamp;
                }
                SessionIndex sessionIndex = this.sessionIndex(fixSessionId);
                int aeronSessionId = header.sessionId();
                if (newSequenceNumber > sequenceNumber) {
                    while (sequenceNumber < newSequenceNumber) {
                        sessionIndex.onRecord(endPosition, length, sequenceNumber, sequenceIndex, aeronSessionId, recordingId, timestamp);
                        ++sequenceNumber;
                    }
                } else {
                    sessionIndex.onRecord(endPosition, length, sequenceNumber, sequenceIndex, aeronSessionId, recordingId, timestamp);
                }
            }
        }
    }

    private void onResetSequenceNumber(long fixSessionId) {
        SessionIndex index = this.fixSessionIdToIndex.remove(fixSessionId);
        if (index != null) {
            index.reset();
        } else {
            this.evictionHandler.onReset(fixSessionId);
            File replayIndexFile = this.replayIndexHeaderFile(fixSessionId);
            if (replayIndexFile.exists()) {
                this.deleteFile(replayIndexFile);
            }
        }
    }

    private SessionIndex sessionIndex(long fixSessionId) {
        return this.fixSessionIdToIndex.computeIfAbsent(fixSessionId, this.newSessionIndex);
    }

    @Override
    public int doWork() {
        return this.positionWriter.checkRecordings() + this.timeIndex.doWork();
    }

    @Override
    public void close() {
        Exceptions.closeAll(this.timeIndex, this.positionWriter);
        this.fixSessionIdToIndex.values().forEach(SessionIndex::close);
        this.fixSessionIdToIndex.clear();
        IoUtil.unmap(this.positionBuffer.byteBuffer());
    }

    @Override
    public void readLastPosition(IndexedPositionConsumer consumer) {
        this.positionReader.readLastPosition(consumer);
    }

    @Override
    public void onRedact(long sessionId, int lastSequenceNumber) {
    }

    static void notForNextSession(UnsafeBuffer headerBuffer) {
        ReplayIndexDescriptor.forNextSessionVersion(headerBuffer, false);
    }

    private File replayIndexHeaderFile(long fixSessionId) {
        return ReplayIndexDescriptor.replayIndexHeaderFile(this.logFileDir, fixSessionId, this.requiredStreamId);
    }

    private File replayIndexSegmentFile(long fixSessionId, int segmentIndex) {
        return ReplayIndexDescriptor.replayIndexSegmentFile(this.logFileDir, fixSessionId, this.requiredStreamId, segmentIndex);
    }

    void deleteFile(File replayIndexFile) {
        if (!replayIndexFile.delete()) {
            this.errorHandler.onError(new IOException("Unable to delete replay index file: " + replayIndexFile));
        }
    }

    private UnsafeBuffer mapUnsafeBuffer(int size, File replayIndexFile) {
        return new UnsafeBuffer(this.bufferFactory.map(replayIndexFile, size));
    }

    private final class SessionIndex
    implements AutoCloseable {
        private final long fixSessionId;
        private final int segmentSize;
        private final int segmentSizeBitShift;
        private final UnsafeBuffer headerBuffer;
        private final File headerFile;
        private final UnsafeBuffer[] segmentBuffers;
        private final File[] segmentBufferFiles;

        SessionIndex(long fixSessionId) {
            ReplayIndex replayIndex2 = ReplayIndex.this;
            this.fixSessionId = fixSessionId;
            this.segmentSize = replayIndex2.segmentSize;
            this.segmentSizeBitShift = replayIndex2.segmentSizeBitShift;
            this.segmentBuffers = new UnsafeBuffer[ReplayIndex.this.segmentCount];
            this.segmentBufferFiles = new File[ReplayIndex.this.segmentCount];
            this.headerFile = ReplayIndex.this.replayIndexHeaderFile(fixSessionId);
            boolean exists = this.headerFile.exists();
            this.headerBuffer = ReplayIndex.this.mapUnsafeBuffer(25, this.headerFile);
            if (!exists) {
                ReplayIndexRecordEncoder replayIndexRecord = replayIndex2.replayIndexRecord;
                MessageHeaderEncoder indexHeaderEncoder = replayIndex2.indexHeaderEncoder;
                indexHeaderEncoder.wrap(this.headerBuffer, 0).blockLength(replayIndexRecord.sbeBlockLength()).templateId(replayIndexRecord.sbeTemplateId()).schemaId(replayIndexRecord.sbeSchemaId()).version(replayIndexRecord.sbeSchemaVersion());
                ReplayIndex.notForNextSession(this.headerBuffer);
            } else {
                long resetPosition = ReplayIndexDescriptor.beginChange(this.headerBuffer);
                ReplayIndexDescriptor.endChangeOrdered(this.headerBuffer, resetPosition);
            }
        }

        void onRecord(long endPosition, int length, int sequenceNumber, int sequenceIndex, int aeronSessionId, long knownRecordingId, long timestamp) {
            long beginChangePosition = ReplayIndexDescriptor.beginChange(this.headerBuffer);
            long changePosition = beginChangePosition + 32L;
            long recordingId = knownRecordingId == -1L ? ReplayIndex.this.recordingIdLookup.getRecordingId(aeronSessionId) : knownRecordingId;
            long beginPosition = endPosition - (long)length;
            ReplayIndexDescriptor.beginChangeOrdered(this.headerBuffer, changePosition);
            UnsafeAccess.UNSAFE.storeFence();
            int segmentIndex = ReplayIndexDescriptor.segmentIndex(beginChangePosition, this.segmentSizeBitShift, ReplayIndex.this.indexFileSize);
            UnsafeBuffer segmentBuffer = this.segmentBuffer(segmentIndex);
            int offset = ReplayIndexDescriptor.offsetInSegment(beginChangePosition, this.segmentSize);
            ReplayIndex.this.replayIndexRecord.wrap(segmentBuffer, offset).position(beginPosition).sequenceNumber(sequenceNumber).sequenceIndex(sequenceIndex).recordingId(recordingId).length(length);
            ReplayIndexDescriptor.endChangeOrdered(this.headerBuffer, changePosition);
            if (timestamp != -1L) {
                ReplayIndex.this.timeIndex.onRecord(recordingId, endPosition, timestamp);
            }
        }

        private UnsafeBuffer segmentBuffer(int segmentIndex) {
            UnsafeBuffer segmentBuffer = this.segmentBuffers[segmentIndex];
            if (segmentBuffer == null) {
                File file;
                this.segmentBufferFiles[segmentIndex] = file = ReplayIndex.this.replayIndexSegmentFile(this.fixSessionId, segmentIndex);
                this.segmentBuffers[segmentIndex] = segmentBuffer = ReplayIndex.this.mapUnsafeBuffer(this.segmentSize, file);
            }
            return segmentBuffer;
        }

        void reset() {
            this.close();
            ReplayIndex.this.evictionHandler.onReset(this.fixSessionId);
            ReplayIndex.this.deleteFile(this.headerFile);
            for (File segmentFile : this.segmentBufferFiles) {
                if (segmentFile == null) continue;
                ReplayIndex.this.deleteFile(segmentFile);
            }
        }

        @Override
        public void close() {
            ReplayIndexDescriptor.unmapBuffers(this.headerBuffer, this.segmentBuffers);
        }

        public void checkForNextSession(boolean forNextSession) {
            if (forNextSession && !ReplayIndexDescriptor.forNextSessionVersion(this.headerBuffer)) {
                ReplayIndexDescriptor.forNextSessionVersion(this.headerBuffer, true);
            }
        }
    }
}

