/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.archive.status.RecordingPos;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.CountersReader;

public class RecordingIdLookup {
    private final Long2LongHashMap aeronSessionIdToRecordingId = new Long2LongHashMap(-1L);
    private final IdleStrategy archiverIdleStrategy;
    private final CountersReader counters;

    public RecordingIdLookup(IdleStrategy archiverIdleStrategy, CountersReader counters) {
        this.archiverIdleStrategy = archiverIdleStrategy;
        this.counters = counters;
    }

    public long getRecordingId(int aeronSessionId) {
        long recordingId = this.aeronSessionIdToRecordingId.get(aeronSessionId);
        while (recordingId == -1L) {
            recordingId = this.checkRecordingId(aeronSessionId);
            this.archiverIdleStrategy.idle();
        }
        this.archiverIdleStrategy.reset();
        return recordingId;
    }

    long findRecordingId(int aeronSessionId) {
        long recordingId = this.aeronSessionIdToRecordingId.get(aeronSessionId);
        if (recordingId == -1L) {
            recordingId = this.checkRecordingId(aeronSessionId);
        }
        return recordingId;
    }

    private long checkRecordingId(int aeronSessionId) {
        int counterId = RecordingPos.findCounterIdBySession(this.counters, aeronSessionId);
        if (counterId == -1) {
            return -1L;
        }
        long recordingId = RecordingPos.getRecordingId(this.counters, counterId);
        if (recordingId != -1L) {
            this.aeronSessionIdToRecordingId.put(aeronSessionId, recordingId);
        }
        return recordingId;
    }
}

