/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.engine.PossDupEnabler;
import uk.co.real_logic.artio.engine.ReplayHandler;
import uk.co.real_logic.artio.engine.SequenceNumberExtractor;
import uk.co.real_logic.artio.engine.framer.FixThrottleRejectBuilder;
import uk.co.real_logic.artio.engine.framer.MessageTypeExtractor;
import uk.co.real_logic.artio.engine.logger.FixMessageTracker;
import uk.co.real_logic.artio.engine.logger.GapFillEncoder;
import uk.co.real_logic.artio.engine.logger.MessageTracker;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;
import uk.co.real_logic.artio.engine.logger.Replayer;
import uk.co.real_logic.artio.engine.logger.ReplayerSession;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.FixMessageEncoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.messages.ThrottleNotificationDecoder;
import uk.co.real_logic.artio.messages.ThrottleRejectDecoder;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

class FixReplayerSession
extends ReplayerSession {
    private static final int NONE = -1;
    private static final byte[] NO_BYTES = new byte[0];
    private static final FixMessageEncoder FIX_MESSAGE_ENCODER = new FixMessageEncoder();
    private static final FixMessageDecoder FIX_MESSAGE = new FixMessageDecoder();
    private static final ThrottleRejectDecoder THROTTLE_REJECT = new ThrottleRejectDecoder();
    private static final AsciiBuffer ASCII_BUFFER = new MutableAsciiBuffer();
    private final GapFillEncoder gapFillEncoder;
    private final PossDupEnabler possDupEnabler;
    private final EpochNanoClock clock;
    private final String message;
    private final ReplayHandler replayHandler;
    private final LongHashSet gapFillMessageTypes;
    private final ErrorHandler errorHandler;
    private final SequenceNumberExtractor sequenceNumberExtractor;
    private final FixThrottleRejectBuilder throttleRejectBuilder;
    private int lastSeqNo;
    private int beginGapFillSeqNum = -1;
    private State state;

    FixReplayerSession(BufferClaim bufferClaim, IdleStrategy idleStrategy, ReplayHandler replayHandler, int maxClaimAttempts, LongHashSet gapFillMessageTypes, ExclusivePublication publication, EpochNanoClock clock, int beginSeqNo, int endSeqNo, long connectionId, long correlationId, long sessionId, int sequenceIndex, ReplayQuery replayQuery, String message, ErrorHandler errorHandler, GapFillEncoder gapFillEncoder, AtomicCounter bytesInBuffer, int maxBytesInBuffer, UtcTimestampEncoder utcTimestampEncoder, Replayer replayer, FixThrottleRejectBuilder throttleRejectBuilder) {
        super(connectionId, correlationId, bufferClaim, idleStrategy, maxClaimAttempts, publication, replayQuery, beginSeqNo, endSeqNo, sessionId, sequenceIndex, replayer, bytesInBuffer, maxBytesInBuffer);
        this.replayHandler = replayHandler;
        this.gapFillMessageTypes = gapFillMessageTypes;
        this.clock = clock;
        this.message = message;
        this.errorHandler = errorHandler;
        this.gapFillEncoder = gapFillEncoder;
        this.sequenceNumberExtractor = new SequenceNumberExtractor();
        this.lastSeqNo = beginSeqNo - 1;
        this.throttleRejectBuilder = throttleRejectBuilder;
        this.possDupEnabler = new PossDupEnabler(utcTimestampEncoder, bufferClaim, this::claimBuffer, this::onPreCommit, x$0 -> this.onIllegalState((String)x$0, new Object[0]), this::onException, clock, publication.maxPayloadLength());
        this.state = State.REPLAYING;
    }

    @Override
    MessageTracker messageTracker() {
        return new FixMessageTracker(LogTag.REPLAY_MESSAGE, this, this.sessionId);
    }

    private void onPreCommit(MutableDirectBuffer buffer, int offset) {
        int frameOffset = offset + 8;
        FIX_MESSAGE_ENCODER.wrap(buffer, frameOffset).connection(this.connectionId);
    }

    private void onException(Throwable e) {
        String exMessage = String.format("[%s] Error replying to message", this.message);
        this.errorHandler.onError(new IllegalArgumentException(exMessage, e));
    }

    private void onIllegalState(String message, Object ... arguments) {
        this.errorHandler.onError(new IllegalStateException(String.format(message, arguments)));
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer srcBuffer, int srcOffset, int srcLength, Header header) {
        MessageHeaderDecoder messageHeader = this.replayer.messageHeaderDecoder.wrap(srcBuffer, srcOffset);
        int actingBlockLength = messageHeader.blockLength();
        int templateId = messageHeader.templateId();
        int offset = srcOffset + 8;
        int version = messageHeader.version();
        switch (templateId) {
            case 1: {
                return this.onFixMessage(srcBuffer, srcOffset, srcLength, actingBlockLength, offset, version);
            }
            case 71: {
                return this.onThrottleReject(srcBuffer, actingBlockLength, offset, version);
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onFixMessage(DirectBuffer srcBuffer, int srcOffset, int srcLength, int actingBlockLength, int offset, int version) {
        FIX_MESSAGE.wrap(srcBuffer, offset, actingBlockLength, version);
        if (FIX_MESSAGE.status() == MessageStatus.OK) {
            int metaDataAdjustment = version >= FixMessageDecoder.metaDataSinceVersion() ? FixMessageDecoder.metaDataHeaderLength() + FIX_MESSAGE.metaDataLength() : 0;
            int messageFrameBlockLength = Replayer.MESSAGE_FRAME_BLOCK_LENGTH + metaDataAdjustment;
            int messageOffset = srcOffset + messageFrameBlockLength;
            int messageLength = srcLength - messageFrameBlockLength;
            int msgSeqNum = this.sequenceNumberExtractor.extract(srcBuffer, messageOffset, messageLength);
            long messageType = MessageTypeExtractor.getMessageType(FIX_MESSAGE);
            ASCII_BUFFER.wrap(srcBuffer);
            this.replayHandler.onReplayedMessage(ASCII_BUFFER, messageOffset, messageLength, FIX_MESSAGE.libraryId(), FIX_MESSAGE.session(), FIX_MESSAGE.sequenceIndex(), messageType);
            if (this.gapFillMessageTypes.contains(messageType)) {
                if (this.beginGapFillSeqNum == -1) {
                    this.beginGapFillSeqNum = this.lastSeqNo + 1;
                }
                this.lastSeqNo = msgSeqNum;
                return ControlledFragmentHandler.Action.CONTINUE;
            }
            if (this.beginGapFillSeqNum != -1) {
                this.sendGapFill(this.beginGapFillSeqNum, msgSeqNum);
            } else if (msgSeqNum > this.lastSeqNo + 1) {
                if (this.lastSeqNo == 0) {
                    this.lastSeqNo = 1;
                }
                this.sendGapFill(this.lastSeqNo, msgSeqNum);
            }
            ControlledFragmentHandler.Action action = this.possDupEnabler.enablePossDupFlag(srcBuffer, messageOffset, messageLength, srcOffset, srcLength, metaDataAdjustment, messageType);
            if (action != ControlledFragmentHandler.Action.ABORT) {
                this.lastSeqNo = msgSeqNum;
            }
            return action;
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onThrottleReject(DirectBuffer srcBuffer, int actingBlockLength, int offset, int version) {
        THROTTLE_REJECT.wrap(srcBuffer, offset, actingBlockLength, version);
        int msgSeqNum = THROTTLE_REJECT.sequenceNumber();
        if (this.gapFillMessageTypes.contains(106L)) {
            if (this.beginGapFillSeqNum == -1) {
                this.beginGapFillSeqNum = this.lastSeqNo + 1;
            }
            this.lastSeqNo = msgSeqNum;
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        if (this.beginGapFillSeqNum != -1) {
            this.sendGapFill(this.beginGapFillSeqNum, msgSeqNum);
        } else if (msgSeqNum > this.lastSeqNo + 1) {
            this.sendGapFill(this.lastSeqNo, msgSeqNum);
        }
        int businessRejectRefIDOffset = THROTTLE_REJECT.limit() + ThrottleNotificationDecoder.businessRejectRefIDHeaderLength();
        this.throttleRejectBuilder.build(THROTTLE_REJECT.refMsgType(), THROTTLE_REJECT.refSeqNum(), THROTTLE_REJECT.sequenceNumber(), srcBuffer, businessRejectRefIDOffset, THROTTLE_REJECT.businessRejectRefIDLength(), true);
        ControlledFragmentHandler.Action action = this.sendFixMessage(this.throttleRejectBuilder.buffer(), this.throttleRejectBuilder.offset(), this.throttleRejectBuilder.length(), 106L);
        if (action == ControlledFragmentHandler.Action.CONTINUE) {
            this.lastSeqNo = msgSeqNum;
        }
        return action;
    }

    private ControlledFragmentHandler.Action sendGapFill(int msgSeqNo, int newSeqNo) {
        long result = this.gapFillEncoder.encode(msgSeqNo, newSeqNo);
        int gapFillLength = Encoder.length(result);
        int gapFillOffset = Encoder.offset(result);
        MutableAsciiBuffer buffer = this.gapFillEncoder.buffer();
        ControlledFragmentHandler.Action action = this.sendFixMessage(buffer, gapFillOffset, gapFillLength, 52L);
        if (action == ControlledFragmentHandler.Action.CONTINUE) {
            this.beginGapFillSeqNum = -1;
        }
        return action;
    }

    private ControlledFragmentHandler.Action sendFixMessage(MutableAsciiBuffer fixBuffer, int fixOffset, int fixLength, long messageType) {
        if (this.claimBuffer(Replayer.MESSAGE_FRAME_BLOCK_LENGTH + fixLength + FixMessageDecoder.metaDataHeaderLength(), fixLength)) {
            int destOffset = this.bufferClaim.offset();
            MutableDirectBuffer destBuffer = this.bufferClaim.buffer();
            FIX_MESSAGE_ENCODER.wrapAndApplyHeader(destBuffer, destOffset, this.replayer.messageHeaderEncoder).libraryId(0).messageType(messageType).session(this.sessionId).sequenceIndex(this.sequenceIndex).connection(this.connectionId).timestamp(this.clock.nanoTime()).status(MessageStatus.OK).putMetaData(NO_BYTES, 0, 0).putBody(fixBuffer, fixOffset, fixLength);
            this.bufferClaim.commit();
            DebugLogger.logFixMessage(LogTag.FIX_MESSAGE, messageType, "Replayed: ", fixBuffer, fixOffset, fixLength);
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        DebugLogger.log(LogTag.REPLAY, "Back pressured trying to sendFixMessage");
        return ControlledFragmentHandler.Action.ABORT;
    }

    @Override
    boolean attemptReplay() {
        switch (this.state) {
            case REPLAYING: {
                DebugLogger.log(LogTag.REPLAY_ATTEMPT, "ReplayerSession: REPLAYING step");
                if (this.replayOperation.pollReplay()) {
                    this.state = State.CHECK_REPLAY;
                    return this.attemptReplay();
                }
                return false;
            }
            case CHECK_REPLAY: {
                DebugLogger.log(LogTag.REPLAY_ATTEMPT, "ReplayerSession: CHECK_REPLAY step");
                if (this.completeReplay()) {
                    this.state = State.SEND_COMPLETE_MESSAGE;
                }
                return false;
            }
            case SEND_COMPLETE_MESSAGE: {
                return this.sendCompleteMessage();
            }
            case CLOSING: {
                return this.replayOperation.pollReplay();
            }
        }
        return false;
    }

    private boolean completeReplay() {
        int replayedMessages = this.replayOperation.replayedMessages();
        if (this.beginGapFillSeqNum != -1) {
            int newSequenceNumber = this.endSeqNo + 1;
            if (newSequenceNumber > this.beginGapFillSeqNum) {
                ControlledFragmentHandler.Action action = this.sendGapFill(this.beginGapFillSeqNum, newSequenceNumber);
                if (DebugLogger.IS_REPLAY_LOG_TAG_ENABLED) {
                    DebugLogger.log(LogTag.REPLAY, this.replayer.completeReplayGapfillFormatter.clear().with(action.name()).with(replayedMessages).with(this.beginGapFillSeqNum).with(newSequenceNumber).with(this.connectionId));
                }
                return action != ControlledFragmentHandler.Action.ABORT;
            }
        } else {
            int expectedCount = this.endSeqNo - this.beginSeqNo + 1;
            if (DebugLogger.IS_REPLAY_LOG_TAG_ENABLED) {
                DebugLogger.log(LogTag.REPLAY, this.replayer.completeNotRecentFormatter.clear().with(replayedMessages).with(this.endSeqNo).with(this.beginSeqNo).with(expectedCount).with(this.connectionId));
            }
            if (replayedMessages != expectedCount) {
                ControlledFragmentHandler.Action action;
                if (replayedMessages == 0 && (action = this.sendGapFill(this.beginSeqNo, this.endSeqNo + 1)) == ControlledFragmentHandler.Action.ABORT) {
                    return false;
                }
                this.onIllegalState("[%s] Error in resend request, count(%d) < expectedCount (%d)", this.message, replayedMessages, expectedCount);
            }
        }
        return true;
    }

    @Override
    void startClose() {
        this.state = State.CLOSING;
        super.startClose();
    }

    public String toString() {
        return "FixReplayerSession{message='" + this.message + '\'' + ", gapFillMessageTypes=" + this.gapFillMessageTypes + ", bytesInBuffer=" + this.bytesInBuffer + ", maxBytesInBuffer=" + this.maxBytesInBuffer + ", lastSeqNo=" + this.lastSeqNo + ", beginGapFillSeqNum=" + this.beginGapFillSeqNum + ", state=" + (Object)((Object)this.state) + ", connectionId=" + this.connectionId + ", beginSeqNo=" + this.beginSeqNo + ", endSeqNo=" + this.endSeqNo + ", sessionId=" + this.sessionId + ", sequenceIndex=" + this.sequenceIndex + '}';
    }

    private static enum State {
        REPLAYING,
        CHECK_REPLAY,
        SEND_COMPLETE_MESSAGE,
        CLOSING;

    }
}

