/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.logger.MessageTracker;
import uk.co.real_logic.artio.fixp.AbstractFixPParser;

public class FixPMessageTracker
extends MessageTracker {
    private final AbstractFixPParser fixPParser;
    private int totalMessages;

    public FixPMessageTracker(ControlledFragmentHandler messageHandler, AbstractFixPParser fixPParser, int totalMessages) {
        super(LogTag.REPLAY, messageHandler);
        this.fixPParser = fixPParser;
        this.totalMessages = totalMessages;
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int templateId = this.messageHeaderDecoder.templateId();
        if (templateId == 58) {
            int encoderOffset = offset + 8;
            int headerOffset = encoderOffset + 4 + 24;
            boolean retransmittedMessage = this.fixPParser.isRetransmittedMessage(buffer, headerOffset);
            if (!retransmittedMessage || this.count >= this.maxCount || this.totalMessages <= 0) {
                return ControlledFragmentHandler.Action.CONTINUE;
            }
            ControlledFragmentHandler.Action action = this.messageHandler.onFragment(buffer, offset, length, header);
            if (action != ControlledFragmentHandler.Action.ABORT) {
                --this.totalMessages;
                ++this.count;
            }
            return action;
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }
}

