/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.logger.MessageTracker;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.ThrottleNotificationDecoder;
import uk.co.real_logic.artio.messages.ThrottleRejectDecoder;
import uk.co.real_logic.artio.util.CharFormatter;

public class FixMessageTracker
extends MessageTracker {
    private final ThrottleNotificationDecoder throttleNotification = new ThrottleNotificationDecoder();
    private final ThrottleRejectDecoder throttleReject = new ThrottleRejectDecoder();
    private final FixMessageDecoder messageDecoder = new FixMessageDecoder();
    private final long sessionId;

    public FixMessageTracker(LogTag logTag, ControlledFragmentHandler messageHandler, long sessionId) {
        super(logTag, messageHandler);
        this.sessionId = sessionId;
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        MessageHeaderDecoder messageHeaderDecoder = this.messageHeaderDecoder;
        messageHeaderDecoder.wrap(buffer, offset);
        int messageOffset = offset + 8;
        int templateId = messageHeaderDecoder.templateId();
        int blockLength = messageHeaderDecoder.blockLength();
        int version = messageHeaderDecoder.version();
        if (templateId == 1) {
            if (this.sessionId != -1L) {
                this.messageDecoder.wrap(buffer, messageOffset, blockLength, version);
                if (this.messageDecoder.session() != this.sessionId) {
                    return ControlledFragmentHandler.Action.CONTINUE;
                }
            }
            if (DebugLogger.isEnabled(this.logTag)) {
                this.messageDecoder.skipMetaData();
                int bodyLength = this.messageDecoder.bodyLength();
                int bodyOffset = this.messageDecoder.limit() + FixMessageDecoder.bodyHeaderLength();
                CharFormatter formatter = (CharFormatter)FOUND_REPLAY_MESSAGE.get();
                formatter.clear();
                DebugLogger.log(this.logTag, formatter, buffer, bodyOffset, bodyLength);
            }
            return this.processFragment(buffer, offset, length, header);
        }
        if (templateId == 70) {
            this.throttleNotification.wrap(buffer, messageOffset, blockLength, version);
            return this.onThrottle(this.throttleNotification.session(), buffer, offset, length, header);
        }
        if (templateId == 71) {
            this.throttleReject.wrap(buffer, messageOffset, blockLength, version);
            return this.onThrottle(this.throttleReject.session(), buffer, offset, length, header);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onThrottle(long sessionId, DirectBuffer buffer, int offset, int length, Header header) {
        if (sessionId != this.sessionId) {
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        return this.processFragment(buffer, offset, length, header);
    }

    private ControlledFragmentHandler.Action processFragment(DirectBuffer buffer, int offset, int length, Header header) {
        ControlledFragmentHandler.Action action = this.messageHandler.onFragment(buffer, offset, length, header);
        if (action != ControlledFragmentHandler.Action.ABORT) {
            ++this.count;
        }
        return action;
    }
}

