/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Aeron;
import io.aeron.ChannelUri;
import io.aeron.FragmentAssembler;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.agrona.collections.IntHashSet;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.logger.ArchiveScanPlanner;
import uk.co.real_logic.artio.engine.logger.FixMessageConsumer;
import uk.co.real_logic.artio.engine.logger.FixMessageLogger;
import uk.co.real_logic.artio.engine.logger.IndexQuery;
import uk.co.real_logic.artio.engine.logger.PositionRange;
import uk.co.real_logic.artio.engine.logger.StreamTimestampZipper;
import uk.co.real_logic.artio.engine.logger.TimeIndexReader;
import uk.co.real_logic.artio.fixp.FixPMessageConsumer;

public class FixArchiveScanner
implements AutoCloseable {
    public static final int DEFAULT_FRAGMENT_LIMIT = 10000;
    static final boolean DEBUG_LOG_ARCHIVE_SCAN = DebugLogger.isEnabled(LogTag.ARCHIVE_SCAN);
    private final Aeron aeron;
    private final AeronArchive aeronArchive;
    private final IdleStrategy idleStrategy;
    private final int compactionSize;
    private final int maximumBufferSize;
    private final int fragmentLimit;
    private final String logFileDir;
    private final Long2ObjectHashMap<TimeIndexReader> streamIdToInboundTimeIndex = new Long2ObjectHashMap();

    public FixArchiveScanner(Configuration configuration) {
        configuration.conclude();
        this.idleStrategy = configuration.idleStrategy();
        this.compactionSize = configuration.compactionSize;
        this.maximumBufferSize = configuration.maximumBufferSize;
        this.fragmentLimit = configuration.fragmentLimit;
        Aeron.Context aeronContext = new Aeron.Context().aeronDirectoryName(configuration.aeronDirectoryName());
        this.aeron = Aeron.connect(aeronContext);
        AeronArchive.Context archiveContext = configuration.archiveContext;
        if (archiveContext == null) {
            archiveContext = new AeronArchive.Context();
        }
        this.aeronArchive = AeronArchive.connect(archiveContext.aeron(this.aeron).ownsAeronClient(true));
        String logFileDir = configuration.logFileDir();
        boolean enableIndexScan = configuration.enableIndexScan();
        this.logFileDir = logFileDir != null && enableIndexScan ? logFileDir : null;
    }

    public void scan(String aeronChannel, int queryStreamId, FixMessageConsumer handler, boolean follow, int archiveScannerStreamId) {
        this.scan(aeronChannel, queryStreamId, handler, null, follow, archiveScannerStreamId);
    }

    public void scan(String aeronChannel, int queryStreamId, FixMessageConsumer fixHandler, FixPMessageConsumer fixPHandler, boolean follow, int archiveScannerStreamId) {
        IntHashSet queryStreamIds = new IntHashSet();
        queryStreamIds.add(queryStreamId);
        this.scan(aeronChannel, queryStreamIds, fixHandler, fixPHandler, follow, archiveScannerStreamId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void scan(String aeronChannel, IntHashSet queryStreamIds, FixMessageConsumer fixHandler, FixPMessageConsumer fixPHandler, boolean follow, int archiveScannerStreamId) {
        if (fixHandler != null) {
            fixHandler.reset();
        }
        Long2ObjectHashMap<PositionRange> recordingIdToPositionRange = this.scanIndexIfPossible(fixHandler, follow, queryStreamIds);
        try (Subscription replaySubscription = this.aeron.addSubscription("aeron:ipc", archiveScannerStreamId);){
            Object[] pollers = this.makeRecordingPollers(aeronChannel, queryStreamIds, follow, recordingIdToPositionRange, replaySubscription);
            if (DEBUG_LOG_ARCHIVE_SCAN) {
                DebugLogger.log(LogTag.ARCHIVE_SCAN, "Pollers: %s", pollers);
            }
            StreamTimestampZipper timestampZipper = new StreamTimestampZipper(fixHandler, fixPHandler, this.compactionSize, this.maximumBufferSize, !follow, (StreamTimestampZipper.Poller[])pollers);
            while (true) {
                int received;
                if (0 == (received = timestampZipper.poll()) && !follow && this.checkCompletion((RecordingPoller[])pollers)) {
                    timestampZipper.onClose();
                    this.idleStrategy.reset();
                    return;
                }
                this.idleStrategy.idle(received);
                continue;
                break;
            }
        }
    }

    private RecordingPoller[] makeRecordingPollers(String aeronChannel, IntHashSet queryStreamIds, boolean follow, Long2ObjectHashMap<PositionRange> recordingIdToPositionRange, Subscription replaySubscription) {
        return (RecordingPoller[])queryStreamIds.stream().flatMap(id -> this.lookupArchiveLocations((int)id, follow, aeronChannel, recordingIdToPositionRange).stream().filter(archiveLocation -> archiveLocation.length() != 0L).map(archiveLocation -> new RecordingPoller(replaySubscription, (int)id, (ArchiveLocation)archiveLocation))).toArray(RecordingPoller[]::new);
    }

    private Long2ObjectHashMap<PositionRange> scanIndexIfPossible(FixMessageConsumer fixHandler, boolean follow, IntHashSet queryStreamIds) {
        if (DEBUG_LOG_ARCHIVE_SCAN) {
            DebugLogger.log(LogTag.ARCHIVE_SCAN, "checking index,follow=" + follow + ",logFileDir=" + this.logFileDir + ",queryStreamIds=" + queryStreamIds);
        }
        if (follow) {
            return null;
        }
        if (this.logFileDir == null) {
            return null;
        }
        try {
            IndexQuery indexQuery = ArchiveScanPlanner.extractIndexQuery(fixHandler);
            if (DEBUG_LOG_ARCHIVE_SCAN) {
                DebugLogger.log(LogTag.ARCHIVE_SCAN, "indexQuery = " + indexQuery);
            }
            if (indexQuery == null) {
                return null;
            }
            Long2ObjectHashMap<PositionRange> recordingIdToPositionRange = new Long2ObjectHashMap<PositionRange>();
            IntHashSet.IntIterator intIterator = queryStreamIds.iterator();
            while (intIterator.hasNext()) {
                int streamId = (Integer)intIterator.next();
                TimeIndexReader reader = this.streamIdToInboundTimeIndex.get(streamId);
                if (reader == null) {
                    reader = new TimeIndexReader(this.logFileDir, streamId);
                    this.streamIdToInboundTimeIndex.put(streamId, reader);
                }
                if (reader.findPositionRange(indexQuery, recordingIdToPositionRange)) continue;
                return null;
            }
            if (DEBUG_LOG_ARCHIVE_SCAN) {
                DebugLogger.log(LogTag.ARCHIVE_SCAN, "recordingIdToPositionRange = " + recordingIdToPositionRange);
            }
            return recordingIdToPositionRange;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private boolean checkCompletion(RecordingPoller[] pollers) {
        for (RecordingPoller poller : pollers) {
            if (poller.isComplete()) continue;
            return false;
        }
        return true;
    }

    private List<ArchiveLocation> lookupArchiveLocations(int queryStreamId, boolean follow, String aeronChannel, Long2ObjectHashMap<PositionRange> recordingIdToPositionRange) {
        ArrayList<ArchiveLocation> archiveLocations = new ArrayList<ArchiveLocation>();
        this.aeronArchive.listRecordings(0L, Integer.MAX_VALUE, (controlSessionId, correlationId, recordingId, startTimestamp, stopTimestamp, startPosition, stopPosition, initialTermId, segmentFileLength, termBufferLength, mtuLength, sessionId, streamId, strippedChannel, originalChannel, sourceIdentity) -> {
            ChannelUri uri = ChannelUri.parse(strippedChannel);
            uri.remove("session-id");
            String comparableChannel = uri.toString();
            if (streamId == queryStreamId && comparableChannel.contains(aeronChannel)) {
                archiveLocations.add(new ArchiveLocation(recordingId, startPosition, stopPosition));
            }
        });
        if (!follow) {
            for (ArchiveLocation location : archiveLocations) {
                if (location.stopPosition != -1L) continue;
                location.stopPosition = this.aeronArchive.getRecordingPosition(location.recordingId);
            }
        }
        if (recordingIdToPositionRange != null) {
            Iterator iterator = archiveLocations.iterator();
            while (iterator.hasNext()) {
                ArchiveLocation location;
                location = (ArchiveLocation)iterator.next();
                PositionRange positionRange = recordingIdToPositionRange.get(location.recordingId);
                if (positionRange == null) {
                    iterator.remove();
                    continue;
                }
                long startPosition2 = positionRange.startPosition();
                long endPosition = positionRange.endPosition();
                if (location.stopPosition > endPosition) {
                    location.stopPosition = endPosition;
                }
                if (location.startPosition >= startPosition2) continue;
                location.startPosition = startPosition2;
            }
        }
        return archiveLocations;
    }

    @Override
    public void close() {
        this.aeronArchive.close();
    }

    class RecordingPoller
    implements StreamTimestampZipper.Poller {
        private final Subscription replaySubscription;
        private final int originalStreamId;
        private ArchiveLocation archiveLocation;
        long stopPosition;
        Image image;

        RecordingPoller(Subscription replaySubscription, int originalStreamId, ArchiveLocation archiveLocation) {
            this.replaySubscription = replaySubscription;
            this.originalStreamId = originalStreamId;
            this.archiveLocation = archiveLocation;
        }

        @Override
        public boolean isComplete() {
            return this.stopPosition != -1L && this.image == null && this.archiveLocation == null;
        }

        @Override
        public int poll(FragmentAssembler fragmentAssembler) {
            if (this.image == null) {
                if (this.archiveLocation == null) {
                    return 0;
                }
                if (this.archiveLocation.length() != 0L) {
                    int sessionId = (int)FixArchiveScanner.this.aeronArchive.startReplay(this.archiveLocation.recordingId, this.archiveLocation.startPosition, this.archiveLocation.length(), "aeron:ipc", this.replaySubscription.streamId());
                    this.image = this.lookupImage(sessionId);
                    this.stopPosition = this.archiveLocation.stopPosition;
                    this.archiveLocation = null;
                }
                return 1;
            }
            if (this.stopPosition != -1L && this.image.position() >= this.stopPosition) {
                this.image = null;
                return 1;
            }
            return this.image.poll(fragmentAssembler, FixArchiveScanner.this.fragmentLimit);
        }

        @Override
        public int streamId() {
            return this.originalStreamId;
        }

        private Image lookupImage(int sessionId) {
            Image image = null;
            while (image == null) {
                FixArchiveScanner.this.idleStrategy.idle();
                image = this.replaySubscription.imageBySessionId(sessionId);
            }
            FixArchiveScanner.this.idleStrategy.reset();
            return image;
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "RecordingPoller{archiveLocations=" + this.archiveLocation + ", replaySubscription=" + this.replaySubscription + ", originalStreamId=" + this.originalStreamId + ", stopPosition=" + this.stopPosition + ", image=" + this.image + '}';
        }
    }

    static class ArchiveLocation {
        final long recordingId;
        long startPosition;
        long stopPosition;

        ArchiveLocation(long recordingId, long startPosition, long stopPosition) {
            this.recordingId = recordingId;
            this.startPosition = startPosition;
            this.stopPosition = stopPosition;
        }

        public long stopPosition() {
            return this.stopPosition;
        }

        public long length() {
            return this.startPosition == -1L ? -1L : this.stopPosition - this.startPosition;
        }

        public String toString() {
            return "ArchiveLocation{recordingId=" + this.recordingId + ", startPosition=" + this.startPosition + ", stopPosition=" + this.stopPosition + '}';
        }
    }

    public static class Configuration {
        private int fragmentLimit = 10000;
        private String aeronDirectoryName;
        private IdleStrategy idleStrategy;
        private int compactionSize = 0x10000000;
        public int maximumBufferSize = 0x3FFFFFFB;
        private String logFileDir;
        private boolean enableIndexScan;
        private AeronArchive.Context archiveContext;

        public Configuration aeronDirectoryName(String aeronDirectoryName) {
            this.aeronDirectoryName = aeronDirectoryName;
            return this;
        }

        public String aeronDirectoryName() {
            return this.aeronDirectoryName;
        }

        public Configuration idleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategy;
        }

        public Configuration compactionSize(int compactionSize) {
            FixMessageLogger.Configuration.validateCompactionSize(compactionSize);
            this.compactionSize = compactionSize;
            return this;
        }

        public int compactionSize() {
            return this.compactionSize;
        }

        public Configuration maximumBufferSize(int maximumBufferSize) {
            FixMessageLogger.Configuration.validateMaximumBufferSize(maximumBufferSize);
            this.maximumBufferSize = maximumBufferSize;
            return this;
        }

        public int maximumBufferSize() {
            return this.maximumBufferSize;
        }

        public Configuration fragmentLimit(int fragmentLimit) {
            this.fragmentLimit = fragmentLimit;
            return this;
        }

        public int fragmentLimit() {
            return this.fragmentLimit;
        }

        public Configuration logFileDir(String logFileDir) {
            this.logFileDir = logFileDir;
            this.enableIndexScan = true;
            return this;
        }

        public String logFileDir() {
            return this.logFileDir;
        }

        public Configuration enableIndexScan(boolean enableIndexScan) {
            this.enableIndexScan = enableIndexScan;
            return this;
        }

        public boolean enableIndexScan() {
            return this.enableIndexScan;
        }

        public Configuration archiveContext(AeronArchive.Context archiveContext) {
            this.archiveContext = archiveContext;
            return this;
        }

        private void conclude() {
            if (this.enableIndexScan && this.logFileDir == null) {
                throw new IllegalArgumentException("Please configure a logFileDir if you want to enable index scan");
            }
            FixMessageLogger.Configuration.validateMaxAndCompactionSize(this.maximumBufferSize, this.compactionSize);
        }
    }
}

