/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import uk.co.real_logic.artio.decoder.AbstractUserRequestDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.artio.validation.AuthenticationStrategy;

class UserRequestExtractor {
    private final AsciiBuffer asciiBuffer = new MutableAsciiBuffer();
    private final AbstractUserRequestDecoder userRequest;
    private final FixDictionary dictionary;
    private final ErrorHandler errorHandler;

    UserRequestExtractor(FixDictionary dictionary, ErrorHandler errorHandler) {
        this.userRequest = dictionary.makeUserRequestDecoder();
        this.dictionary = dictionary;
        this.errorHandler = errorHandler;
    }

    void onUserRequest(DirectBuffer buffer, int offset, int length, AuthenticationStrategy authenticationStrategy, long connectionId, long sessionId) {
        if (this.userRequest == null) {
            this.errorHandler.onError(new IllegalStateException(String.format("Received User Request message despite there being no user request message type defined in dictionary (dict=%s, conn=%d, sess=%d)", this.dictionary.getClass().getName(), connectionId, sessionId)));
            return;
        }
        this.asciiBuffer.wrap(buffer);
        this.userRequest.reset();
        this.userRequest.decode(this.asciiBuffer, offset, length);
        authenticationStrategy.onUserRequest(this.userRequest, sessionId);
    }
}

