/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.util.Arrays;
import java.util.List;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.engine.framer.Continuation;

class UnitOfWork
implements Continuation {
    List<Continuation> workList;
    private int index = 0;

    UnitOfWork(Continuation ... work) {
        this.work(work);
    }

    void work(Continuation ... work) {
        this.workList = Arrays.asList(work);
    }

    UnitOfWork(List<Continuation> workList) {
        this.workList = workList;
    }

    @Override
    public long attempt() {
        int size = this.workList.size();
        while (this.index < size) {
            Continuation continuation = this.workList.get(this.index);
            long position = continuation.attempt();
            if (Pressure.isBackPressured(position)) {
                return position;
            }
            ++this.index;
        }
        return 1L;
    }

    void add(Continuation continuation) {
        this.workList.add(continuation);
    }
}

