/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.util.concurrent.TimeUnit;
import org.agrona.DeadlineTimerWheel;
import org.agrona.ErrorHandler;
import org.agrona.collections.Long2ObjectHashMap;
import uk.co.real_logic.artio.engine.framer.GatewaySessions;

final class TimerEventHandler
implements DeadlineTimerWheel.TimerHandler {
    private final Long2ObjectHashMap<GatewaySessions.PendingAcceptorLogon> timerIdToPendingAcceptorLogons = new Long2ObjectHashMap();
    private final ErrorHandler errorHandler;

    TimerEventHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public boolean onTimerExpiry(TimeUnit timeUnit, long now, long timerId) {
        GatewaySessions.PendingAcceptorLogon pendingAcceptorLogon = this.timerIdToPendingAcceptorLogons.get(timerId);
        if (pendingAcceptorLogon == null) {
            this.errorHandler.onError(new IllegalStateException("Unknown timer id: " + timerId));
            return true;
        }
        return pendingAcceptorLogon.onLingerTimeout();
    }

    public void startLingering(long timerId, GatewaySessions.PendingAcceptorLogon pendingAcceptorLogon) {
        this.timerIdToPendingAcceptorLogons.put(timerId, pendingAcceptorLogon);
    }
}

