/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.agrona.LangUtil;

public class TcpChannel
implements AutoCloseable {
    private final SocketChannel socketChannel;
    private final String remoteAddress;

    public TcpChannel(SocketChannel socketChannel) throws IOException {
        this.socketChannel = socketChannel;
        this.remoteAddress = socketChannel.getRemoteAddress().toString();
    }

    public String remoteAddr() {
        return this.remoteAddress;
    }

    public SelectionKey register(Selector sel, int ops, Object att) throws ClosedChannelException {
        return this.socketChannel.register(sel, ops, att);
    }

    public int write(ByteBuffer src) throws IOException {
        int written = this.socketChannel.write(src);
        if (written < 0) {
            throw new IOException("Disconnected " + this.remoteAddress + ", written=" + written);
        }
        return written;
    }

    public int read(ByteBuffer dst) throws IOException {
        return this.socketChannel.read(dst);
    }

    @Override
    public void close() {
        if (this.socketChannel.isOpen()) {
            try {
                this.socketChannel.close();
            }
            catch (IOException ex) {
                LangUtil.rethrowUnchecked(ex);
            }
        }
    }
}

