/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.Image;
import io.aeron.logbuffer.ControlledFragmentHandler;
import org.agrona.ErrorHandler;
import uk.co.real_logic.artio.engine.framer.BlockablePosition;

class SlowPeeker
extends BlockablePosition {
    final Image normalImage;
    final Image peekImage;

    SlowPeeker(Image peekImage, Image normalImage, ErrorHandler errorHandler) {
        super(peekImage.mtuLength() - 32, errorHandler);
        this.peekImage = peekImage;
        this.normalImage = normalImage;
    }

    int peek(ControlledFragmentHandler handler) {
        long initialPosition = this.peekImage.position();
        long normalImagePosition = this.normalImage.position();
        this.startPeek(initialPosition, normalImagePosition);
        long resultingPosition = this.peekImage.controlledPeek(initialPosition, handler, normalImagePosition);
        long delta = resultingPosition - initialPosition;
        if (!this.peekImage.isClosed()) {
            long blockPosition = this.blockPosition();
            if (blockPosition != 0L) {
                this.peekImage.position(blockPosition);
            } else {
                this.peekImage.position(resultingPosition);
            }
            return (int)delta;
        }
        return 0;
    }
}

