/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.engine.SessionInfo;
import uk.co.real_logic.artio.engine.framer.FixContexts;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.Session;

class SessionContext
implements SessionInfo {
    private final CompositeKey compositeKey;
    private final long sessionId;
    private final FixContexts fixContexts;
    private volatile int sequenceIndex;
    private final int initialSequenceIndex;
    private long lastLogonTimeInNs;
    private long lastSequenceResetTimeInNs;
    private FixDictionary lastFixDictionary;
    private int filePosition;

    SessionContext(CompositeKey compositeKey, long sessionId, int sequenceIndex, long lastLogonTimeInNs, long lastSequenceResetTimeInNs, FixContexts fixContexts, int filePosition, int initialSequenceIndex, FixDictionary lastFixDictionary) {
        this.compositeKey = compositeKey;
        this.sessionId = sessionId;
        this.sequenceIndex = sequenceIndex;
        this.initialSequenceIndex = initialSequenceIndex;
        this.lastLogonTimeInNs(lastLogonTimeInNs);
        this.lastSequenceResetTimeInNs = lastSequenceResetTimeInNs;
        this.fixContexts = fixContexts;
        this.filePosition = filePosition;
        this.lastFixDictionary = lastFixDictionary;
    }

    private void lastLogonTimeInNs(long lastLogonTime) {
        this.lastLogonTimeInNs = lastLogonTime;
    }

    void onSequenceReset(long resetTimeInNs) {
        int newSequenceIndex = this.sequenceIndex == -1 ? this.initialSequenceIndex : this.sequenceIndex + 1;
        this.onSequenceIndex(resetTimeInNs, newSequenceIndex);
    }

    void onSequenceIndex(long resetTimeInNs, int sequenceIndex) {
        this.lastSequenceResetTimeInNs = resetTimeInNs;
        this.sequenceIndex = sequenceIndex;
        this.save();
    }

    void updateAndSaveFrom(Session session) {
        this.updateFrom(session);
        this.save();
    }

    void ensureFixDictionary(FixDictionary fixDictionary) {
        if (this.lastFixDictionary != fixDictionary) {
            this.lastFixDictionary = fixDictionary;
            this.save();
        }
    }

    private void save() {
        this.fixContexts.updateSavedData(this, this.filePosition);
    }

    void filePosition(int filePosition) {
        this.filePosition = filePosition;
    }

    void updateFrom(Session session) {
        this.sequenceIndex = session.sequenceIndex();
        this.lastLogonTimeInNs(session.lastLogonTimeInNs());
        this.lastSequenceResetTimeInNs = session.lastSequenceResetTimeInNs();
    }

    void onLogon(boolean resetSeqNum, long timeInNs, FixDictionary fixDictionary) {
        this.lastFixDictionary = fixDictionary;
        this.lastLogonTimeInNs(timeInNs);
        if (resetSeqNum || this.sequenceIndex == -1) {
            this.onSequenceReset(timeInNs);
        } else {
            this.save();
        }
    }

    @Override
    public int sequenceIndex() {
        return this.sequenceIndex;
    }

    @Override
    public long sessionId() {
        return this.sessionId;
    }

    @Override
    public CompositeKey sessionKey() {
        return this.compositeKey;
    }

    public long lastSequenceResetTime() {
        return this.lastSequenceResetTimeInNs;
    }

    public long lastLogonTimeInNs() {
        return this.lastLogonTimeInNs;
    }

    public FixDictionary lastFixDictionary() {
        return this.lastFixDictionary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionContext that = (SessionContext)o;
        return this.sessionId == that.sessionId;
    }

    public int hashCode() {
        return (int)(this.sessionId ^ this.sessionId >>> 32);
    }

    public String toString() {
        return "SessionContext{sessionId=" + this.sessionId + ", sequenceIndex=" + this.sequenceIndex + ", compositeKey=" + this.compositeKey + ", lastLogonTime=" + this.lastLogonTimeInNs + ", lastSequenceResetTimeInNs=" + this.lastSequenceResetTimeInNs + '}';
    }
}

