/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.collections.LongArrayQueue;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.engine.ByteBufferUtil;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.MessageTimingHandler;
import uk.co.real_logic.artio.engine.SenderSequenceNumber;
import uk.co.real_logic.artio.engine.framer.BlockablePosition;
import uk.co.real_logic.artio.engine.framer.FixReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.FixThrottleRejectBuilder;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.SenderEndPoint;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.engine.logger.ArchiveDescriptor;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.ThrottleRejectDecoder;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.util.CharFormatter;

class FixSenderEndPoint
extends SenderEndPoint {
    private static final int HEADER_LENGTH = 8;
    static final int START_REPLAY_LENGTH = 32;
    static final int TOTAL_START_REPLAY_LENGTH = 64;
    private static final int REPLAY_MESSAGE = -1;
    public static final int THROTTLE_BUSINESS_REJECT_REASON = 99;
    private final long connectionId;
    private final AtomicCounter invalidLibraryAttempts;
    private final long slowConsumerTimeoutInMs;
    private final StreamTracker outboundTracker;
    private final StreamTracker replayTracker;
    private final SenderSequenceNumber senderSequenceNumber;
    private final MessageTimingHandler messageTimingHandler;
    private final FixReceiverEndPoint receiverEndPoint;
    private final LongArrayQueue replayQueue;
    private final Formatters formatters;
    private long sessionId;
    private long sendingTimeoutTimeInMs;
    private boolean replayPaused;
    private FixThrottleRejectBuilder throttleRejectBuilder;
    private FixDictionary fixDictionary;
    private CompositeKey sessionKey;
    private EngineConfiguration configuration;
    private long lastProcessedReplay;
    private long replayInFlight;

    FixSenderEndPoint(long connectionId, int libraryId, BlockablePosition outboundBlockablePosition, ExclusivePublication inboundPublication, BlockablePosition replayBlockablePosition, TcpChannel channel, AtomicCounter bytesInBuffer, AtomicCounter invalidLibraryAttempts, ErrorHandler errorHandler, Framer framer, int maxBytesInBuffer, long slowConsumerTimeoutInMs, long timeInMs, SenderSequenceNumber senderSequenceNumber, MessageTimingHandler messageTimingHandler, int maxConcurrentSessionReplays, FixReceiverEndPoint receiverEndPoint, Formatters formatters) {
        super(connectionId, inboundPublication, libraryId, channel, bytesInBuffer, maxBytesInBuffer, errorHandler, framer);
        this.connectionId = connectionId;
        this.invalidLibraryAttempts = invalidLibraryAttempts;
        this.slowConsumerTimeoutInMs = slowConsumerTimeoutInMs;
        this.senderSequenceNumber = senderSequenceNumber;
        this.outboundTracker = new StreamTracker(outboundBlockablePosition);
        this.replayTracker = new StreamTracker(replayBlockablePosition);
        this.messageTimingHandler = messageTimingHandler;
        this.receiverEndPoint = receiverEndPoint;
        this.formatters = formatters;
        this.sendingTimeoutTimeInMs = timeInMs + slowConsumerTimeoutInMs;
        this.replayQueue = new LongArrayQueue(Math.max(8, maxConcurrentSessionReplays), 0L);
    }

    void onOutboundMessage(int libraryId, DirectBuffer directBuffer, int offset, int bodyLength, int sequenceNumber, Header header, long timeInMs, int metaDataLength) {
        if (this.isWrongLibraryId(libraryId)) {
            this.invalidLibraryAttempts.increment();
            return;
        }
        if (this.replayPaused) {
            this.dropFurtherBehind(bodyLength);
            return;
        }
        MessageTimingHandler messageTimingHandler = this.messageTimingHandler;
        if (this.attemptFramedMessage(directBuffer, offset, bodyLength, timeInMs, header, this.outboundTracker) && messageTimingHandler != null) {
            int metaDataOffset = offset - FixMessageDecoder.bodyHeaderLength() - metaDataLength;
            messageTimingHandler.onMessage(sequenceNumber, this.connectionId, directBuffer, metaDataOffset, metaDataLength);
        }
        this.senderSequenceNumber.onNewMessage(sequenceNumber);
    }

    public void onThrottleReject(int libraryId, long refMsgType, int refSeqNum, int sequenceNumber, DirectBuffer businessRejectRefIDBuffer, int businessRejectRefIDOffset, int businessRejectRefIDLength, Header header, long timeInMs) {
        if (this.isWrongLibraryId(libraryId)) {
            this.invalidLibraryAttempts.increment();
            return;
        }
        FixThrottleRejectBuilder throttleRejectBuilder = this.throttleRejectBuilder();
        if (!throttleRejectBuilder.build(refMsgType, refSeqNum, sequenceNumber, businessRejectRefIDBuffer, businessRejectRefIDOffset, businessRejectRefIDLength, false)) {
            return;
        }
        this.onOutboundMessage(libraryId, throttleRejectBuilder.buffer(), throttleRejectBuilder.offset(), throttleRejectBuilder.length(), sequenceNumber, header, timeInMs, 0);
    }

    public ControlledFragmentHandler.Action onSlowThrottleReject(int libraryId, long refMsgType, int refSeqNum, int sequenceNumber, DirectBuffer businessRejectRefIDBuffer, int businessRejectRefIDOffset, int businessRejectRefIDLength, Header header, long timeInMs) {
        if (this.isWrongLibraryId(libraryId)) {
            this.invalidLibraryAttempts.increment();
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        if (!this.isSlowConsumer()) {
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        long skipPosition = this.outboundTracker.skipPosition;
        long position = header.position();
        if (position > skipPosition) {
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        FixThrottleRejectBuilder throttleRejectBuilder = this.throttleRejectBuilder();
        if (!throttleRejectBuilder.build(refMsgType, refSeqNum, sequenceNumber, businessRejectRefIDBuffer, businessRejectRefIDOffset, businessRejectRefIDLength, false)) {
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        int fakeOffsetAfterHeader = throttleRejectBuilder.offset() - GatewayPublication.FRAME_SIZE;
        return this.attemptSlowMessage(throttleRejectBuilder.buffer(), fakeOffsetAfterHeader, this.throttleRejectLength(businessRejectRefIDLength), header, throttleRejectBuilder.length(), timeInMs, this.outboundTracker, 0, sequenceNumber);
    }

    private FixThrottleRejectBuilder throttleRejectBuilder() {
        if (this.throttleRejectBuilder == null) {
            this.throttleRejectBuilder = new FixThrottleRejectBuilder(this.fixDictionary, this.errorHandler, this.sessionId, this.connectionId, new UtcTimestampEncoder(this.configuration.sessionEpochFractionFormat()), this.configuration.epochNanoClock(), this.configuration.throttleWindowInMs(), this.configuration.throttleLimitOfMessages());
            this.configuration.sessionIdStrategy().setupSession(this.sessionKey, this.throttleRejectBuilder.header());
        }
        return this.throttleRejectBuilder;
    }

    boolean configureThrottle(int throttleWindowInMs, int throttleLimitOfMessages) {
        return this.throttleRejectBuilder().configureThrottle(throttleWindowInMs, throttleLimitOfMessages);
    }

    private int throttleRejectLength(int businessRejectRefIDLength) {
        return 40 + ThrottleRejectDecoder.businessRejectRefIDHeaderLength() + businessRejectRefIDLength;
    }

    ControlledFragmentHandler.Action onReplayMessage(DirectBuffer directBuffer, int offset, int bodyLength, long timeInMs, Header header) {
        if (!this.isSlowConsumer()) {
            this.replayPaused(true);
        }
        this.attemptFramedMessage(directBuffer, offset, bodyLength, timeInMs, header, this.replayTracker);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    ControlledFragmentHandler.Action onSlowReplayMessage(DirectBuffer buffer, int offset, int bodyLength, long timeInMs, Header header, int metaDataLength) {
        if (this.replayInFlight == 0L) {
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        if (!this.outboundTracker.partiallySentMessage) {
            this.replayPaused(true);
        }
        int totalFrameSize = GatewayPublication.FRAME_SIZE + metaDataLength;
        int offsetAfterHeader = offset - totalFrameSize;
        int length = bodyLength + totalFrameSize;
        return this.attemptSlowMessage(buffer, offsetAfterHeader, length, header, bodyLength, timeInMs, this.replayTracker, metaDataLength, -1);
    }

    private boolean attemptFramedMessage(DirectBuffer directBuffer, int offset, int bodyLength, long timeInMs, Header header, StreamTracker tracker) {
        if (this.isSlowConsumer()) {
            this.dropFurtherBehind(bodyLength);
            return false;
        }
        try {
            int written = this.writeFramedMessage(directBuffer, offset, bodyLength, timeInMs);
            if (written == bodyLength) {
                tracker.sentPosition = header.position();
                return true;
            }
            this.becomeSlowConsumer(written, bodyLength, header, tracker);
        }
        catch (IOException ex) {
            this.onError(ex);
        }
        return false;
    }

    private void dropFurtherBehind(int bodyLength) {
        long bytesInBuffer = this.bytesInBufferWeak() + (long)bodyLength;
        if (bytesInBuffer > (long)this.maxBytesInBuffer) {
            this.disconnectEndpoint(DisconnectReason.SLOW_CONSUMER);
        }
        this.bytesInBuffer.setOrdered(bytesInBuffer);
    }

    private int writeFramedMessage(DirectBuffer directBuffer, int offset, int length, long timeInMs) throws IOException {
        ByteBuffer buffer = directBuffer.byteBuffer();
        int startLimit = buffer.limit();
        int startPosition = buffer.position();
        ByteBufferUtil.limit(buffer, offset + length);
        ByteBufferUtil.position(buffer, offset);
        int written = this.channel.write(buffer);
        ByteBufferUtil.position(buffer, offset);
        DebugLogger.log(LogTag.FIX_MESSAGE_TCP, "Written  ", buffer, written);
        this.updateSendingTimeoutTimeInMs(timeInMs, written);
        buffer.limit(startLimit).position(startPosition);
        return written;
    }

    private void updateSendingTimeoutTimeInMs(long timeInMs, int written) {
        if (written > 0) {
            this.sendingTimeoutTimeInMs = timeInMs + this.slowConsumerTimeoutInMs;
        }
    }

    private void onError(Exception ex) {
        this.errorHandler.onError(new Exception(String.format("Exception reported for sessionId=%d,connectionId=%d", this.sessionId, this.connectionId), ex));
        this.disconnectEndpoint(DisconnectReason.EXCEPTION);
    }

    private void becomeSlowConsumer(int written, int bodyLength, Header header, StreamTracker tracker) {
        int remainingBytes = bodyLength - written;
        this.bytesInBuffer.setOrdered(remainingBytes);
        this.sendSlowStatus(true);
        tracker.sentPosition = header.position() - (long)remainingBytes;
        tracker.partiallySentMessage = true;
    }

    public void libraryId(int libraryId, BlockablePosition blockablePosition) {
        this.libraryId(libraryId);
        this.outboundTracker.blockablePosition = blockablePosition;
    }

    @Override
    public void close() {
        this.senderSequenceNumber.close();
        this.invalidLibraryAttempts.close();
        super.close();
    }

    ControlledFragmentHandler.Action onSlowOutboundMessage(DirectBuffer directBuffer, int offsetAfterHeader, int length, Header header, int bodyLength, int libraryId, long timeInMs, int metaDataLength, int sequenceNumber) {
        if (this.isWrongLibraryId(libraryId)) {
            this.invalidLibraryAttempts.increment();
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        if (this.replayPaused) {
            return this.blockPositionFixMessage(header, length, this.outboundTracker, false);
        }
        return this.attemptSlowMessage(directBuffer, offsetAfterHeader, length, header, bodyLength, timeInMs, this.outboundTracker, metaDataLength, sequenceNumber);
    }

    private ControlledFragmentHandler.Action attemptSlowMessage(DirectBuffer directBuffer, int offsetAfterHeader, int length, Header header, int bodyLength, long timeInMs, StreamTracker tracker, int metaDataLength, int sequenceNumber) {
        if (!this.isSlowConsumer()) {
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        long skipPosition = tracker.skipPosition;
        long position = header.position();
        if (position > skipPosition) {
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        long sentPosition = tracker.sentPosition;
        if (position <= sentPosition) {
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        if (this.partiallySentOtherStream(tracker)) {
            return this.blockPositionFixMessage(header, length, tracker, true);
        }
        try {
            int bytesPreviouslySent;
            int remainingLength;
            long startOfMessage = position - (long)length;
            if (sentPosition < startOfMessage) {
                remainingLength = bodyLength;
                bytesPreviouslySent = 0;
            } else {
                remainingLength = (int)(position - sentPosition);
                bytesPreviouslySent = bodyLength - remainingLength;
            }
            int metaDataOffset = offsetAfterHeader + 57 + FixMessageDecoder.metaDataHeaderLength();
            int dataOffset = metaDataOffset + FixMessageDecoder.bodyHeaderLength() + metaDataLength + bytesPreviouslySent;
            ByteBuffer buffer = directBuffer.byteBuffer();
            ByteBufferUtil.limit(buffer, dataOffset + remainingLength);
            ByteBufferUtil.position(buffer, dataOffset);
            int written = this.channel.write(buffer);
            this.bytesInBuffer.getAndAddOrdered(-written);
            this.updateSendingTimeoutTimeInMs(timeInMs, written);
            if (bodyLength > written + bytesPreviouslySent) {
                tracker.sentPosition = position - (long)remainingLength + (long)written;
                return this.blockPositionFixMessage(header, length, tracker, false);
            }
            tracker.sentPosition = position;
            tracker.partiallySentMessage = false;
            tracker.skipPosition = Long.MAX_VALUE;
            MessageTimingHandler messageTimingHandler = this.messageTimingHandler;
            if (sequenceNumber != -1 && messageTimingHandler != null) {
                messageTimingHandler.onMessage(sequenceNumber, this.connectionId, directBuffer, metaDataOffset, metaDataLength);
            }
            if (!this.isSlowConsumer()) {
                this.becomeNormalConsumer();
            }
        }
        catch (IOException ex) {
            this.onError(ex);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action blockPositionFixMessage(Header header, int fragLengthWithoutHeader, StreamTracker tracker, boolean partiallySentOther) {
        int aeronHeaderLength;
        BlockablePosition blockablePosition = tracker.blockablePosition;
        if ((header.flags() & 0xFFFFFFC0) == -64) {
            aeronHeaderLength = 32;
        } else {
            int fragmentCount = fragLengthWithoutHeader / blockablePosition.maxPayload + 1;
            aeronHeaderLength = fragmentCount * 32;
        }
        int frameLength = aeronHeaderLength + fragLengthWithoutHeader + 8;
        int alignedLength = ArchiveDescriptor.alignTerm(frameLength);
        long messagePosition = header.position();
        long messageStartPosition = messagePosition - (long)alignedLength;
        blockablePosition.blockPosition(messageStartPosition, true);
        tracker.skipPosition = messagePosition;
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void blockPositionOther(long messageStartPosition, long messagePosition, StreamTracker tracker, boolean slow) {
        BlockablePosition blockablePosition = tracker.blockablePosition;
        blockablePosition.blockPosition(messageStartPosition, slow);
        tracker.skipPosition = messagePosition;
    }

    private boolean partiallySentOtherStream(StreamTracker tracker) {
        return tracker == this.outboundTracker ? this.replayTracker.partiallySentMessage : this.outboundTracker.partiallySentMessage;
    }

    private boolean isWrongLibraryId(int libraryId) {
        return libraryId != this.libraryId;
    }

    boolean isSlowConsumer() {
        return this.bytesInBufferWeak() > 0L;
    }

    long bytesInBuffer() {
        return this.bytesInBuffer.get();
    }

    private long bytesInBufferWeak() {
        return this.bytesInBuffer.getWeak();
    }

    void sessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    long sessionId() {
        return this.sessionId;
    }

    boolean checkTimeouts(long timeInMs) {
        if (this.isSlowConsumer() && timeInMs > this.sendingTimeoutTimeInMs) {
            this.errorHandler.onError(new IllegalStateException(String.format("Slow Consumer Disconnected conn=%d,sess=%d @ time %d, Due to not being able to write since %d", this.connectionId, this.sessionId, timeInMs, this.sendingTimeoutTimeInMs - this.slowConsumerTimeoutInMs)));
            this.disconnectEndpoint(DisconnectReason.SLOW_CONSUMER);
            return true;
        }
        return false;
    }

    private void disconnectEndpoint(DisconnectReason reason) {
        this.receiverEndPoint.completeDisconnect(reason);
    }

    @Override
    public ControlledFragmentHandler.Action onReplayComplete(long correlationId, boolean slow) {
        StreamTracker replayTracker = this.replayTracker;
        long replayInFlight = this.replayInFlight;
        boolean partiallySentMessage = replayTracker.partiallySentMessage;
        long skipPosition = replayTracker.skipPosition;
        if (DebugLogger.IS_REPLAY_LOG_TAG_ENABLED) {
            DebugLogger.log(LogTag.REPLAY, this.formatters.replayComplete.clear().with(this.connectionId).with(correlationId).with(slow).with(replayInFlight).with(partiallySentMessage).with(skipPosition).with(this.lastProcessedReplay).with(this.replayQueue.toString()));
        }
        if (correlationId == replayInFlight && !partiallySentMessage && skipPosition == Long.MAX_VALUE) {
            this.replayPaused(false);
            this.lastProcessedReplay = replayInFlight;
            this.replayInFlight = 0L;
            return super.onReplayComplete(correlationId, slow);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    void fixDictionary(FixDictionary fixDictionary) {
        this.fixDictionary = fixDictionary;
    }

    void onLogon(CompositeKey sessionKey, EngineConfiguration configuration) {
        this.sessionKey = sessionKey;
        this.configuration = configuration;
    }

    public void onValidResendRequest(long correlationId, boolean slow) {
        if (correlationId <= this.lastProcessedReplay) {
            return;
        }
        long replayInFlight = this.replayInFlight;
        LongArrayQueue replayQueue = this.replayQueue;
        if (DebugLogger.IS_REPLAY_LOG_TAG_ENABLED) {
            DebugLogger.log(LogTag.REPLAY, this.formatters.validResendRequest.clear().with(this.connectionId).with(correlationId).with(slow).with(replayInFlight).with(replayQueue.toString()).with(this.lastProcessedReplay));
        }
        if (!this.contains(replayQueue, correlationId) && correlationId > replayInFlight) {
            replayQueue.addLong(correlationId);
        }
    }

    private boolean contains(LongArrayQueue replayQueue, long correlationId) {
        LongArrayQueue.LongIterator it = replayQueue.iterator();
        while (it.hasNext()) {
            if (it.nextValue() != correlationId) continue;
            return true;
        }
        return false;
    }

    public void onStartReplay(long correlationId, long msgPosition, boolean slow) {
        boolean slowConsumer = this.isSlowConsumer();
        if (slow == slowConsumer) {
            this.checkStartReplay(correlationId, msgPosition, slow);
        } else if (!slow) {
            this.dropFurtherBehind(32);
        }
    }

    private void checkStartReplay(long correlationId, long msgPosition, boolean slow) {
        if (DebugLogger.IS_REPLAY_LOG_TAG_ENABLED) {
            DebugLogger.log(LogTag.REPLAY, this.formatters.checkStartReplay.clear().with(this.connectionId).with(correlationId).with(slow).with(this.replayInFlight).with(this.replayQueue.toString()).with(this.lastProcessedReplay));
        }
        if (this.replayInFlight == correlationId) {
            return;
        }
        long nextReplayCorrelationId = this.replayQueue.peekLong();
        if (nextReplayCorrelationId == 0L) {
            this.blockStartReplay(msgPosition, slow);
            return;
        }
        if (this.replayInFlight != 0L) {
            this.errorHandler.onError(new IllegalStateException("invariant fail: replayInFlight = " + this.replayInFlight + " when trying to process " + correlationId + ", slow = " + slow + ",connectionId=" + this.connectionId));
        }
        if (nextReplayCorrelationId == correlationId) {
            this.replayInFlight = nextReplayCorrelationId;
            this.replayTracker.skipPosition = Long.MAX_VALUE;
            this.replayQueue.removeLong();
            if (slow) {
                this.dropFurtherBehind(-32);
            }
        } else {
            if (slow && correlationId < nextReplayCorrelationId) {
                return;
            }
            this.errorHandler.onError(new IllegalStateException("invariant fail: concurrent replays, next replay = " + nextReplayCorrelationId + " when received event for " + correlationId + ", slow = " + slow + ",connectionId=" + this.connectionId));
        }
    }

    private void blockStartReplay(long msgPosition, boolean slow) {
        StreamTracker replayTracker = this.replayTracker;
        long msgStartPosition = msgPosition - 64L;
        this.blockPositionOther(msgStartPosition, msgPosition, replayTracker, slow);
        if (!slow) {
            this.bytesInBuffer.setOrdered(32L);
            replayTracker.sentPosition = msgStartPosition;
            this.sendSlowStatus(true);
        }
    }

    private void replayPaused(boolean replayPaused) {
        if (this.replayPaused != replayPaused) {
            if (DebugLogger.IS_REPLAY_LOG_TAG_ENABLED) {
                DebugLogger.log(LogTag.REPLAY, this.formatters.replayPaused.clear().with(this.connectionId).with(this.sessionId).with(replayPaused));
            }
            this.replayPaused = replayPaused;
            if (replayPaused) {
                this.receiverEndPoint.pause();
            } else {
                this.receiverEndPoint.play();
            }
        }
    }

    boolean replayPaused() {
        return this.replayPaused;
    }

    public long replayInFlight() {
        return this.replayInFlight;
    }

    public LongArrayQueue queuedReplay() {
        return this.replayQueue;
    }

    public String toString() {
        return "FixSenderEndPoint{connectionId=" + this.connectionId + ", sessionId=" + this.sessionId + ", sessionKey=" + this.sessionKey + "} " + super.toString();
    }

    static class StreamTracker {
        private long sentPosition;
        private long skipPosition = Long.MAX_VALUE;
        private boolean partiallySentMessage = false;
        private BlockablePosition blockablePosition;

        StreamTracker(BlockablePosition blockablePosition) {
            this.blockablePosition = blockablePosition;
        }
    }

    static class Formatters {
        final CharFormatter replayPaused = new CharFormatter("connId=%s, sessId=%s, replayPaused=%s");
        final CharFormatter replayComplete = new CharFormatter("SEP.replayComplete, connId=%s, corrId=%s, slow=%s, replayInFlight=%s, partiallySent=%s, skipPosition=%s, lastProc=%s, queue=%s");
        final CharFormatter validResendRequest = new CharFormatter("SEP.validResendRequest, connId=%s, corrId=%s, slow=%s, replayInFlight=%s, queue=%s, lastProc=%s");
        final CharFormatter checkStartReplay = new CharFormatter("SEP.checkStartReplay, connId=%s, corrId=%s, slow=%s, replayInFlight=%s, queue=%s, lastProc=%s");

        Formatters() {
        }
    }
}

