/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import org.agrona.ErrorHandler;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.MessageTimingHandler;
import uk.co.real_logic.artio.engine.SenderSequenceNumbers;
import uk.co.real_logic.artio.engine.framer.BlockablePosition;
import uk.co.real_logic.artio.engine.framer.FixContexts;
import uk.co.real_logic.artio.engine.framer.FixGatewaySessions;
import uk.co.real_logic.artio.engine.framer.FixReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.FixSenderEndPoint;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.SlowPeeker;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.protocol.GatewayPublication;

class FixEndPointFactory {
    private final FixReceiverEndPoint.FixReceiverEndPointFormatters receiverFormatters = new FixReceiverEndPoint.FixReceiverEndPointFormatters();
    private final FixSenderEndPoint.Formatters senderFormatters = new FixSenderEndPoint.Formatters();
    private final EngineConfiguration configuration;
    private final FixContexts fixContexts;
    private final GatewayPublication inboundLibraryPublication;
    private final FixCounters fixCounters;
    private final ErrorHandler errorHandler;
    private final FixGatewaySessions gatewaySessions;
    private final SenderSequenceNumbers senderSequenceNumbers;
    private final MessageTimingHandler messageTimingHandler;
    private SlowPeeker replaySlowPeeker;

    FixEndPointFactory(EngineConfiguration configuration, FixContexts fixContexts, GatewayPublication inboundLibraryPublication, FixCounters fixCounters, ErrorHandler errorHandler, FixGatewaySessions gatewaySessions, SenderSequenceNumbers senderSequenceNumbers, MessageTimingHandler messageTimingHandler) {
        this.configuration = configuration;
        this.fixContexts = fixContexts;
        this.inboundLibraryPublication = inboundLibraryPublication;
        this.fixCounters = fixCounters;
        this.errorHandler = errorHandler;
        this.gatewaySessions = gatewaySessions;
        this.senderSequenceNumbers = senderSequenceNumbers;
        this.messageTimingHandler = messageTimingHandler;
    }

    FixReceiverEndPoint receiverEndPoint(TcpChannel channel, long connectionId, long sessionId, int sequenceIndex, int libraryId, Framer framer) {
        return new FixReceiverEndPoint(channel, this.configuration.receiverBufferSize(), this.inboundLibraryPublication, connectionId, sessionId, sequenceIndex, this.fixContexts, this.fixCounters.messagesRead(connectionId, channel.remoteAddr()), framer, this.errorHandler, libraryId, this.gatewaySessions, this.configuration.epochNanoClock(), framer.acceptorFixDictionaryLookup(), this.receiverFormatters, this.configuration.throttleWindowInMs(), this.configuration.throttleLimitOfMessages());
    }

    FixSenderEndPoint senderEndPoint(TcpChannel channel, long connectionId, int libraryId, BlockablePosition libraryBlockablePosition, Framer framer, FixReceiverEndPoint receiverEndPoint) {
        String remoteAddress = channel.remoteAddr();
        AtomicCounter bytesInBuffer = this.fixCounters.bytesInBuffer(connectionId, remoteAddress);
        return new FixSenderEndPoint(connectionId, libraryId, libraryBlockablePosition, this.inboundLibraryPublication.dataPublication(), this.replaySlowPeeker, channel, bytesInBuffer, this.fixCounters.invalidLibraryAttempts(connectionId, remoteAddress), this.errorHandler, framer, this.configuration.senderMaxBytesInBuffer(), this.configuration.slowConsumerTimeoutInMs(), System.currentTimeMillis(), this.senderSequenceNumbers.onNewSender(connectionId, bytesInBuffer), this.messageTimingHandler, this.configuration.maxConcurrentSessionReplays(), receiverEndPoint, this.senderFormatters);
    }

    void replaySlowPeeker(SlowPeeker replaySlowPeeker) {
        this.replaySlowPeeker = replaySlowPeeker;
    }
}

