/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import org.agrona.ErrorHandler;
import org.agrona.concurrent.EpochNanoClock;
import uk.co.real_logic.artio.FixGatewayException;
import uk.co.real_logic.artio.engine.framer.Continuation;

abstract class CancelOnDisconnectTimeoutOperation
implements Continuation {
    protected final long sessionId;
    private final long timeInNs;
    private final EpochNanoClock clock;
    private final ErrorHandler errorHandler;

    protected CancelOnDisconnectTimeoutOperation(long sessionId, long timeInNs, EpochNanoClock clock, ErrorHandler errorHandler) {
        this.sessionId = sessionId;
        this.timeInNs = timeInNs;
        this.clock = clock;
        this.errorHandler = errorHandler;
    }

    @Override
    public long attempt() {
        if (this.clock.nanoTime() > this.timeInNs) {
            try {
                this.onCancelOnDisconnectTimeout();
            }
            catch (Throwable t) {
                this.cancelOnDisconnectException(t);
            }
            return 1L;
        }
        return -2L;
    }

    protected abstract void onCancelOnDisconnectTimeout();

    private void cancelOnDisconnectException(Throwable t) {
        this.errorHandler.onError(new FixGatewayException("Error executing cancel on disconnect timeout handler", t));
    }

    long sessionId() {
        return this.sessionId;
    }
}

