/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import org.agrona.ErrorHandler;

class BlockablePosition {
    static final int DID_NOT_BLOCK = 0;
    private final ErrorHandler errorHandler;
    final int maxPayload;
    private long blockPosition;
    private long minPosition;
    private long maxPosition;

    BlockablePosition(int maxPayload, ErrorHandler errorHandler) {
        this.maxPayload = maxPayload;
        this.errorHandler = errorHandler;
    }

    void blockPosition(long blockPosition, boolean slow) {
        if (this.validPosition(blockPosition, slow) && this.blockPosition == 0L) {
            this.blockPosition = blockPosition;
        }
    }

    boolean validPosition(long position, boolean slow) {
        long maxPosition = this.maxPosition;
        if (position > maxPosition && !slow) {
            return false;
        }
        if (position < this.minPosition || position > maxPosition) {
            this.errorHandler.onError(new IllegalArgumentException(position + " position out of range: " + this.minPosition + "-" + maxPosition));
            return false;
        }
        if (0L != (position & 0x1FL)) {
            this.errorHandler.onError(new IllegalArgumentException(position + " position not aligned to FRAME_ALIGNMENT"));
            return false;
        }
        return true;
    }

    long blockPosition() {
        return this.blockPosition;
    }

    void startPeek(long minPosition, long maxPosition) {
        this.blockPosition = 0L;
        this.minPosition = minPosition;
        this.maxPosition = maxPosition;
    }
}

