/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.ExclusivePublication;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.messages.AllFixSessionsReplyEncoder;
import uk.co.real_logic.artio.messages.GatewayError;
import uk.co.real_logic.artio.messages.GenericAdminReplyEncoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.protocol.ClaimablePublication;

class AdminReplyPublication
extends ClaimablePublication {
    private static final int GENERIC_ADMIN_REPLY_LENGTH = 18 + GenericAdminReplyEncoder.messageHeaderLength();
    private final ExpandableArrayBuffer expandableArrayBuffer = new ExpandableArrayBuffer();
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final AllFixSessionsReplyEncoder allFixSessionsReply = new AllFixSessionsReplyEncoder();
    private final GenericAdminReplyEncoder genericAdminReply = new GenericAdminReplyEncoder();

    AdminReplyPublication(ExclusivePublication dataPublication, AtomicCounter fails, IdleStrategy idleStrategy, int maxClaimAttempts) {
        super(maxClaimAttempts, idleStrategy, fails, dataPublication);
    }

    AllFixSessionsReplyEncoder.SessionsEncoder startRequestAllFixSessions(long correlationId, int sessionsCount) {
        this.allFixSessionsReply.wrapAndApplyHeader(this.expandableArrayBuffer, 0, this.headerEncoder);
        return this.allFixSessionsReply.correlationId(correlationId).sessionsCount(sessionsCount);
    }

    long saveRequestAllFixSessions() {
        int length = this.allFixSessionsReply.limit();
        return this.dataPublication.offer(this.expandableArrayBuffer, 0, length);
    }

    long saveGenericAdminReply(long correlationId, GatewayError gatewayError, String message) {
        long position = this.claim(GENERIC_ADMIN_REPLY_LENGTH + message.length());
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.genericAdminReply.wrapAndApplyHeader(buffer, offset, this.header).correlationId(correlationId).errorType(gatewayError).message(message);
        this.bufferClaim.commit();
        return position;
    }
}

