/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.messages.AdminResetSequenceNumbersRequestDecoder;
import uk.co.real_logic.artio.messages.AllFixSessionsRequestDecoder;
import uk.co.real_logic.artio.messages.DisconnectSessionRequestDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;

class AdminEngineProtocolSubscription
implements FragmentHandler {
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final AllFixSessionsRequestDecoder allFixSessionsRequest = new AllFixSessionsRequestDecoder();
    private final DisconnectSessionRequestDecoder disconnectSessionRequest = new DisconnectSessionRequestDecoder();
    private final AdminResetSequenceNumbersRequestDecoder adminResetSequenceNumbersRequest = new AdminResetSequenceNumbersRequestDecoder();
    private final Framer handler;

    AdminEngineProtocolSubscription(Framer handler) {
        this.handler = handler;
    }

    @Override
    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        MessageHeaderDecoder messageHeader = this.messageHeader;
        messageHeader.wrap(buffer, offset);
        int blockLength = messageHeader.blockLength();
        int version = messageHeader.version();
        offset += messageHeader.encodedLength();
        switch (messageHeader.templateId()) {
            case 62: {
                this.onAllFixSessions(buffer, offset, blockLength, version);
                return;
            }
            case 64: {
                this.onDisconnectSession(buffer, offset, blockLength, version);
                return;
            }
            case 66: {
                this.onAdminResetSequenceNumbersRequest(buffer, offset, blockLength, version);
                return;
            }
        }
    }

    private void onAllFixSessions(DirectBuffer buffer, int offset, int blockLength, int version) {
        AllFixSessionsRequestDecoder allFixSessionsRequest = this.allFixSessionsRequest;
        allFixSessionsRequest.wrap(buffer, offset, blockLength, version);
        this.handler.onAllFixSessions(allFixSessionsRequest.correlationId());
    }

    private void onDisconnectSession(DirectBuffer buffer, int offset, int blockLength, int version) {
        DisconnectSessionRequestDecoder disconnectSessionRequest = this.disconnectSessionRequest;
        disconnectSessionRequest.wrap(buffer, offset, blockLength, version);
        this.handler.onDisconnectSession(disconnectSessionRequest.correlationId(), disconnectSessionRequest.sessionId());
    }

    private void onAdminResetSequenceNumbersRequest(DirectBuffer buffer, int offset, int blockLength, int version) {
        AdminResetSequenceNumbersRequestDecoder adminResetSequenceNumbersRequest = this.adminResetSequenceNumbersRequest;
        adminResetSequenceNumbersRequest.wrap(buffer, offset, blockLength, version);
        this.handler.onAdminResetSequenceNumbersRequest(adminResetSequenceNumbersRequest.correlationId(), adminResetSequenceNumbersRequest.sessionId());
    }
}

