/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.ValidationError;
import uk.co.real_logic.artio.dictionary.LongDictionary;
import uk.co.real_logic.artio.fields.AsciiFieldFlyweight;
import uk.co.real_logic.artio.otf.MessageControl;
import uk.co.real_logic.artio.otf.OtfMessageAcceptor;
import uk.co.real_logic.artio.otf.OtfParser;
import uk.co.real_logic.artio.util.AsciiBuffer;

public class SequenceNumberExtractor {
    public static final int NO_SEQUENCE_NUMBER = -1;
    private boolean isSequenceReset;
    private int sequenceNumber;
    private int newSequenceNumber;
    private long aeronSessionId;
    private long position = -1L;
    private final OtfMessageAcceptor extractor = new OtfMessageAcceptor(){

        @Override
        public MessageControl onNext() {
            return MessageControl.CONTINUE;
        }

        @Override
        public MessageControl onComplete() {
            return MessageControl.CONTINUE;
        }

        @Override
        public MessageControl onField(int tag, AsciiBuffer buffer, int offset, int length) {
            if (tag == 35) {
                SequenceNumberExtractor.this.isSequenceReset = length == 1 && buffer.getByte(offset) == 52;
            } else if (tag == 34) {
                SequenceNumberExtractor.this.sequenceNumber = buffer.getInt(offset, offset + length);
                if (!SequenceNumberExtractor.this.isSequenceReset) {
                    return MessageControl.STOP;
                }
            } else if (tag == 36 && SequenceNumberExtractor.this.isSequenceReset) {
                SequenceNumberExtractor.this.newSequenceNumber = buffer.getInt(offset, offset + length) - 1;
                return MessageControl.STOP;
            }
            return MessageControl.CONTINUE;
        }

        @Override
        public MessageControl onGroupHeader(int tag, int numInGroup) {
            return MessageControl.CONTINUE;
        }

        @Override
        public MessageControl onGroupBegin(int tag, int numInGroup, int index) {
            return MessageControl.CONTINUE;
        }

        @Override
        public MessageControl onGroupEnd(int tag, int numInGroup, int index) {
            return MessageControl.CONTINUE;
        }

        @Override
        public boolean onError(ValidationError error, long messageType, int tagNumber, AsciiFieldFlyweight value) {
            return false;
        }
    };
    private final OtfParser parser = new OtfParser(this.extractor, new LongDictionary());

    public int extract(DirectBuffer buffer, int offset, int length) {
        this.sequenceNumber = -1;
        this.newSequenceNumber = -1;
        this.isSequenceReset = false;
        this.parser.onMessage(buffer, offset, length);
        return this.pickSequenceNumber();
    }

    public int extractCached(DirectBuffer buffer, int offset, int length, long aeronSessId, long position) {
        if (aeronSessId == this.aeronSessionId && position == this.position) {
            return this.pickSequenceNumber();
        }
        this.aeronSessionId = aeronSessId;
        this.position = position;
        return this.extract(buffer, offset, length);
    }

    private int pickSequenceNumber() {
        return this.newSequenceNumber != -1 ? this.newSequenceNumber : this.sequenceNumber;
    }

    public int sequenceNumber() {
        return this.sequenceNumber;
    }

    public int newSequenceNumber() {
        return this.newSequenceNumber;
    }
}

