/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import java.util.function.Consumer;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import uk.co.real_logic.artio.engine.ReplayerCommand;

public class ReplayerCommandQueue {
    private static final int CAPACITY = 64;
    private final IdleStrategy framerIdleStrategy;
    private final OneToOneConcurrentArrayQueue<ReplayerCommand> queue = new OneToOneConcurrentArrayQueue(64);
    private final Consumer<ReplayerCommand> onReplayerCommand = this::onReplayerCommand;

    public ReplayerCommandQueue(IdleStrategy framerIdleStrategy) {
        this.framerIdleStrategy = framerIdleStrategy;
    }

    public void enqueue(ReplayerCommand command) {
        while (!this.offer(command)) {
            this.framerIdleStrategy.idle();
        }
        this.framerIdleStrategy.reset();
    }

    public boolean offer(ReplayerCommand command) {
        return this.queue.offer(command);
    }

    public int poll() {
        return this.queue.drain(this.onReplayerCommand, 64);
    }

    private void onReplayerCommand(ReplayerCommand command) {
        command.execute();
    }
}

