/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ControlledFragmentHandler;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.EpochNanoClock;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.dictionary.LongDictionary;
import uk.co.real_logic.artio.engine.PossDupFinder;
import uk.co.real_logic.artio.engine.framer.CatchupReplayer;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.otf.OtfParser;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class PossDupEnabler {
    private static final byte[] POSS_DUP_FIELD = "43=Y\u0001".getBytes(StandardCharsets.US_ASCII);
    public static final String ORIG_SENDING_TIME_PREFIX_AS_STR = "122=";
    private static final byte[] ORIG_SENDING_TIME_PREFIX = "122=".getBytes(StandardCharsets.US_ASCII);
    private static final int CHECKSUM_VALUE_LENGTH = 3;
    private static final int FRAGMENTED_MESSAGE_BUFFER_OFFSET = 0;
    private final ExpandableArrayBuffer fragmentedMessageBuffer = new ExpandableArrayBuffer();
    private final PossDupFinder possDupFinder = new PossDupFinder();
    private final OtfParser parser = new OtfParser(this.possDupFinder, new LongDictionary());
    private final MutableAsciiBuffer mutableAsciiFlyweight = new MutableAsciiBuffer();
    private final UtcTimestampEncoder utcTimestampEncoder;
    private final BufferClaim bufferClaim;
    private final Claimer claimer;
    private final PreCommit onPreCommit;
    private final Consumer<String> onIllegalStateFunc;
    private final ErrorHandler errorHandler;
    private final EpochNanoClock clock;
    private final int maxPayloadLength;
    private int fragmentedMessageLength;

    public PossDupEnabler(UtcTimestampEncoder utcTimestampEncoder, BufferClaim bufferClaim, Claimer claimer, PreCommit onPreCommit, Consumer<String> onIllegalStateFunc, ErrorHandler errorHandler, EpochNanoClock clock, int maxPayloadLength) {
        this.utcTimestampEncoder = utcTimestampEncoder;
        this.bufferClaim = bufferClaim;
        this.claimer = claimer;
        this.onPreCommit = onPreCommit;
        this.onIllegalStateFunc = onIllegalStateFunc;
        this.errorHandler = errorHandler;
        this.clock = clock;
        this.maxPayloadLength = maxPayloadLength;
    }

    public ControlledFragmentHandler.Action enablePossDupFlag(DirectBuffer srcBuffer, int messageOffset, int messageLength, int srcOffset, int srcLength, int metaDataAdjustment, long messageType) {
        boolean missingOrigSendingTime;
        this.parser.onMessage(srcBuffer, messageOffset, messageLength);
        boolean missingPossDup = this.possDupFinder.possDupOffset() == -1;
        boolean bl = missingOrigSendingTime = this.possDupFinder.origSendingTimeOffset() == -1;
        if (missingPossDup || missingOrigSendingTime) {
            int lengthOfOldBodyLength = this.possDupFinder.lengthOfBodyLength();
            int possDupLengthDelta = missingPossDup ? POSS_DUP_FIELD.length : 0;
            int lengthOfAddedFields = possDupLengthDelta + this.origSendingTimeLength();
            int newLength = srcLength + lengthOfAddedFields;
            int newBodyLength = this.possDupFinder.bodyLength() + lengthOfAddedFields;
            int lengthOfNewBodyLength = MutableAsciiBuffer.lengthInAscii(newBodyLength);
            int lengthDelta = Math.max(0, lengthOfNewBodyLength - lengthOfOldBodyLength);
            if (!this.claim(newLength += lengthDelta)) {
                return ControlledFragmentHandler.Action.ABORT;
            }
            try {
                if (this.addFields(srcBuffer, srcOffset, srcLength, messageOffset, messageLength, lengthDelta + lengthOfAddedFields, newBodyLength, newLength, metaDataAdjustment)) {
                    return this.commit(messageType, metaDataAdjustment);
                }
                this.onIllegalStateFunc.accept("[%s] Missing sending time field in resend request");
                this.abort();
            }
            catch (Exception ex) {
                this.abort();
                this.errorHandler.onError(ex);
            }
        } else {
            int possDupSrcOffset = this.possDupFinder.possDupOffset();
            return this.enablePossDupFlagSameLength(srcBuffer, messageOffset, messageLength, srcOffset, srcLength, possDupSrcOffset, messageType, metaDataAdjustment);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private int origSendingTimeLength() {
        return ORIG_SENDING_TIME_PREFIX.length + this.possDupFinder.sendingTimeLength() + 1;
    }

    private ControlledFragmentHandler.Action enablePossDupFlagSameLength(DirectBuffer srcBuffer, int messageOffset, int messageLength, int srcOffset, int srcLength, int possDupSrcOffset, long messageType, int metaDataAdjustment) {
        if (!this.claim(srcLength)) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        try {
            MutableDirectBuffer writeBuffer = this.writeBuffer();
            int writeOffset = this.writeOffset();
            writeBuffer.putBytes(writeOffset, srcBuffer, srcOffset, srcLength);
            this.mutableAsciiFlyweight.wrap(writeBuffer);
            int possDupClaimOffset = this.srcToClaim(possDupSrcOffset, srcOffset, writeOffset);
            this.mutableAsciiFlyweight.putCharAscii(possDupClaimOffset, 'Y');
            this.updateSendingTime(srcOffset);
            int messageClaimOffset = this.srcToClaim(messageOffset, srcOffset, writeOffset);
            int messageEndOffset = messageClaimOffset + messageLength;
            int beforeChecksum = this.srcToClaim(this.possDupFinder.checkSumOffset(), srcOffset, writeOffset) - 4;
            this.updateChecksum(messageClaimOffset, beforeChecksum, messageEndOffset);
            return this.commit(messageType, metaDataAdjustment);
        }
        catch (Exception ex) {
            this.abort();
            this.errorHandler.onError(ex);
            return ControlledFragmentHandler.Action.CONTINUE;
        }
    }

    private void abort() {
        if (this.isProcessingFragmentedMessage()) {
            this.fragmentedMessageLength = 0;
        } else {
            this.bufferClaim.abort();
        }
    }

    private boolean claim(int newLength) {
        if (newLength > this.maxPayloadLength) {
            this.fragmentedMessageBuffer.checkLimit(newLength);
            this.fragmentedMessageLength = newLength;
            return true;
        }
        int messageLength = newLength - GatewayPublication.FRAMED_MESSAGE_SIZE;
        return this.claimer.claim(newLength, messageLength);
    }

    private ControlledFragmentHandler.Action commit(long messageType, int metaDataAdjustment) {
        int adjustedFrameLength = CatchupReplayer.FRAME_LENGTH + metaDataAdjustment;
        if (this.isProcessingFragmentedMessage()) {
            int fragmentOffset = 0;
            this.onPreCommit.onPreCommit(this.fragmentedMessageBuffer, fragmentOffset);
            DebugLogger.logFixMessage(LogTag.FIX_MESSAGE, messageType, "Resending: ", this.fragmentedMessageBuffer, fragmentOffset + adjustedFrameLength, this.fragmentedMessageLength - adjustedFrameLength);
            while (this.fragmentedMessageLength > 0) {
                int messageLength;
                int fragmentLength = Math.min(this.maxPayloadLength, this.fragmentedMessageLength);
                if (this.claimer.claim(fragmentLength, messageLength = fragmentLength - GatewayPublication.FRAMED_MESSAGE_SIZE)) {
                    if (fragmentOffset == 0) {
                        this.bufferClaim.flags((byte)-128);
                    } else if (this.fragmentedMessageLength == fragmentLength) {
                        this.bufferClaim.flags((byte)64);
                    } else {
                        this.bufferClaim.flags((byte)0);
                    }
                    MutableDirectBuffer destBuffer = this.bufferClaim.buffer();
                    int destOffset = this.bufferClaim.offset();
                    destBuffer.putBytes(destOffset, this.fragmentedMessageBuffer, fragmentOffset, fragmentLength);
                    this.bufferClaim.commit();
                    fragmentOffset += fragmentLength;
                    this.fragmentedMessageLength -= fragmentLength;
                    continue;
                }
                this.fragmentedMessageLength = 0;
                return ControlledFragmentHandler.Action.ABORT;
            }
        } else {
            MutableDirectBuffer buffer = this.bufferClaim.buffer();
            int offset = this.bufferClaim.offset();
            DebugLogger.logFixMessage(LogTag.FIX_MESSAGE, messageType, "Resending: ", buffer, offset + adjustedFrameLength, this.bufferClaim.length() - adjustedFrameLength);
            this.onPreCommit.onPreCommit(buffer, offset);
            this.bufferClaim.commit();
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private MutableDirectBuffer writeBuffer() {
        return this.isProcessingFragmentedMessage() ? this.fragmentedMessageBuffer : this.bufferClaim.buffer();
    }

    private int writeOffset() {
        return this.isProcessingFragmentedMessage() ? 0 : this.bufferClaim.offset();
    }

    private boolean addFields(DirectBuffer srcBuffer, int srcOffset, int srcLength, int messageOffset, int messageLength, int totalLengthDelta, int newBodyLength, int newLength, int metaDataAdjustment) {
        int origSendingTimePrefixClaimOffset;
        MutableDirectBuffer writeBuffer = this.writeBuffer();
        int writeOffset = this.writeOffset();
        this.mutableAsciiFlyweight.wrap(writeBuffer);
        int sendingTimeSrcEnd = this.possDupFinder.sendingTimeEnd();
        if (sendingTimeSrcEnd == -1) {
            return false;
        }
        int lengthToSendingTimeEnd = sendingTimeSrcEnd - srcOffset;
        writeBuffer.putBytes(writeOffset, srcBuffer, srcOffset, lengthToSendingTimeEnd);
        int possDupSrcOffset = this.possDupFinder.possDupOffset();
        if (possDupSrcOffset == -1) {
            int possDupClaimOffset = writeOffset + lengthToSendingTimeEnd;
            writeBuffer.putBytes(possDupClaimOffset, POSS_DUP_FIELD);
            origSendingTimePrefixClaimOffset = possDupClaimOffset + POSS_DUP_FIELD.length;
        } else {
            int possDupValueClaimOffset = this.srcToClaim(possDupSrcOffset, srcOffset, writeOffset);
            this.mutableAsciiFlyweight.putCharAscii(possDupValueClaimOffset, 'Y');
            origSendingTimePrefixClaimOffset = writeOffset + lengthToSendingTimeEnd;
        }
        writeBuffer.putBytes(origSendingTimePrefixClaimOffset, ORIG_SENDING_TIME_PREFIX);
        int origSendingTimeValueClaimOffset = origSendingTimePrefixClaimOffset + ORIG_SENDING_TIME_PREFIX.length;
        int sendingTimeOffset = this.possDupFinder.sendingTimeOffset();
        int sendingTimeLength = this.possDupFinder.sendingTimeLength();
        writeBuffer.putBytes(origSendingTimeValueClaimOffset, srcBuffer, sendingTimeOffset, sendingTimeLength);
        int separatorClaimOffset = origSendingTimeValueClaimOffset + sendingTimeLength;
        writeBuffer.putByte(separatorClaimOffset, (byte)1);
        int remainingClaimOffset = separatorClaimOffset + 1;
        int remainingLength = srcLength - lengthToSendingTimeEnd;
        writeBuffer.putBytes(remainingClaimOffset, srcBuffer, sendingTimeSrcEnd, remainingLength);
        this.updateSendingTime(srcOffset);
        this.updateFrameBodyLength(messageLength, writeBuffer, writeOffset, totalLengthDelta, metaDataAdjustment);
        int messageClaimOffset = this.srcToClaim(messageOffset, srcOffset, writeOffset);
        this.updateBodyLengthAndChecksum(srcOffset, messageClaimOffset, writeOffset, newBodyLength, writeOffset + newLength);
        return true;
    }

    private void updateSendingTime(int srcOffset) {
        MutableDirectBuffer claimBuffer = this.writeBuffer();
        int claimOffset = this.writeOffset();
        int sendingTimeOffset = this.possDupFinder.sendingTimeOffset();
        int sendingTimeLength = this.possDupFinder.sendingTimeLength();
        int sendingTimeClaimOffset = this.srcToClaim(sendingTimeOffset, srcOffset, claimOffset);
        this.utcTimestampEncoder.encodeFrom(this.clock.nanoTime(), TimeUnit.NANOSECONDS);
        claimBuffer.putBytes(sendingTimeClaimOffset, this.utcTimestampEncoder.buffer(), 0, sendingTimeLength);
    }

    private void updateFrameBodyLength(int messageLength, MutableDirectBuffer claimBuffer, int claimOffset, int lengthDelta, int metaDataAdjustment) {
        int frameBodyLengthOffset = claimOffset + 8 + 57 + metaDataAdjustment;
        int frameBodyLength = messageLength + lengthDelta;
        claimBuffer.putInt(frameBodyLengthOffset, frameBodyLength, ByteOrder.LITTLE_ENDIAN);
    }

    private void updateBodyLengthAndChecksum(int srcOffset, int messageClaimOffset, int claimOffset, int newBodyLength, int messageEndOffset) {
        int bodyLengthClaimOffset = this.srcToClaim(this.possDupFinder.bodyLengthOffset(), srcOffset, claimOffset);
        int lengthOfOldBodyLength = this.possDupFinder.lengthOfBodyLength();
        int lengthOfNewBodyLength = MutableAsciiBuffer.lengthInAscii(newBodyLength);
        int lengthChange = lengthOfNewBodyLength - lengthOfOldBodyLength;
        if (lengthChange > 0) {
            int index = bodyLengthClaimOffset + lengthChange;
            this.mutableAsciiFlyweight.putBytes(index, this.mutableAsciiFlyweight, bodyLengthClaimOffset, messageEndOffset - index);
        }
        int lengthOfUpdatedBodyLengthField = Math.max(lengthOfOldBodyLength, lengthOfNewBodyLength);
        this.mutableAsciiFlyweight.putNaturalPaddedIntAscii(bodyLengthClaimOffset, lengthOfUpdatedBodyLengthField, newBodyLength);
        int beforeChecksum = bodyLengthClaimOffset + lengthOfUpdatedBodyLengthField + newBodyLength;
        this.updateChecksum(messageClaimOffset, beforeChecksum, messageEndOffset);
    }

    private void updateChecksum(int messageClaimOffset, int beforeChecksum, int messageEndOffset) {
        boolean lengthOfSeparator = true;
        int checksumEnd = beforeChecksum + 1;
        int checksum = this.mutableAsciiFlyweight.computeChecksum(messageClaimOffset, checksumEnd);
        int checksumValueOffset = messageEndOffset - 4;
        this.mutableAsciiFlyweight.putNaturalPaddedIntAscii(checksumValueOffset, 3, checksum);
        this.mutableAsciiFlyweight.putSeparator(checksumValueOffset + 3);
    }

    private int srcToClaim(int srcIndexedOffset, int srcOffset, int claimOffset) {
        return srcIndexedOffset - srcOffset + claimOffset;
    }

    private boolean isProcessingFragmentedMessage() {
        return this.fragmentedMessageLength > 0;
    }

    public static interface PreCommit {
        public void onPreCommit(MutableDirectBuffer var1, int var2);
    }

    public static interface Claimer {
        public boolean claim(int var1, int var2);
    }
}

