/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import io.aeron.ExclusivePublication;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import java.io.File;
import java.util.List;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.status.ReadablePosition;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.GatewayProcess;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.StreamInformation;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.DuplicateEngineChecker;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.EngineContext;
import uk.co.real_logic.artio.engine.EngineScheduler;
import uk.co.real_logic.artio.engine.FixPSessionInfo;
import uk.co.real_logic.artio.engine.RecordingCoordinator;
import uk.co.real_logic.artio.engine.ResetArchiveState;
import uk.co.real_logic.artio.engine.SessionInfo;
import uk.co.real_logic.artio.engine.framer.FramerContext;
import uk.co.real_logic.artio.engine.framer.LibraryInfo;
import uk.co.real_logic.artio.timing.EngineTimers;

public final class FixEngine
extends GatewayProcess {
    private static final Object CLOSE_MUTEX = new Object();
    public static final int ENGINE_LIBRARY_ID = 0;
    private final DuplicateEngineChecker duplicateEngineChecker;
    private final EngineTimers timers;
    private final EngineConfiguration configuration;
    private final RecordingCoordinator recordingCoordinator;
    private final EngineScheduler scheduler;
    private FramerContext framerContext;
    private EngineContext engineContext;
    private volatile boolean startingClose = false;
    private volatile boolean isClosed = false;
    private final Object resetStateLock = new Object();
    private volatile boolean stateHasBeenReset = false;
    private boolean launched = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FixEngine launch(EngineConfiguration configuration) {
        Object object = CLOSE_MUTEX;
        synchronized (object) {
            configuration.conclude();
            return new FixEngine(configuration).launch();
        }
    }

    public Reply<List<LibraryInfo>> libraries() {
        return this.framerContext.libraries();
    }

    public Reply<?> unbind() {
        return this.unbind(false);
    }

    public Reply<?> unbind(boolean endOfDay) {
        return this.framerContext.unbind(endOfDay);
    }

    public Reply<?> bind() {
        return this.framerContext.bind();
    }

    @Deprecated
    public Reply<?> resetSessionIds(File backupLocation) {
        return this.framerContext.resetSessionIds(backupLocation);
    }

    public Reply<?> resetSequenceNumber(long sessionId) {
        return this.framerContext.resetSequenceNumber(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetState(File backupLocation) {
        if (!this.isClosed()) {
            throw new IllegalStateException("Engine should be closed before the state is reset");
        }
        Object object = this.resetStateLock;
        synchronized (object) {
            if (!this.stateHasBeenReset) {
                ResetArchiveState resetArchiveState = new ResetArchiveState(this.configuration, backupLocation, this.recordingCoordinator);
                resetArchiveState.resetState();
                this.stateHasBeenReset = true;
            }
        }
    }

    public Reply<ReadablePosition> libraryIndexedPosition(int libraryId) {
        return this.framerContext.libraryIndexedPosition(libraryId);
    }

    public List<SessionInfo> allSessions() {
        return this.framerContext.allSessions();
    }

    public List<FixPSessionInfo> allFixPSessions() {
        return this.framerContext.allFixPSessions();
    }

    public Reply<Long> lookupSessionId(String localCompId, String remoteCompId, String localSubId, String remoteSubId, String localLocationId, String remoteLocationId) {
        return this.framerContext.lookupSessionId(localCompId, remoteCompId, localSubId, remoteSubId, localLocationId, remoteLocationId);
    }

    private FixEngine(EngineConfiguration configuration) {
        try {
            this.configuration = configuration;
            this.duplicateEngineChecker = new DuplicateEngineChecker(configuration.duplicateEngineTimeoutInMs(), configuration.logFileDir(), configuration.errorIfDuplicateEngineDetected());
            this.duplicateEngineChecker.check();
            this.scheduler = configuration.scheduler();
            this.scheduler.configure(configuration.aeronContext());
            this.init(configuration, 0);
            this.timers = new EngineTimers(configuration.epochNanoClock(), this.fixCounters.negativeTimestamps());
            AeronArchive.Context archiveContext = configuration.aeronArchiveContext();
            AeronArchive aeronArchive = configuration.logAnyMessages() ? AeronArchive.connect(archiveContext.aeron(this.aeron)) : null;
            this.recordingCoordinator = new RecordingCoordinator(this.aeron, aeronArchive, configuration, configuration.archiverIdleStrategy(), this.errorHandler);
            ExclusivePublication replayPublication = this.replayPublication();
            this.engineContext = new EngineContext(configuration, this.errorHandler, replayPublication, this.fixCounters, this.aeron, aeronArchive, this.recordingCoordinator);
            this.engineContext.catchupIndices();
            this.initFramer(configuration, this.fixCounters, replayPublication.sessionId());
            this.initMonitoringAgent(this.timers.all(), configuration, aeronArchive, this.duplicateEngineChecker);
        }
        catch (Exception e) {
            if (this.engineContext != null) {
                this.engineContext.completeDuringStartup();
            }
            Exceptions.suppressingClose(this, e);
            throw e;
        }
    }

    private ExclusivePublication replayPublication() {
        ExclusivePublication publication = this.aeron.addExclusivePublication("aeron:ipc", this.configuration.outboundReplayStream());
        StreamInformation.print("replayPublication", publication, this.configuration);
        return publication;
    }

    private void initFramer(EngineConfiguration configuration, FixCounters fixCounters, int replaySessionId) {
        this.framerContext = new FramerContext(configuration, fixCounters, this.engineContext, this.errorHandler, this.replayImage("replay", replaySessionId), this.replayImage("slow-replay", replaySessionId), this.timers, this.aeron.conductorAgentInvoker(), this.recordingCoordinator, this.aeron);
        this.engineContext.framerContext(this.framerContext);
    }

    private Image replayImage(String name, int replaySessionId) {
        Subscription subscription = this.aeron.addSubscription("aeron:ipc", this.configuration.outboundReplayStream());
        StreamInformation.print(name, subscription, (CommonConfiguration)this.configuration);
        Image image;
        while ((image = subscription.imageBySessionId(replaySessionId)) == null) {
            this.invokeAeronConductor();
            Thread.yield();
        }
        return image;
    }

    private void invokeAeronConductor() {
        AgentInvoker invoker = this.aeron.conductorAgentInvoker();
        if (invoker != null) {
            invoker.invoke();
        }
    }

    private FixEngine launch() {
        this.scheduler.launch(this.configuration, this.errorHandler, this.framerContext.framer(), this.engineContext.indexingAgent(), this.monitoringAgent, this.conductorAgent(), this.recordingCoordinator);
        this.launched = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = CLOSE_MUTEX;
        synchronized (object) {
            if (!this.isClosed) {
                this.startingClose = true;
                DebugLogger.log(LogTag.CLOSE, "Shutdown initiated through FixEngine.close()");
                if (this.launched) {
                    this.framerContext.startClose();
                }
                try {
                    AutoCloseable[] autoCloseableArray = new AutoCloseable[5];
                    autoCloseableArray[0] = this.scheduler;
                    autoCloseableArray[1] = this.engineContext;
                    autoCloseableArray[2] = this.configuration;
                    autoCloseableArray[3] = () -> super.close();
                    autoCloseableArray[4] = this.duplicateEngineChecker::finalClose;
                    Exceptions.closeAll(autoCloseableArray);
                }
                finally {
                    this.isClosed = true;
                }
            }
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Reply<Long2LongHashMap> pruneArchive(Long2LongHashMap recordingIdToMinimumPrunePositions) {
        if (this.startingClose) {
            return this.engineContext.pruneArchive(new IllegalStateException("Unable to prune archive during shutdown."));
        }
        if (this.isClosed) {
            return this.engineContext.pruneArchive(new IllegalStateException("Unable to prune archive when closed."));
        }
        return this.engineContext.pruneArchive(recordingIdToMinimumPrunePositions);
    }

    public EngineConfiguration configuration() {
        return this.configuration;
    }

    @Override
    protected boolean shouldRethrowExceptionInErrorHandler() {
        return false;
    }
}

