/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.AtomicBuffer;
import uk.co.real_logic.artio.engine.ByteBufferUtil;
import uk.co.real_logic.artio.engine.SectorFramer;

public class ChecksumFramer
extends SectorFramer {
    private final CRC32 crc32 = new CRC32();
    private final AtomicBuffer buffer;
    private final ChecksumConsumer saveChecksumFunc;
    private final ErrorHandler errorHandler;
    private final int errorReportingOffset;
    private final ChecksumConsumer validateChecksumFunc;
    private final String fileName;
    private final boolean indexChecksumEnabled;

    public ChecksumFramer(AtomicBuffer buffer, int capacity, ErrorHandler errorHandler, int errorReportingOffset, String fileName, boolean indexChecksumEnabled) {
        super(capacity);
        this.buffer = buffer;
        this.saveChecksumFunc = buffer::putInt;
        this.errorHandler = errorHandler;
        this.errorReportingOffset = errorReportingOffset;
        this.fileName = fileName;
        this.indexChecksumEnabled = indexChecksumEnabled;
        this.validateChecksumFunc = this::validateChecksum;
    }

    public void validateCheckSums() {
        if (this.indexChecksumEnabled) {
            this.withChecksums(this.validateChecksumFunc);
        }
    }

    public void updateChecksums() {
        if (this.indexChecksumEnabled) {
            this.withChecksums(this.saveChecksumFunc);
        }
    }

    private void validateChecksum(int checksumOffset, int calculatedChecksum) {
        int savedChecksum = this.buffer.getInt(checksumOffset);
        int start = this.errorReportingOffset + checksumOffset - 4092;
        int end = this.errorReportingOffset + checksumOffset + 4;
        ChecksumFramer.validateCheckSum(this.fileName, start, end, savedChecksum, calculatedChecksum, this.errorHandler);
    }

    private void withChecksums(ChecksumConsumer consumer) {
        byte[] inMemoryBytes = this.buffer.byteArray();
        ByteBuffer inMemoryByteBuffer = this.buffer.byteBuffer();
        int wrapAdjustment = this.buffer.wrapAdjustment();
        int capacity = this.capacity;
        for (int sectorEnd = 4096; sectorEnd <= capacity; sectorEnd += 4096) {
            int sectorStart = sectorEnd - 4096 + wrapAdjustment;
            int checksumOffset = sectorEnd - 4;
            this.crc32.reset();
            if (inMemoryBytes != null) {
                this.crc32.update(inMemoryBytes, sectorStart, 4092);
            } else {
                ByteBufferUtil.limit(inMemoryByteBuffer, sectorStart + 4092);
                ByteBufferUtil.position(inMemoryByteBuffer, sectorStart);
                this.crc32.update(inMemoryByteBuffer);
            }
            int sectorChecksum = (int)this.crc32.getValue();
            consumer.accept(checksumOffset, sectorChecksum);
        }
        if (inMemoryByteBuffer != null) {
            inMemoryByteBuffer.clear();
        }
    }

    private static interface ChecksumConsumer {
        public void accept(int var1, int var2);
    }
}

