/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.binary_entrypoint;

import b3.entrypoint.fixp.sbe.BusinessMessageRejectEncoder;
import b3.entrypoint.fixp.sbe.CancelOnDisconnectType;
import b3.entrypoint.fixp.sbe.EstablishAckEncoder;
import b3.entrypoint.fixp.sbe.EstablishEncoder;
import b3.entrypoint.fixp.sbe.EstablishRejectCode;
import b3.entrypoint.fixp.sbe.EstablishRejectEncoder;
import b3.entrypoint.fixp.sbe.FinishedReceivingEncoder;
import b3.entrypoint.fixp.sbe.FinishedSendingEncoder;
import b3.entrypoint.fixp.sbe.MessageHeaderEncoder;
import b3.entrypoint.fixp.sbe.MessageType;
import b3.entrypoint.fixp.sbe.NegotiateEncoder;
import b3.entrypoint.fixp.sbe.NegotiateRejectEncoder;
import b3.entrypoint.fixp.sbe.NegotiateResponseEncoder;
import b3.entrypoint.fixp.sbe.NegotiationRejectCode;
import b3.entrypoint.fixp.sbe.NotAppliedEncoder;
import b3.entrypoint.fixp.sbe.RetransmissionEncoder;
import b3.entrypoint.fixp.sbe.RetransmitRejectCode;
import b3.entrypoint.fixp.sbe.RetransmitRejectEncoder;
import b3.entrypoint.fixp.sbe.SequenceEncoder;
import b3.entrypoint.fixp.sbe.TerminateEncoder;
import b3.entrypoint.fixp.sbe.TerminationCode;
import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.BufferClaim;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointContext;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointProtocol;
import uk.co.real_logic.artio.fixp.AbstractFixPProxy;
import uk.co.real_logic.artio.fixp.FixPContext;
import uk.co.real_logic.artio.fixp.FixPFirstMessageResponse;
import uk.co.real_logic.artio.fixp.FixPMessageDissector;
import uk.co.real_logic.artio.fixp.SimpleOpenFramingHeader;

public class BinaryEntryPointProxy
extends AbstractFixPProxy {
    public static final int BINARY_ENTRYPOINT_HEADER_LENGTH = 12;
    private static final int BINARY_ENTRYPOINT_MESSAGE_HEADER = 44;
    private static final int RETRANSMISSION_LEN = 32;
    private static final int SEQUENCE_LEN = 16;
    private static final int RETRANSMISSION_AND_SEQUENCE_LEN = 80;
    private static final int NEGOTIATE_REJECT_LENGTH = 37;
    private static final int ESTABLISH_REJECT_LENGTH = 33;
    private static final int NEGOTIATE_LENGTH = 50;
    private static final int ESTABLISH_LENGTH = 53;
    private static final int BUSINESS_REJECT_LENGTH = 29;
    private final MessageHeaderEncoder beMessageHeader = new MessageHeaderEncoder();
    private final NegotiateEncoder negotiate = new NegotiateEncoder();
    private final NegotiateResponseEncoder negotiateResponse = new NegotiateResponseEncoder();
    private final NegotiateRejectEncoder negotiateReject = new NegotiateRejectEncoder();
    private final EstablishEncoder establish = new EstablishEncoder();
    private final EstablishAckEncoder establishAck = new EstablishAckEncoder();
    private final EstablishRejectEncoder establishReject = new EstablishRejectEncoder();
    private final SequenceEncoder sequence = new SequenceEncoder();
    private final TerminateEncoder terminate = new TerminateEncoder();
    private final FinishedReceivingEncoder finishedReceiving = new FinishedReceivingEncoder();
    private final FinishedSendingEncoder finishedSending = new FinishedSendingEncoder();
    private final NotAppliedEncoder notApplied = new NotAppliedEncoder();
    private final RetransmissionEncoder retransmission = new RetransmissionEncoder();
    private final RetransmitRejectEncoder retransmitReject = new RetransmitRejectEncoder();
    private final BusinessMessageRejectEncoder businessMessageReject = new BusinessMessageRejectEncoder();
    private final Consumer<StringBuilder> negotiateResponseAppendTo = this.negotiateResponse::appendTo;
    private final Consumer<StringBuilder> negotiateRejectAppendTo = this.negotiateReject::appendTo;
    private final Consumer<StringBuilder> establishAckAppendTo = this.establishAck::appendTo;
    private final Consumer<StringBuilder> establishRejectAppendTo = this.establishReject::appendTo;
    private final Consumer<StringBuilder> terminateAppendTo = this.terminate::appendTo;
    private final Consumer<StringBuilder> sequenceAppendTo = this.sequence::appendTo;
    private final Consumer<StringBuilder> finishedReceivingAppendTo = this.finishedReceiving::appendTo;
    private final Consumer<StringBuilder> finishedSendingAppendTo = this.finishedSending::appendTo;
    private final Consumer<StringBuilder> notAppliedAppendTo = this.notApplied::appendTo;
    private final Consumer<StringBuilder> retransmissionAppendTo = this.retransmission::appendTo;
    private final Consumer<StringBuilder> retransmitRejectAppendTo = this.retransmitReject::appendTo;
    private final Consumer<StringBuilder> businessMessageRejectAppendTo = this.businessMessageReject::appendTo;
    private final UnsafeBuffer buffer = new UnsafeBuffer();
    private final EpochNanoClock clock;

    public BinaryEntryPointProxy(BinaryEntryPointProtocol protocol, FixPMessageDissector dissector, long connectionId, ExclusivePublication publication, EpochNanoClock clock) {
        super(protocol, dissector, connectionId, publication);
        this.clock = clock;
    }

    @Override
    public long sendSequence(long sessionId, long nextSentSeqNo) {
        SequenceEncoder sequence = this.sequence;
        long position = this.claimMessage(4, sequence, this.clock.nanoTime());
        if (position < 0L) {
            return position;
        }
        sequence.nextSeqNo(nextSentSeqNo);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "< ", this.sequenceAppendTo);
        this.commit();
        return position;
    }

    public long sendNegotiateResponse(long sessionID, long sessionVerID, long requestTimestamp, long enteringFirm) {
        NegotiateResponseEncoder negotiateResponse = this.negotiateResponse;
        long position = this.claimMessage(24, negotiateResponse, requestTimestamp);
        if (position < 0L) {
            return position;
        }
        negotiateResponse.sessionID(sessionID).sessionVerID(sessionVerID).requestTimestamp().time(requestTimestamp);
        negotiateResponse.enteringFirm(enteringFirm);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "< ", this.negotiateResponseAppendTo);
        this.commit();
        return position;
    }

    public long sendEstablishAck(long sessionID, long sessionVerID, long requestTimestamp, long keepAliveInterval, long nextSeqNo, long lastIncomingSeqNo) {
        EstablishAckEncoder establishAck = this.establishAck;
        long position = this.claimMessage(36, establishAck, requestTimestamp);
        if (position < 0L) {
            return position;
        }
        establishAck.sessionID(sessionID).sessionVerID(sessionVerID).requestTimestamp().time(requestTimestamp);
        establishAck.keepAliveInterval().time(keepAliveInterval);
        establishAck.nextSeqNo(nextSeqNo).lastIncomingSeqNo(lastIncomingSeqNo);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "< ", this.establishAckAppendTo);
        this.commit();
        return position;
    }

    public long sendEstablishReject(long sessionID, long sessionVerID, long requestTimestamp, EstablishRejectCode establishmentRejectCode) {
        EstablishRejectEncoder establishReject = this.establishReject;
        long position = this.claimMessage(21, establishReject, requestTimestamp);
        if (position < 0L) {
            return position;
        }
        establishReject.sessionID(sessionID).sessionVerID(sessionVerID).requestTimestamp().time(requestTimestamp);
        establishReject.establishmentRejectCode(establishmentRejectCode);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "< ", this.establishRejectAppendTo);
        this.commit();
        return position;
    }

    public long sendTerminate(long sessionId, long sessionVerId, TerminationCode terminationCode, long timestampInNs) {
        TerminateEncoder terminate = this.terminate;
        long position = this.claimMessage(13, terminate, timestampInNs);
        if (position < 0L) {
            return position;
        }
        terminate.sessionID(sessionId).sessionVerID(sessionVerId).terminationCode(terminationCode);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "< ", this.terminateAppendTo);
        this.commit();
        return position;
    }

    public long sendFinishedReceiving(long sessionID, long sessionVerId, long timestampInNs) {
        FinishedReceivingEncoder finishedReceiving = this.finishedReceiving;
        long position = this.claimMessage(12, finishedReceiving, timestampInNs);
        if (position < 0L) {
            return position;
        }
        finishedReceiving.sessionID(sessionID).sessionVerID(sessionVerId);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "< ", this.finishedReceivingAppendTo);
        this.commit();
        return position;
    }

    public long sendFinishedSending(long sessionId, long sessionVerId, long lastSeqNo, long timestampInNs) {
        FinishedSendingEncoder finishedSending = this.finishedSending;
        long position = this.claimMessage(16, finishedSending, timestampInNs);
        if (position < 0L) {
            return position;
        }
        finishedSending.sessionID(sessionId).sessionVerID(sessionVerId).lastSeqNo(lastSeqNo);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "< ", this.finishedSendingAppendTo);
        this.commit();
        return position;
    }

    public long sendNotApplied(long fromSeqNo, long count, long timestampInNs) {
        NotAppliedEncoder notApplied = this.notApplied;
        long position = this.claimMessage(8, notApplied, timestampInNs);
        if (position < 0L) {
            return position;
        }
        notApplied.fromSeqNo(fromSeqNo).count(count);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "< ", this.notAppliedAppendTo);
        this.commit();
        return position;
    }

    public long sendRetransmissionWithSequence(long nextSeqNo, long count, long internalTimestampInNs, long requestTimestampInNs, long nextSentSeqNo) {
        RetransmissionEncoder retransmission = this.retransmission;
        SequenceEncoder sequence = this.sequence;
        BufferClaim bufferClaim = this.bufferClaim;
        long position = this.publication.tryClaim(80, bufferClaim);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = bufferClaim.buffer();
        int offset = bufferClaim.offset();
        this.fixPMessage.wrapAndApplyHeader(buffer, offset, this.messageHeader).connection(this.connectionId).sessionId(this.sessionId).enqueueTime(internalTimestampInNs);
        SimpleOpenFramingHeader.writeSofh(buffer, offset += 32, 32, (short)-5296);
        offset += 4;
        offset = this.applyHeader(retransmission, buffer, offset);
        retransmission.wrap(buffer, offset).sessionID(this.sessionId).requestTimestamp().time(requestTimestampInNs);
        retransmission.nextSeqNo(nextSeqNo).count(count);
        SimpleOpenFramingHeader.writeSofh(buffer, offset += 20, 16, (short)-5296);
        offset += 4;
        offset = this.applyHeader(sequence, buffer, offset);
        sequence.wrap(buffer, offset).nextSeqNo(nextSentSeqNo);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "< ", this.retransmissionAppendTo);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "< ", this.sequenceAppendTo);
        this.commit();
        return position;
    }

    public long sendRetransmitReject(RetransmitRejectCode retransmitRejectCode, long timestampInNs, long requestTimestampInNs) {
        RetransmitRejectEncoder retransmitReject = this.retransmitReject;
        long position = this.claimMessage(13, retransmitReject, timestampInNs);
        if (position < 0L) {
            return position;
        }
        retransmitReject.sessionID(this.sessionId).requestTimestamp().time(requestTimestampInNs);
        retransmitReject.retransmitRejectCode(retransmitRejectCode);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "< ", this.retransmitRejectAppendTo);
        this.commit();
        return position;
    }

    public long sendBusinessReject(long refSeqNum, MessageType refMsgType, long rejectRefID, long businessRejectReason) {
        BusinessMessageRejectEncoder businessMessageReject = this.businessMessageReject;
        long position = this.claimMessage(17, businessMessageReject, this.clock.nanoTime());
        if (position < 0L) {
            return position;
        }
        businessMessageReject.refSeqNum(refSeqNum).refMsgType(refMsgType).businessRejectRefID(rejectRefID).businessRejectReason(businessRejectReason);
        DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "< ", this.businessMessageRejectAppendTo);
        this.commit();
        return position;
    }

    @Override
    public long claimMessage(int messageLength, MessageEncoderFlyweight message, long timestampInNs) {
        return this.claimMessage(messageLength, message, timestampInNs, 44, 12, (short)-5296);
    }

    @Override
    protected int applyHeader(MessageEncoderFlyweight message, MutableDirectBuffer buffer, int offset) {
        this.beMessageHeader.wrap(buffer, offset).blockLength(message.sbeBlockLength()).templateId(message.sbeTemplateId()).schemaId(message.sbeSchemaId()).version(message.sbeSchemaVersion());
        return offset + this.beMessageHeader.encodedLength();
    }

    @Override
    public ByteBuffer encodeReject(FixPContext fixPContext, FixPFirstMessageResponse rejectReason) {
        ByteBuffer byteBuffer;
        EstablishRejectCode establishRejectCode;
        NegotiationRejectCode negotiationRejectCode;
        boolean isNegotiate;
        BinaryEntryPointContext identification = (BinaryEntryPointContext)fixPContext;
        switch (rejectReason) {
            case CREDENTIALS: {
                isNegotiate = identification.fromNegotiate();
                negotiationRejectCode = NegotiationRejectCode.CREDENTIALS;
                establishRejectCode = EstablishRejectCode.CREDENTIALS;
                break;
            }
            case NEGOTIATE_DUPLICATE_ID_BAD_VER: 
            case NEGOTIATE_DUPLICATE_ID: {
                isNegotiate = true;
                negotiationRejectCode = NegotiationRejectCode.DUPLICATE_ID;
                establishRejectCode = null;
                break;
            }
            case NEGOTIATE_UNSPECIFIED: {
                isNegotiate = true;
                negotiationRejectCode = NegotiationRejectCode.UNSPECIFIED;
                establishRejectCode = null;
                break;
            }
            case ESTABLISH_UNNEGOTIATED: {
                isNegotiate = false;
                negotiationRejectCode = null;
                establishRejectCode = EstablishRejectCode.UNNEGOTIATED;
                break;
            }
            case VER_ID_ENDED: {
                isNegotiate = identification.fromNegotiate();
                negotiationRejectCode = NegotiationRejectCode.DUPLICATE_ID;
                establishRejectCode = EstablishRejectCode.UNNEGOTIATED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid reject reason: " + (Object)((Object)rejectReason));
            }
        }
        if (isNegotiate) {
            byteBuffer = ByteBuffer.allocate(37);
            this.buffer.wrap(byteBuffer);
            SimpleOpenFramingHeader.writeSofh(this.buffer, 0, 37, (short)-5296);
            this.negotiateReject.wrapAndApplyHeader(this.buffer, 4, this.beMessageHeader).sessionID(identification.sessionID()).sessionVerID(identification.sessionVerID()).requestTimestamp().time(identification.requestTimestampInNs());
            this.negotiateReject.enteringFirm(identification.enteringFirm()).negotiationRejectCode(negotiationRejectCode);
            DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "< ", this.negotiateRejectAppendTo);
        } else {
            byteBuffer = ByteBuffer.allocate(33);
            this.buffer.wrap(byteBuffer);
            SimpleOpenFramingHeader.writeSofh(this.buffer, 0, 33, (short)-5296);
            this.establishReject.wrapAndApplyHeader(this.buffer, 4, this.beMessageHeader).sessionID(identification.sessionID()).sessionVerID(identification.sessionVerID()).requestTimestamp().time(identification.requestTimestampInNs());
            this.establishReject.establishmentRejectCode(establishRejectCode);
            DebugLogger.logSbeDecoder(LogTag.FIXP_SESSION, "< ", this.establishRejectAppendTo);
        }
        return byteBuffer;
    }

    @Override
    public byte[] encodeFirstMessage(FixPContext fixPContext) {
        byte[] bytes;
        BinaryEntryPointContext context = (BinaryEntryPointContext)fixPContext;
        if (context.fromNegotiate()) {
            bytes = this.initBytes(50);
            this.negotiate.wrapAndApplyHeader(this.buffer, 4, this.beMessageHeader).sessionID(context.sessionID()).sessionVerID(context.sessionVerID()).timestamp().time(context.requestTimestampInNs());
            this.negotiate.enteringFirm(context.enteringFirm());
            this.negotiate.onbehalfFirm(NegotiateEncoder.onbehalfFirmNullValue());
            this.negotiate.senderLocation("");
        } else {
            bytes = this.initBytes(53);
            this.establish.wrapAndApplyHeader(this.buffer, 4, this.beMessageHeader).sessionID(context.sessionID()).sessionVerID(context.sessionVerID()).timestamp().time(context.requestTimestampInNs());
            this.establish.keepAliveInterval().time(0L);
            this.establish.nextSeqNo(EstablishEncoder.nextSeqNoNullValue()).cancelOnDisconnectType(CancelOnDisconnectType.DO_NOT_CANCEL_ON_DISCONNECT_OR_TERMINATE).codTimeoutWindow().time(0L);
        }
        return bytes;
    }

    private byte[] initBytes(int length) {
        byte[] bytes = new byte[length];
        this.buffer.wrap(bytes);
        SimpleOpenFramingHeader.writeSofh(this.buffer, 0, 50, (short)-5296);
        return bytes;
    }
}

