/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.DirectBufferVector;
import io.aeron.ReservedValueSupplier;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.HeaderWriter;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.nio.ByteOrder;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.UnsafeBuffer;

public final class TermAppender {
    public static final int FAILED = -2;
    private final long tailAddressOffset;
    private final UnsafeBuffer termBuffer;

    public TermAppender(UnsafeBuffer termBuffer, UnsafeBuffer metaDataBuffer, int partitionIndex) {
        int tailCounterOffset = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + partitionIndex * 8;
        metaDataBuffer.boundsCheck(tailCounterOffset, 8);
        this.termBuffer = termBuffer;
        this.tailAddressOffset = metaDataBuffer.addressOffset() + (long)tailCounterOffset;
    }

    public long rawTailVolatile() {
        return UnsafeAccess.UNSAFE.getLongVolatile(null, this.tailAddressOffset);
    }

    public int claim(HeaderWriter header, int length, BufferClaim bufferClaim, int activeTermId) {
        int frameLength = length + 32;
        int alignedLength = BitUtil.align(frameLength, 32);
        UnsafeBuffer termBuffer = this.termBuffer;
        int termLength = termBuffer.capacity();
        long rawTail = this.getAndAddRawTail(alignedLength);
        int termId = LogBufferDescriptor.termId(rawTail);
        long termOffset = rawTail & 0xFFFFFFFFL;
        TermAppender.checkTerm(activeTermId, termId);
        long resultingOffset = termOffset + (long)alignedLength;
        if (resultingOffset > (long)termLength) {
            resultingOffset = TermAppender.handleEndOfLogCondition(termBuffer, termOffset, header, termLength, termId);
        } else {
            int frameOffset = (int)termOffset;
            header.write(termBuffer, frameOffset, frameLength, termId);
            bufferClaim.wrap(termBuffer, frameOffset, frameLength);
        }
        return (int)resultingOffset;
    }

    public int appendUnfragmentedMessage(HeaderWriter header, DirectBuffer bufferOne, int offsetOne, int lengthOne, DirectBuffer bufferTwo, int offsetTwo, int lengthTwo, ReservedValueSupplier reservedValueSupplier, int activeTermId) {
        int frameLength = lengthOne + lengthTwo + 32;
        int alignedLength = BitUtil.align(frameLength, 32);
        UnsafeBuffer termBuffer = this.termBuffer;
        int termLength = termBuffer.capacity();
        long rawTail = this.getAndAddRawTail(alignedLength);
        int termId = LogBufferDescriptor.termId(rawTail);
        long termOffset = rawTail & 0xFFFFFFFFL;
        TermAppender.checkTerm(activeTermId, termId);
        long resultingOffset = termOffset + (long)alignedLength;
        if (resultingOffset > (long)termLength) {
            resultingOffset = TermAppender.handleEndOfLogCondition(termBuffer, termOffset, header, termLength, termId);
        } else {
            int frameOffset = (int)termOffset;
            header.write(termBuffer, frameOffset, frameLength, termId);
            termBuffer.putBytes(frameOffset + 32, bufferOne, offsetOne, lengthOne);
            termBuffer.putBytes(frameOffset + 32 + lengthOne, bufferTwo, offsetTwo, lengthTwo);
            if (null != reservedValueSupplier) {
                long reservedValue = reservedValueSupplier.get(termBuffer, frameOffset, frameLength);
                termBuffer.putLong(frameOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(termBuffer, frameOffset, frameLength);
        }
        return (int)resultingOffset;
    }

    public int appendUnfragmentedMessage(HeaderWriter header, DirectBuffer buffer, int offset, int length, ReservedValueSupplier reservedValueSupplier, int activeTermId) {
        int frameLength = length + 32;
        int alignedLength = BitUtil.align(frameLength, 32);
        UnsafeBuffer termBuffer = this.termBuffer;
        int termLength = termBuffer.capacity();
        long rawTail = this.getAndAddRawTail(alignedLength);
        int termId = LogBufferDescriptor.termId(rawTail);
        long termOffset = rawTail & 0xFFFFFFFFL;
        TermAppender.checkTerm(activeTermId, termId);
        long resultingOffset = termOffset + (long)alignedLength;
        if (resultingOffset > (long)termLength) {
            resultingOffset = TermAppender.handleEndOfLogCondition(termBuffer, termOffset, header, termLength, termId);
        } else {
            int frameOffset = (int)termOffset;
            header.write(termBuffer, frameOffset, frameLength, termId);
            termBuffer.putBytes(frameOffset + 32, buffer, offset, length);
            if (null != reservedValueSupplier) {
                long reservedValue = reservedValueSupplier.get(termBuffer, frameOffset, frameLength);
                termBuffer.putLong(frameOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(termBuffer, frameOffset, frameLength);
        }
        return (int)resultingOffset;
    }

    public int appendUnfragmentedMessage(HeaderWriter header, DirectBufferVector[] vectors, int length, ReservedValueSupplier reservedValueSupplier, int activeTermId) {
        int frameLength = length + 32;
        int alignedLength = BitUtil.align(frameLength, 32);
        UnsafeBuffer termBuffer = this.termBuffer;
        int termLength = termBuffer.capacity();
        long rawTail = this.getAndAddRawTail(alignedLength);
        int termId = LogBufferDescriptor.termId(rawTail);
        long termOffset = rawTail & 0xFFFFFFFFL;
        TermAppender.checkTerm(activeTermId, termId);
        long resultingOffset = termOffset + (long)alignedLength;
        if (resultingOffset > (long)termLength) {
            resultingOffset = TermAppender.handleEndOfLogCondition(termBuffer, termOffset, header, termLength, termId);
        } else {
            int frameOffset = (int)termOffset;
            header.write(termBuffer, frameOffset, frameLength, termId);
            int offset = frameOffset + 32;
            for (DirectBufferVector vector : vectors) {
                termBuffer.putBytes(offset, vector.buffer(), vector.offset(), vector.length());
                offset += vector.length();
            }
            if (null != reservedValueSupplier) {
                long reservedValue = reservedValueSupplier.get(termBuffer, frameOffset, frameLength);
                termBuffer.putLong(frameOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(termBuffer, frameOffset, frameLength);
        }
        return (int)resultingOffset;
    }

    public int appendFragmentedMessage(HeaderWriter header, DirectBuffer buffer, int offset, int length, int maxPayloadLength, ReservedValueSupplier reservedValueSupplier, int activeTermId) {
        int numMaxPayloads = length / maxPayloadLength;
        int remainingPayload = length % maxPayloadLength;
        int lastFrameLength = remainingPayload > 0 ? BitUtil.align(remainingPayload + 32, 32) : 0;
        int requiredLength = numMaxPayloads * (maxPayloadLength + 32) + lastFrameLength;
        UnsafeBuffer termBuffer = this.termBuffer;
        int termLength = termBuffer.capacity();
        long rawTail = this.getAndAddRawTail(requiredLength);
        int termId = LogBufferDescriptor.termId(rawTail);
        long termOffset = rawTail & 0xFFFFFFFFL;
        TermAppender.checkTerm(activeTermId, termId);
        long resultingOffset = termOffset + (long)requiredLength;
        if (resultingOffset > (long)termLength) {
            resultingOffset = TermAppender.handleEndOfLogCondition(termBuffer, termOffset, header, termLength, termId);
        } else {
            int bytesToWrite;
            int frameOffset = (int)termOffset;
            byte flags = -128;
            int remaining = length;
            do {
                bytesToWrite = Math.min(remaining, maxPayloadLength);
                int frameLength = bytesToWrite + 32;
                int alignedLength = BitUtil.align(frameLength, 32);
                header.write(termBuffer, frameOffset, frameLength, termId);
                termBuffer.putBytes(frameOffset + 32, buffer, offset + (length - remaining), bytesToWrite);
                if (remaining <= maxPayloadLength) {
                    flags = (byte)(flags | 0x40);
                }
                FrameDescriptor.frameFlags(termBuffer, frameOffset, flags);
                if (null != reservedValueSupplier) {
                    long reservedValue = reservedValueSupplier.get(termBuffer, frameOffset, frameLength);
                    termBuffer.putLong(frameOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
                }
                FrameDescriptor.frameLengthOrdered(termBuffer, frameOffset, frameLength);
                flags = 0;
                frameOffset += alignedLength;
            } while ((remaining -= bytesToWrite) > 0);
        }
        return (int)resultingOffset;
    }

    public int appendFragmentedMessage(HeaderWriter header, DirectBuffer bufferOne, int offsetOne, int lengthOne, DirectBuffer bufferTwo, int offsetTwo, int lengthTwo, int maxPayloadLength, ReservedValueSupplier reservedValueSupplier, int activeTermId) {
        int length = lengthOne + lengthTwo;
        int numMaxPayloads = length / maxPayloadLength;
        int remainingPayload = length % maxPayloadLength;
        int lastFrameLength = remainingPayload > 0 ? BitUtil.align(remainingPayload + 32, 32) : 0;
        int requiredLength = numMaxPayloads * (maxPayloadLength + 32) + lastFrameLength;
        UnsafeBuffer termBuffer = this.termBuffer;
        int termLength = termBuffer.capacity();
        long rawTail = this.getAndAddRawTail(requiredLength);
        int termId = LogBufferDescriptor.termId(rawTail);
        long termOffset = rawTail & 0xFFFFFFFFL;
        TermAppender.checkTerm(activeTermId, termId);
        long resultingOffset = termOffset + (long)requiredLength;
        if (resultingOffset > (long)termLength) {
            resultingOffset = TermAppender.handleEndOfLogCondition(termBuffer, termOffset, header, termLength, termId);
        } else {
            int bytesToWrite;
            int frameOffset = (int)termOffset;
            byte flags = -128;
            int remaining = length;
            int positionOne = 0;
            int positionTwo = 0;
            do {
                bytesToWrite = Math.min(remaining, maxPayloadLength);
                int frameLength = bytesToWrite + 32;
                int alignedLength = BitUtil.align(frameLength, 32);
                header.write(termBuffer, frameOffset, frameLength, termId);
                int bytesWritten = 0;
                int payloadOffset = frameOffset + 32;
                do {
                    int numBytes;
                    int remainingOne;
                    if ((remainingOne = lengthOne - positionOne) > 0) {
                        numBytes = Math.min(bytesToWrite - bytesWritten, remainingOne);
                        termBuffer.putBytes(payloadOffset, bufferOne, offsetOne + positionOne, numBytes);
                        bytesWritten += numBytes;
                        payloadOffset += numBytes;
                        positionOne += numBytes;
                        continue;
                    }
                    numBytes = Math.min(bytesToWrite - bytesWritten, lengthTwo - positionTwo);
                    termBuffer.putBytes(payloadOffset, bufferTwo, offsetTwo + positionTwo, numBytes);
                    bytesWritten += numBytes;
                    payloadOffset += numBytes;
                    positionTwo += numBytes;
                } while (bytesWritten < bytesToWrite);
                if (remaining <= maxPayloadLength) {
                    flags = (byte)(flags | 0x40);
                }
                FrameDescriptor.frameFlags(termBuffer, frameOffset, flags);
                if (null != reservedValueSupplier) {
                    long reservedValue = reservedValueSupplier.get(termBuffer, frameOffset, frameLength);
                    termBuffer.putLong(frameOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
                }
                FrameDescriptor.frameLengthOrdered(termBuffer, frameOffset, frameLength);
                flags = 0;
                frameOffset += alignedLength;
            } while ((remaining -= bytesToWrite) > 0);
        }
        return (int)resultingOffset;
    }

    public int appendFragmentedMessage(HeaderWriter header, DirectBufferVector[] vectors, int length, int maxPayloadLength, ReservedValueSupplier reservedValueSupplier, int activeTermId) {
        int numMaxPayloads = length / maxPayloadLength;
        int remainingPayload = length % maxPayloadLength;
        int lastFrameLength = remainingPayload > 0 ? BitUtil.align(remainingPayload + 32, 32) : 0;
        int requiredLength = numMaxPayloads * (maxPayloadLength + 32) + lastFrameLength;
        UnsafeBuffer termBuffer = this.termBuffer;
        int termLength = termBuffer.capacity();
        long rawTail = this.getAndAddRawTail(requiredLength);
        int termId = LogBufferDescriptor.termId(rawTail);
        long termOffset = rawTail & 0xFFFFFFFFL;
        TermAppender.checkTerm(activeTermId, termId);
        long resultingOffset = termOffset + (long)requiredLength;
        if (resultingOffset > (long)termLength) {
            resultingOffset = TermAppender.handleEndOfLogCondition(termBuffer, termOffset, header, termLength, termId);
        } else {
            int bytesToWrite;
            int frameOffset = (int)termOffset;
            byte flags = -128;
            int remaining = length;
            int vectorIndex = 0;
            int vectorOffset = 0;
            do {
                bytesToWrite = Math.min(remaining, maxPayloadLength);
                int frameLength = bytesToWrite + 32;
                int alignedLength = BitUtil.align(frameLength, 32);
                header.write(termBuffer, frameOffset, frameLength, termId);
                int bytesWritten = 0;
                int payloadOffset = frameOffset + 32;
                do {
                    DirectBufferVector vector = vectors[vectorIndex];
                    int vectorRemaining = vector.length() - vectorOffset;
                    int numBytes = Math.min(bytesToWrite - bytesWritten, vectorRemaining);
                    termBuffer.putBytes(payloadOffset, vector.buffer(), vector.offset() + vectorOffset, numBytes);
                    bytesWritten += numBytes;
                    payloadOffset += numBytes;
                    vectorOffset += numBytes;
                    if (vectorRemaining > numBytes) continue;
                    ++vectorIndex;
                    vectorOffset = 0;
                } while (bytesWritten < bytesToWrite);
                if (remaining <= maxPayloadLength) {
                    flags = (byte)(flags | 0x40);
                }
                FrameDescriptor.frameFlags(termBuffer, frameOffset, flags);
                if (null != reservedValueSupplier) {
                    long reservedValue = reservedValueSupplier.get(termBuffer, frameOffset, frameLength);
                    termBuffer.putLong(frameOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
                }
                FrameDescriptor.frameLengthOrdered(termBuffer, frameOffset, frameLength);
                flags = 0;
                frameOffset += alignedLength;
            } while ((remaining -= bytesToWrite) > 0);
        }
        return (int)resultingOffset;
    }

    private static void checkTerm(int expectedTermId, int termId) {
        if (termId != expectedTermId) {
            throw new AeronException("action possibly delayed: expectedTermId=" + expectedTermId + " termId=" + termId);
        }
    }

    private static int handleEndOfLogCondition(UnsafeBuffer termBuffer, long termOffset, HeaderWriter header, int termLength, int termId) {
        if (termOffset < (long)termLength) {
            int offset = (int)termOffset;
            int paddingLength = termLength - offset;
            header.write(termBuffer, offset, paddingLength, termId);
            FrameDescriptor.frameType(termBuffer, offset, 0);
            FrameDescriptor.frameLengthOrdered(termBuffer, offset, paddingLength);
        }
        return -2;
    }

    private long getAndAddRawTail(int alignedLength) {
        return UnsafeAccess.UNSAFE.getAndAddLong(null, this.tailAddressOffset, alignedLength);
    }
}

