/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.NameResolver;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.agrona.AsciiEncoding;
import org.agrona.Strings;

class SocketAddressParser {
    SocketAddressParser() {
    }

    static InetSocketAddress parse(String value, String uriParamName, boolean isReResolution, NameResolver nameResolver) {
        if (Strings.isEmpty(value)) {
            throw new NullPointerException("input string must not be null or empty");
        }
        String nameAndPort = nameResolver.lookup(value, uriParamName, isReResolution);
        InetSocketAddress address = SocketAddressParser.tryParseIpV4(nameAndPort, uriParamName, isReResolution, nameResolver);
        if (null == address) {
            address = SocketAddressParser.tryParseIpV6(nameAndPort, uriParamName, isReResolution, nameResolver);
        }
        if (null == address) {
            throw new IllegalArgumentException("invalid format: " + value);
        }
        return address;
    }

    private static InetSocketAddress tryParseIpV4(String str, String uriParamName, boolean isReResolution, NameResolver nameResolver) {
        IpV4State state = IpV4State.HOST;
        int separatorIndex = -1;
        int length = str.length();
        block4: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (state) {
                case HOST: {
                    if (':' != c) continue block4;
                    separatorIndex = i;
                    state = IpV4State.PORT;
                    continue block4;
                }
                case PORT: {
                    if (':' == c) {
                        return null;
                    }
                    if (c >= '0' && '9' >= c) continue block4;
                    return null;
                }
            }
        }
        if (-1 != separatorIndex && 1 < length - separatorIndex) {
            String hostname = str.substring(0, separatorIndex);
            int portIndex = separatorIndex + 1;
            int port = AsciiEncoding.parseIntAscii(str, portIndex, length - portIndex);
            InetAddress inetAddress = nameResolver.resolve(hostname, uriParamName, isReResolution);
            return null == inetAddress ? InetSocketAddress.createUnresolved(hostname, port) : new InetSocketAddress(inetAddress, port);
        }
        throw new IllegalArgumentException("address 'port' is required for ipv4: " + str);
    }

    private static InetSocketAddress tryParseIpV6(String str, String uriParamName, boolean isReResolution, NameResolver nameResolver) {
        IpV6State state = IpV6State.START_ADDR;
        int portIndex = -1;
        int scopeIndex = -1;
        int length = str.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (state) {
                case START_ADDR: {
                    if ('[' == c) {
                        state = IpV6State.HOST;
                        continue block7;
                    }
                    return null;
                }
                case HOST: {
                    if (']' == c) {
                        state = IpV6State.END_ADDR;
                        continue block7;
                    }
                    if ('%' == c) {
                        scopeIndex = i;
                        state = IpV6State.SCOPE;
                        continue block7;
                    }
                    if (':' == c || c >= 'a' && 'f' >= c || c >= 'A' && 'F' >= c || c >= '0' && '9' >= c) continue block7;
                    return null;
                }
                case SCOPE: {
                    if (']' == c) {
                        state = IpV6State.END_ADDR;
                        continue block7;
                    }
                    if ('_' == c || '.' == c || '~' == c || '-' == c || c >= 'a' && 'z' >= c || c >= 'A' && 'Z' >= c || c >= '0' && '9' >= c) continue block7;
                    return null;
                }
                case END_ADDR: {
                    if (':' == c) {
                        portIndex = i;
                        state = IpV6State.PORT;
                        continue block7;
                    }
                    return null;
                }
                case PORT: {
                    if (':' == c) {
                        return null;
                    }
                    if (c >= '0' && '9' >= c) continue block7;
                    return null;
                }
            }
        }
        if (-1 != portIndex && 1 < length - portIndex) {
            String hostname = str.substring(1, scopeIndex != -1 ? scopeIndex : portIndex - 1);
            int port = AsciiEncoding.parseIntAscii(str, ++portIndex, length - portIndex);
            InetAddress inetAddress = nameResolver.resolve(hostname, uriParamName, isReResolution);
            return null == inetAddress ? InetSocketAddress.createUnresolved(hostname, port) : new InetSocketAddress(inetAddress, port);
        }
        throw new IllegalArgumentException("address 'port' is required for ipv6: " + str);
    }

    static enum IpV6State {
        START_ADDR,
        HOST,
        SCOPE,
        END_ADDR,
        PORT;

    }

    static enum IpV4State {
        HOST,
        PORT;

    }
}

