/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.media.DataTransportPoller;
import io.aeron.driver.media.ImageConnection;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationTransport;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpChannelTransport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.collections.ArrayUtil;

final class MultiRcvDestination {
    private static final ReceiveDestinationTransport[] EMPTY_TRANSPORTS = new ReceiveDestinationTransport[0];
    private int numDestinations = 0;
    private ReceiveDestinationTransport[] transports = EMPTY_TRANSPORTS;

    MultiRcvDestination() {
    }

    void close(ErrorHandler errorHandler, DataTransportPoller poller) {
        for (ReceiveDestinationTransport transport : this.transports) {
            CloseHelper.close(errorHandler, transport);
            if (null == poller) continue;
            poller.selectNowWithoutProcessing();
        }
    }

    int addDestination(ReceiveDestinationTransport transport) {
        int index = this.transports.length;
        int length = this.transports.length;
        for (int i = 0; i < length; ++i) {
            if (null != this.transports[i]) continue;
            index = i;
            break;
        }
        this.transports = ArrayUtil.ensureCapacity(this.transports, index + 1);
        this.transports[index] = transport;
        ++this.numDestinations;
        return index;
    }

    void removeDestination(int transportIndex) {
        this.transports[transportIndex] = null;
        --this.numDestinations;
    }

    boolean hasDestination(int transportIndex) {
        return this.numDestinations > transportIndex && null != this.transports[transportIndex];
    }

    ReceiveDestinationTransport transport(int transportIndex) {
        return this.transports[transportIndex];
    }

    int transport(UdpChannel udpChannel) {
        ReceiveDestinationTransport[] transports = this.transports;
        int index = -1;
        int length = transports.length;
        for (int i = 0; i < length; ++i) {
            ReceiveDestinationTransport transport = transports[i];
            if (null == transport || !transport.udpChannel().equals(udpChannel)) continue;
            index = i;
            break;
        }
        return index;
    }

    void checkForReResolution(ReceiveChannelEndpoint channelEndpoint, long nowNs, DriverConductorProxy conductorProxy) {
        for (ReceiveDestinationTransport transport : this.transports) {
            UdpChannel udpChannel;
            if (null == transport || !(udpChannel = transport.udpChannel()).hasExplicitControl() || transport.timeOfLastActivityNs() + ReceiveChannelEndpoint.DESTINATION_ADDRESS_TIMEOUT >= nowNs) continue;
            transport.timeOfLastActivityNs(nowNs);
            conductorProxy.reResolveControl(udpChannel.channelUri().get("control"), udpChannel, channelEndpoint, transport.currentControlAddress());
        }
    }

    void updateControlAddress(int transportIndex, InetSocketAddress newAddress) {
        ReceiveDestinationTransport transport;
        if (-1 != transportIndex && null != (transport = this.transports[transportIndex])) {
            transport.currentControlAddress(newAddress);
        }
    }

    int sendToAll(ImageConnection[] imageConnections, ByteBuffer buffer, int bytesToSend, long nowNs) {
        int lastIndex;
        ReceiveDestinationTransport[] transports = this.transports;
        int minBytesSent = bytesToSend;
        for (int i = lastIndex = imageConnections.length - 1; i >= 0; --i) {
            ReceiveDestinationTransport transport;
            ImageConnection connection = imageConnections[i];
            if (null == connection || null == (transport = transports[i]) || connection.timeOfLastActivityNs + ReceiveChannelEndpoint.DESTINATION_ADDRESS_TIMEOUT - nowNs <= 0L) continue;
            buffer.position(0);
            minBytesSent = Math.min(minBytesSent, MultiRcvDestination.sendTo(transport, buffer, connection.controlAddress));
        }
        return minBytesSent;
    }

    static int sendTo(UdpChannelTransport transport, ByteBuffer buffer, InetSocketAddress remoteAddress) {
        int remaining = buffer.remaining();
        int bytesSent = 0;
        try {
            if (null != transport && null != transport.sendDatagramChannel && transport.sendDatagramChannel.isOpen()) {
                transport.sendHook(buffer, remoteAddress);
                bytesSent = transport.sendDatagramChannel.send(buffer, remoteAddress);
            }
        }
        catch (IOException ex) {
            UdpChannelTransport.sendError(remaining, ex, remoteAddress);
        }
        return bytesSent;
    }
}

