/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.ChannelUri;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.media.Destination;
import io.aeron.driver.media.MultiSndDestination;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.CachedNanoClock;

class ManualSndMultiDestination
extends MultiSndDestination {
    ManualSndMultiDestination(CachedNanoClock nanoClock) {
        super(nanoClock);
    }

    @Override
    void onStatusMessage(StatusMessageFlyweight msg, InetSocketAddress address) {
        long receiverId = msg.receiverId();
        long nowNs = this.nanoClock.nanoTime();
        for (Destination destination : this.destinations) {
            if (destination.isReceiverIdValid && receiverId == destination.receiverId && address.getPort() == destination.port) {
                destination.timeOfLastActivityNs = nowNs;
                break;
            }
            if (destination.isReceiverIdValid || address.getPort() != destination.port || !address.getAddress().equals(destination.address.getAddress())) continue;
            destination.timeOfLastActivityNs = nowNs;
            destination.receiverId = receiverId;
            destination.isReceiverIdValid = true;
            break;
        }
    }

    @Override
    int send(DatagramChannel channel, ByteBuffer buffer, SendChannelEndpoint channelEndpoint, int bytesToSend) {
        int position = buffer.position();
        int minBytesSent = bytesToSend;
        for (Destination destination : this.destinations) {
            int bytesSent = ManualSndMultiDestination.send(channel, buffer, channelEndpoint, bytesToSend, position, destination.address);
            minBytesSent = Math.min(minBytesSent, bytesSent);
        }
        return minBytesSent;
    }

    @Override
    void addDestination(ChannelUri channelUri, InetSocketAddress address) {
        this.destinations = ArrayUtil.add(this.destinations, new Destination(this.nanoClock.nanoTime(), channelUri, address));
    }

    @Override
    void removeDestination(ChannelUri channelUri, InetSocketAddress address) {
        boolean found = false;
        int index = 0;
        for (Destination destination : this.destinations) {
            if (destination.address.equals(address)) {
                found = true;
                break;
            }
            ++index;
        }
        if (found) {
            this.destinations = 1 == this.destinations.length ? EMPTY_DESTINATIONS : ArrayUtil.remove(this.destinations, index);
        }
    }

    @Override
    void checkForReResolution(SendChannelEndpoint channelEndpoint, long nowNs, DriverConductorProxy conductorProxy) {
        for (Destination destination : this.destinations) {
            if (destination.timeOfLastActivityNs + SendChannelEndpoint.DESTINATION_TIMEOUT - nowNs >= 0L) continue;
            destination.timeOfLastActivityNs = nowNs;
            String endpoint = destination.channelUri.get("endpoint");
            conductorProxy.reResolveEndpoint(endpoint, channelEndpoint, destination.address);
        }
    }

    @Override
    void updateDestination(String endpoint, InetSocketAddress newAddress) {
        for (Destination destination : this.destinations) {
            if (!endpoint.equals(destination.channelUri.get("endpoint"))) continue;
            destination.address = newAddress;
            destination.port = newAddress.getPort();
        }
    }
}

