/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.media.UdpTransportPoller;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.UnsafeBuffer;

public final class ControlTransportPoller
extends UdpTransportPoller {
    private final ByteBuffer byteBuffer = BufferUtil.allocateDirectAligned(65504, 64);
    private final UnsafeBuffer unsafeBuffer = new UnsafeBuffer(this.byteBuffer);
    private final NakFlyweight nakMessage = new NakFlyweight(this.unsafeBuffer);
    private final StatusMessageFlyweight statusMessage = new StatusMessageFlyweight(this.unsafeBuffer);
    private final RttMeasurementFlyweight rttMeasurement = new RttMeasurementFlyweight(this.unsafeBuffer);
    private SendChannelEndpoint[] transports = new SendChannelEndpoint[0];

    public ControlTransportPoller(ErrorHandler errorHandler) {
        super(errorHandler);
    }

    @Override
    public void close() {
        CloseHelper.closeAll(this.errorHandler, (AutoCloseable[])this.transports);
        super.close();
    }

    @Override
    public int pollTransports() {
        int bytesReceived = 0;
        try {
            if (this.transports.length <= ITERATION_THRESHOLD) {
                for (SendChannelEndpoint transport : this.transports) {
                    bytesReceived += this.poll(transport);
                }
            } else {
                this.selector.selectNow();
                SelectionKey[] keys = this.selectedKeySet.keys();
                int length = this.selectedKeySet.size();
                for (int i = 0; i < length; ++i) {
                    bytesReceived += this.poll((SendChannelEndpoint)keys[i].attachment());
                }
                this.selectedKeySet.reset();
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return bytesReceived;
    }

    @Override
    public SelectionKey registerForRead(UdpChannelTransport transport) {
        return this.registerForRead((SendChannelEndpoint)transport);
    }

    public SelectionKey registerForRead(SendChannelEndpoint transport) {
        SelectionKey key = null;
        try {
            key = transport.receiveDatagramChannel().register(this.selector, 1, transport);
            this.transports = ArrayUtil.add(this.transports, transport);
        }
        catch (ClosedChannelException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return key;
    }

    @Override
    public void cancelRead(UdpChannelTransport transport) {
        this.cancelRead((SendChannelEndpoint)transport);
    }

    public void cancelRead(SendChannelEndpoint transport) {
        this.transports = ArrayUtil.remove(this.transports, transport);
    }

    public void checkForReResolutions(long nowNs, DriverConductorProxy conductorProxy) {
        for (SendChannelEndpoint transport : this.transports) {
            transport.checkForReResolution(nowNs, conductorProxy);
        }
    }

    private int poll(SendChannelEndpoint channelEndpoint) {
        int bytesReceived = 0;
        InetSocketAddress srcAddress = channelEndpoint.receive(this.byteBuffer);
        if (null != srcAddress && channelEndpoint.isValidFrame(this.unsafeBuffer, bytesReceived = this.byteBuffer.position())) {
            channelEndpoint.receiveHook(this.unsafeBuffer, bytesReceived, srcAddress);
            int frameType = FrameDescriptor.frameType(this.unsafeBuffer, 0);
            if (2 == frameType) {
                channelEndpoint.onNakMessage(this.nakMessage, this.unsafeBuffer, bytesReceived, srcAddress);
            } else if (3 == frameType) {
                channelEndpoint.onStatusMessage(this.statusMessage, this.unsafeBuffer, bytesReceived, srcAddress);
            } else if (6 == frameType) {
                channelEndpoint.onRttMeasurement(this.rttMeasurement, this.unsafeBuffer, bytesReceived, srcAddress);
            }
        }
        return bytesReceived;
    }
}

