/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ChannelUri;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.Sender;
import io.aeron.driver.ThreadingMode;
import io.aeron.driver.media.SendChannelEndpoint;
import java.net.InetSocketAddress;
import java.util.Queue;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.status.AtomicCounter;

final class SenderProxy {
    private final ThreadingMode threadingMode;
    private final Queue<Runnable> commandQueue;
    private final AtomicCounter failCount;
    private Sender sender;

    SenderProxy(ThreadingMode threadingMode, Queue<Runnable> commandQueue, AtomicCounter failCount) {
        this.threadingMode = threadingMode;
        this.commandQueue = commandQueue;
        this.failCount = failCount;
    }

    void sender(Sender sender) {
        this.sender = sender;
    }

    void registerSendChannelEndpoint(SendChannelEndpoint channelEndpoint) {
        if (this.notConcurrent()) {
            this.sender.onRegisterSendChannelEndpoint(channelEndpoint);
        } else {
            this.offer(() -> this.sender.onRegisterSendChannelEndpoint(channelEndpoint));
        }
    }

    void closeSendChannelEndpoint(SendChannelEndpoint channelEndpoint) {
        if (this.notConcurrent()) {
            this.sender.onCloseSendChannelEndpoint(channelEndpoint);
        } else {
            this.offer(() -> this.sender.onCloseSendChannelEndpoint(channelEndpoint));
        }
    }

    void removeNetworkPublication(NetworkPublication publication) {
        if (this.notConcurrent()) {
            this.sender.onRemoveNetworkPublication(publication);
        } else {
            this.offer(() -> this.sender.onRemoveNetworkPublication(publication));
        }
    }

    void newNetworkPublication(NetworkPublication publication) {
        if (this.notConcurrent()) {
            this.sender.onNewNetworkPublication(publication);
        } else {
            this.offer(() -> this.sender.onNewNetworkPublication(publication));
        }
    }

    void addDestination(SendChannelEndpoint channelEndpoint, ChannelUri channelUri, InetSocketAddress address) {
        if (this.notConcurrent()) {
            this.sender.onAddDestination(channelEndpoint, channelUri, address);
        } else {
            this.offer(() -> this.sender.onAddDestination(channelEndpoint, channelUri, address));
        }
    }

    void removeDestination(SendChannelEndpoint channelEndpoint, ChannelUri channelUri, InetSocketAddress address) {
        if (this.notConcurrent()) {
            this.sender.onRemoveDestination(channelEndpoint, channelUri, address);
        } else {
            this.offer(() -> this.sender.onRemoveDestination(channelEndpoint, channelUri, address));
        }
    }

    void onResolutionChange(SendChannelEndpoint channelEndpoint, String endpoint, InetSocketAddress newAddress) {
        if (this.notConcurrent()) {
            this.sender.onResolutionChange(channelEndpoint, endpoint, newAddress);
        } else {
            this.offer(() -> this.sender.onResolutionChange(channelEndpoint, endpoint, newAddress));
        }
    }

    private boolean notConcurrent() {
        return this.threadingMode == ThreadingMode.SHARED || this.threadingMode == ThreadingMode.INVOKER;
    }

    private void offer(Runnable cmd) {
        while (!this.commandQueue.offer(cmd)) {
            if (!this.failCount.isClosed()) {
                this.failCount.increment();
            }
            Thread.yield();
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new AgentTerminationException("interrupted");
        }
    }
}

