/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FeedbackDelayGenerator;
import io.aeron.driver.RetransmitSender;
import org.agrona.collections.BiInt2ObjectMap;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.status.AtomicCounter;

public final class RetransmitHandler {
    private final BiInt2ObjectMap<RetransmitAction> activeRetransmitsMap = new BiInt2ObjectMap();
    private final RetransmitAction[] retransmitActionPool = new RetransmitAction[16];
    private final NanoClock nanoClock;
    private final FeedbackDelayGenerator delayGenerator;
    private final FeedbackDelayGenerator lingerTimeoutGenerator;
    private final AtomicCounter invalidPackets;

    public RetransmitHandler(NanoClock nanoClock, AtomicCounter invalidPackets, FeedbackDelayGenerator delayGenerator, FeedbackDelayGenerator lingerTimeoutGenerator) {
        this.nanoClock = nanoClock;
        this.invalidPackets = invalidPackets;
        this.delayGenerator = delayGenerator;
        this.lingerTimeoutGenerator = lingerTimeoutGenerator;
        for (int i = 0; i < 16; ++i) {
            this.retransmitActionPool[i] = new RetransmitAction();
        }
    }

    public void onNak(int termId, int termOffset, int length, int termLength, RetransmitSender retransmitSender) {
        if (!this.isInvalid(termOffset, termLength) && null == this.activeRetransmitsMap.get(termId, termOffset) && this.activeRetransmitsMap.size() < 16) {
            RetransmitAction action = this.assignRetransmitAction();
            action.termId = termId;
            action.termOffset = termOffset;
            action.length = Math.min(length, termLength - termOffset);
            long delay = this.delayGenerator.generateDelay();
            if (0L == delay) {
                retransmitSender.resend(termId, termOffset, action.length);
                action.linger(this.lingerTimeoutGenerator.generateDelay(), this.nanoClock.nanoTime());
            } else {
                action.delay(delay, this.nanoClock.nanoTime());
            }
            this.activeRetransmitsMap.put(termId, termOffset, action);
        }
    }

    public void onRetransmitReceived(int termId, int termOffset) {
        RetransmitAction action = this.activeRetransmitsMap.get(termId, termOffset);
        if (null != action && State.DELAYED == action.state) {
            this.activeRetransmitsMap.remove(termId, termOffset);
            action.cancel();
        }
    }

    public void processTimeouts(long nowNs, RetransmitSender retransmitSender) {
        if (this.activeRetransmitsMap.size() > 0) {
            for (RetransmitAction action : this.retransmitActionPool) {
                if (State.DELAYED == action.state && action.expireNs - nowNs < 0L) {
                    retransmitSender.resend(action.termId, action.termOffset, action.length);
                    action.linger(this.lingerTimeoutGenerator.generateDelay(), this.nanoClock.nanoTime());
                    continue;
                }
                if (State.LINGERING != action.state || action.expireNs - nowNs >= 0L) continue;
                action.cancel();
                this.activeRetransmitsMap.remove(action.termId, action.termOffset);
            }
        }
    }

    private boolean isInvalid(int termOffset, int termLength) {
        boolean isInvalid;
        boolean bl = isInvalid = termOffset > termLength - 32 || termOffset < 0;
        if (isInvalid) {
            this.invalidPackets.increment();
        }
        return isInvalid;
    }

    private RetransmitAction assignRetransmitAction() {
        for (RetransmitAction action : this.retransmitActionPool) {
            if (State.INACTIVE != action.state) continue;
            return action;
        }
        throw new IllegalStateException("maximum number of active RetransmitActions reached");
    }

    static final class RetransmitAction {
        long expireNs;
        int termId;
        int termOffset;
        int length;
        State state = State.INACTIVE;

        RetransmitAction() {
        }

        void delay(long delayNs, long nowNs) {
            this.state = State.DELAYED;
            this.expireNs = nowNs + delayNs;
        }

        void linger(long timeoutNs, long nowNs) {
            this.state = State.LINGERING;
            this.expireNs = nowNs + timeoutNs;
        }

        void cancel() {
            this.state = State.INACTIVE;
        }
    }

    static enum State {
        DELAYED,
        LINGERING,
        INACTIVE;

    }
}

